/*
 * Decompiled with CFR 0.152.
 */
package org.playframework.playclipse.handlers;

import fr.zenexity.pdt.editors.EditorHelper;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.playframework.playclipse.FilesAccess;
import org.playframework.playclipse.Navigation;

public class GoToRouteHandler
extends AbstractHandler {
    private void fromEditor(ExecutionEvent event, EditorHelper editor) throws ExecutionException {
        String action = null;
        IProject project = editor.getProject();
        int lineNo = editor.getCurrentLineNo();
        String line = editor.getLine(lineNo);
        while (lineNo > 0 && action == null) {
            Pattern pt2;
            Matcher m2;
            if (!(line = editor.getLine(lineNo--)).contains("public") || !line.contains("static") || !line.contains("void") || !(m2 = (pt2 = Pattern.compile("\\w+\\s*\\(")).matcher(line)).find()) continue;
            String method = m2.group().replace("(", "").trim();
            String controller = editor.getTitle().replace(".java", "");
            action = String.valueOf(controller) + "." + method;
        }
        this.fromProject(event, project, action);
    }

    private void fromProject(ExecutionEvent event, IProject project, String action) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        IFile file = project.getFile("conf/routes");
        if (file.exists()) {
            try {
                IEditorPart editorPart = FilesAccess.openFile(file, window);
                if (action != null) {
                    FilesAccess.goToLineContaining(editorPart, action);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else {
            MessageDialog.openInformation((Shell)window.getShell(), (String)"Playclipse", (String)"The file conf/routes can't be found, create it first");
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        EditorHelper editor = EditorHelper.getCurrent(event);
        if (editor != null) {
            this.fromEditor(event, editor);
            return null;
        }
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            IProject project = Navigation.getProject((IStructuredSelection)selection);
            this.fromProject(event, project, null);
            return null;
        }
        return null;
    }
}

