/*
 * Decompiled with CFR 0.152.
 */
package org.playframework.playclipse.builder;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.playframework.playclipse.ModelInspector;
import org.playframework.playclipse.PlayPlugin;

public abstract class ErrorChecker {
    protected IFile file;
    private String preference;
    private IJavaProject javaProject = null;
    private ModelInspector inspector = null;

    public ErrorChecker() {
    }

    public ErrorChecker(IFile file) {
        this.file = file;
        this.preference = null;
    }

    public ErrorChecker(IFile file, String preference) {
        this.file = file;
        this.preference = preference;
    }

    protected IMarker addMarker(String message, int lineNumber, int severity) throws CoreException {
        IMarker marker = this.file.createMarker("org.eclipse.core.resources.problemmarker");
        marker.setAttribute("message", (Object)message);
        marker.setAttribute("severity", severity);
        if (lineNumber == -1) {
            lineNumber = 1;
        }
        marker.setAttribute("lineNumber", lineNumber);
        return marker;
    }

    protected IMarker addMarker(String message, int lineNumber, int severity, int begin, int end) throws CoreException {
        IMarker marker = this.addMarker(message, lineNumber, severity);
        marker.setAttribute("charStart", begin);
        marker.setAttribute("charEnd", end);
        return marker;
    }

    protected int getSeverity() {
        String severityStr = PlayPlugin.getDefault().getPreferenceStore().getString(this.preference);
        if (severityStr.equals("warning")) {
            return 1;
        }
        if (severityStr.equals("error")) {
            return 2;
        }
        return -1;
    }

    public abstract void check();

    protected IJavaProject getJavaProject() {
        if (this.javaProject == null) {
            this.javaProject = JavaCore.create((IProject)this.getProject());
        }
        return this.javaProject;
    }

    protected ModelInspector getInspector() {
        if (this.inspector == null) {
            this.inspector = new ModelInspector(this.getJavaProject());
        }
        return this.inspector;
    }

    protected IProject getProject() {
        IContainer container = this.file.getParent();
        while (container != null) {
            if (container instanceof IProject) {
                return (IProject)container;
            }
            container = container.getParent();
        }
        return null;
    }
}

