/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.codec;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.james.mime4j.codec.Base64OutputStream;
import org.apache.james.mime4j.codec.ByteQueue;

public class Base64InputStream
extends InputStream {
    private static Log log;
    private static final int ENCODED_BUFFER_SIZE = 1536;
    private static final int[] BASE64_DECODE;
    private static final byte BASE64_PAD = 61;
    private static final int EOF = -1;
    private final byte[] singleByte = new byte[1];
    private boolean strict;
    private final InputStream in;
    private boolean closed = false;
    private final byte[] encoded = new byte[1536];
    private int position = 0;
    private int size = 0;
    private final ByteQueue q = new ByteQueue();
    private boolean eof;

    public Base64InputStream(InputStream in) {
        this(in, false);
    }

    public Base64InputStream(InputStream in, boolean strict) {
        if (in == null) {
            throw new IllegalArgumentException();
        }
        this.in = in;
        this.strict = strict;
    }

    public int read() throws IOException {
        int bytes;
        if (this.closed) {
            throw new IOException("Base64InputStream has been closed");
        }
        do {
            if ((bytes = this.read0(this.singleByte, 0, 1)) != -1) continue;
            return -1;
        } while (bytes != 1);
        return this.singleByte[0] & 0xFF;
    }

    public int read(byte[] buffer) throws IOException {
        if (this.closed) {
            throw new IOException("Base64InputStream has been closed");
        }
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (buffer.length == 0) {
            return 0;
        }
        return this.read0(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.closed) {
            throw new IOException("Base64InputStream has been closed");
        }
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || length < 0 || offset + length > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return 0;
        }
        return this.read0(buffer, offset, offset + length);
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
    }

    private int read0(byte[] buffer, int from, int to) throws IOException {
        int index = from;
        int qCount = this.q.count();
        while (qCount-- > 0 && index < to) {
            buffer[index++] = this.q.dequeue();
        }
        if (this.eof) {
            return index == from ? -1 : index - from;
        }
        int data = 0;
        int sextets = 0;
        while (index < to) {
            while (this.position == this.size) {
                int n = this.in.read(this.encoded, 0, this.encoded.length);
                if (n == -1) {
                    this.eof = true;
                    if (sextets != 0) {
                        this.handleUnexpectedEof(sextets);
                    }
                    return index == from ? -1 : index - from;
                }
                if (n > 0) {
                    this.position = 0;
                    this.size = n;
                    continue;
                }
                assert (n == 0);
            }
            while (this.position < this.size && index < to) {
                int value;
                if ((value = this.encoded[this.position++] & 0xFF) == 61) {
                    index = this.decodePad(data, sextets, buffer, index, to);
                    return index - from;
                }
                int decoded = BASE64_DECODE[value];
                if (decoded < 0) continue;
                data = data << 6 | decoded;
                if (++sextets != 4) continue;
                sextets = 0;
                byte b1 = (byte)(data >>> 16);
                byte b2 = (byte)(data >>> 8);
                byte b3 = (byte)data;
                if (index < to - 2) {
                    buffer[index++] = b1;
                    buffer[index++] = b2;
                    buffer[index++] = b3;
                    continue;
                }
                if (index < to - 1) {
                    buffer[index++] = b1;
                    buffer[index++] = b2;
                    this.q.enqueue(b3);
                } else if (index < to) {
                    buffer[index++] = b1;
                    this.q.enqueue(b2);
                    this.q.enqueue(b3);
                } else {
                    this.q.enqueue(b1);
                    this.q.enqueue(b2);
                    this.q.enqueue(b3);
                }
                assert (index == to);
                return to - from;
            }
        }
        assert (sextets == 0);
        assert (index == to);
        return to - from;
    }

    private int decodePad(int data, int sextets, byte[] buffer, int index, int end) throws IOException {
        this.eof = true;
        if (sextets == 2) {
            byte b = (byte)(data >>> 4);
            if (index < end) {
                buffer[index++] = b;
            } else {
                this.q.enqueue(b);
            }
        } else if (sextets == 3) {
            byte b1 = (byte)(data >>> 10);
            byte b2 = (byte)(data >>> 2 & 0xFF);
            if (index < end - 1) {
                buffer[index++] = b1;
                buffer[index++] = b2;
            } else if (index < end) {
                buffer[index++] = b1;
                this.q.enqueue(b2);
            } else {
                this.q.enqueue(b1);
                this.q.enqueue(b2);
            }
        } else {
            this.handleUnexpecedPad(sextets);
        }
        return index;
    }

    private void handleUnexpectedEof(int sextets) throws IOException {
        if (this.strict) {
            throw new IOException("unexpected end of file");
        }
        log.warn((Object)("unexpected end of file; dropping " + sextets + " sextet(s)"));
    }

    private void handleUnexpecedPad(int sextets) throws IOException {
        if (this.strict) {
            throw new IOException("unexpected padding character");
        }
        log.warn((Object)("unexpected padding character; dropping " + sextets + " sextet(s)"));
    }

    static {
        int i;
        log = LogFactory.getLog(Base64InputStream.class);
        BASE64_DECODE = new int[256];
        for (i = 0; i < 256; ++i) {
            Base64InputStream.BASE64_DECODE[i] = -1;
        }
        for (i = 0; i < Base64OutputStream.BASE64_TABLE.length; ++i) {
            Base64InputStream.BASE64_DECODE[Base64OutputStream.BASE64_TABLE[i] & 0xFF] = i;
        }
    }
}

