/*
 * Decompiled with CFR 0.152.
 */
package mill.perk;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import mill.common.Kernel;
import mill.common.Nodes;
import mill.perk.BinaryModel;
import mill.perk.Cache;
import mill.perk.DualSupportVector;

public class DualBinaryModel
implements BinaryModel {
    private Vector<DualSupportVector> mVectors = new Vector();

    private DualSupportVector getLastVector() {
        return this.mVectors.lastElement();
    }

    @Override
    public int getSupportVectorCount() {
        return this.mVectors.size();
    }

    @Override
    public void addWeight(int weight) {
        if (this.mVectors.size() > 0) {
            this.getLastVector().addWeight(weight);
        }
    }

    @Override
    public void addVector(Nodes vector, double sign) {
        this.mVectors.add(new DualSupportVector(vector, (int)sign));
    }

    @Override
    public void reset() {
        this.mVectors.clear();
    }

    @Override
    public void compile(int featureCount) {
    }

    @Override
    public double multiply(Nodes vector, Kernel kernel, Cache cache) {
        double value = 0.0;
        int i = 0;
        if (cache != null) {
            value = cache.mValue;
            i = cache.mOffset;
        }
        while (i < this.mVectors.size()) {
            DualSupportVector sv = this.mVectors.get(i);
            double prod = kernel.multiply(sv.getVector(), vector);
            value += prod * (double)sv.getSign();
            ++i;
        }
        return value;
    }

    @Override
    public double predictVoting(Nodes vector, Kernel kernel) {
        double prediction = 0.0;
        double sum = 0.0;
        for (int i = 0; i < this.mVectors.size(); ++i) {
            DualSupportVector sv = this.mVectors.get(i);
            sum += kernel.multiply(sv.getVector(), vector) * (double)sv.getSign();
            int sign = -1;
            if (sum > 0.0) {
                sign = 1;
            } else if (sum == 0.0) {
                sign = 0;
            }
            prediction += (double)(sign *= sv.getWeight());
        }
        return prediction;
    }

    @Override
    public double predictAverage(Nodes vector, Kernel kernel) {
        double prediction = 0.0;
        double sum = 0.0;
        for (int i = 0; i < this.mVectors.size(); ++i) {
            DualSupportVector sv = this.mVectors.get(i);
            prediction += (sum += kernel.multiply(sv.getVector(), vector) * (double)sv.getSign()) * (double)sv.getWeight();
        }
        return prediction;
    }

    @Override
    public void save(PrintStream os) throws IOException {
        os.println(this.mVectors.size());
        for (int i = 0; i < this.mVectors.size(); ++i) {
            DualSupportVector sv = this.mVectors.get(i);
            os.println(sv.getWeight() + " " + sv.getSign() + " " + sv.getVector());
        }
    }

    @Override
    public void load(BufferedReader is, int featureCount) throws IOException {
        String line = is.readLine();
        int svCount = Integer.parseInt(line);
        for (int i = 0; i < svCount; ++i) {
            line = is.readLine();
            int firstSpace = line.indexOf(32);
            int secondSpace = line.indexOf(32, firstSpace + 1);
            int weight = Integer.parseInt(line.substring(0, firstSpace));
            int sign = Integer.parseInt(line.substring(firstSpace + 1, secondSpace));
            Nodes nodes = new Nodes(line.substring(secondSpace + 1));
            this.mVectors.add(new DualSupportVector(nodes, sign, weight));
        }
    }
}

