/*
 * Decompiled with CFR 0.152.
 */
package mill.me;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import mill.common.SimpleTokenize;
import opennlp.maxent.Event;
import opennlp.maxent.EventStream;

public class MaxEntEventStream
implements EventStream {
    private BufferedReader mStream;
    private ArrayList<String> mLineBuffer;

    public MaxEntEventStream(String fileName) throws FileNotFoundException {
        this.mStream = new BufferedReader(new FileReader(fileName));
        this.mLineBuffer = new ArrayList();
    }

    public boolean hasNext() {
        if (!this.mLineBuffer.isEmpty()) {
            return true;
        }
        String line = null;
        try {
            line = this.mStream.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (line == null) {
            return false;
        }
        this.mLineBuffer.add(line);
        return true;
    }

    public Event nextEvent() {
        if (!this.mLineBuffer.isEmpty()) {
            String line = this.mLineBuffer.get(0);
            this.mLineBuffer.remove(0);
            return this.parseLine(line);
        }
        try {
            String line = this.mStream.readLine();
            return this.parseLine(line);
        }
        catch (IOException e) {
            return null;
        }
    }

    private Event parseLine(String line) {
        if (line == null) {
            return null;
        }
        ArrayList<String> tokens = SimpleTokenize.tokenize(line);
        if (tokens.size() < 2) {
            throw new RuntimeException("Invalid sample: " + line);
        }
        String[] context = new String[tokens.size() - 1];
        for (int i = 0; i < tokens.size() - 1; ++i) {
            context[i] = tokens.get(i);
        }
        String outcome = tokens.get(tokens.size() - 1);
        return new Event(outcome, context);
    }
}

