/*
 * Decompiled with CFR 0.152.
 */
package mill.libsvm;

import mill.libsvm.Cache;
import mill.libsvm.Kernel;
import mill.libsvm.svm_parameter;
import mill.libsvm.svm_problem;

class SVR_Q
extends Kernel {
    private final int l;
    private final Cache cache;
    private final byte[] sign;
    private final int[] index;
    private int next_buffer;
    private float[][] buffer;
    private final float[] QD;

    SVR_Q(svm_problem prob, svm_parameter param) {
        super(prob.l, prob.x, param);
        this.l = prob.l;
        this.cache = new Cache(this.l, (int)(param.cache_size * 1048576.0));
        this.QD = new float[2 * this.l];
        this.sign = new byte[2 * this.l];
        this.index = new int[2 * this.l];
        for (int k = 0; k < this.l; ++k) {
            this.sign[k] = 1;
            this.sign[k + this.l] = -1;
            this.index[k] = k;
            this.index[k + this.l] = k;
            this.QD[k] = (float)this.kernel_function(k, k);
            this.QD[k + this.l] = this.QD[k];
        }
        this.buffer = new float[2][2 * this.l];
        this.next_buffer = 0;
    }

    @Override
    void swap_index(int i, int j) {
        int _ = this.sign[i];
        this.sign[i] = this.sign[j];
        this.sign[j] = _;
        _ = this.index[i];
        this.index[i] = this.index[j];
        this.index[j] = _;
        float _2 = this.QD[i];
        this.QD[i] = this.QD[j];
        this.QD[j] = _2;
    }

    @Override
    float[] get_Q(int i, int len) {
        int real_i = this.index[i];
        float[][] data = new float[1][];
        if (this.cache.get_data(real_i, data, this.l) < this.l) {
            for (int j = 0; j < this.l; ++j) {
                data[0][j] = (float)this.kernel_function(real_i, j);
            }
        }
        float[] buf = this.buffer[this.next_buffer];
        this.next_buffer = 1 - this.next_buffer;
        byte si = this.sign[i];
        for (int j = 0; j < len; ++j) {
            buf[j] = (float)(si * this.sign[j]) * data[0][this.index[j]];
        }
        return buf;
    }

    @Override
    float[] get_QD() {
        return this.QD;
    }
}

