/*
 * Decompiled with CFR 0.152.
 */
package mill.common;

public class Score {
    public double mAccuracy = 0.0;
    public double mPrecision = -1.0;
    public double mRecall = -1.0;
    public double mF1 = -1.0;
    public int mCorrect = 0;
    public int mTotal = 0;
    public int mCorrectNonNil = 0;
    public int mPredictedNonNil = 0;
    public int mTotalNonNil = 0;
    public int mNumberCands = 0;

    public double f1() {
        return this.mF1;
    }

    public double accuracy() {
        return this.mAccuracy;
    }

    public void compute(boolean withNil) {
        this.mAccuracy = (double)this.mCorrect / (double)this.mTotal;
        if (withNil) {
            this.mPrecision = -1.0;
            this.mRecall = -1.0;
            this.mF1 = -1.0;
            if (this.mPredictedNonNil != 0) {
                this.mPrecision = (double)this.mCorrectNonNil / (double)this.mPredictedNonNil;
            }
            if (this.mTotalNonNil != 0) {
                this.mRecall = (double)this.mCorrectNonNil / (double)this.mTotalNonNil;
            }
            if (this.mPrecision != 0.0 && this.mRecall != 0.0) {
                this.mF1 = 2.0 * this.mPrecision * this.mRecall / (this.mPrecision + this.mRecall);
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("A " + this.normalize(this.mAccuracy) + "%");
        if (this.mPrecision >= 0.0 && this.mRecall >= 0.0) {
            buf.append(" P " + this.normalize(this.mPrecision) + "%");
            buf.append(" R " + this.normalize(this.mRecall) + "%");
            buf.append(" F1 " + this.normalize(this.f1()));
        }
        return buf.toString();
    }

    public double normalize(double val) {
        int times10000 = (int)(val * 10000.0);
        return (double)times10000 / 100.0;
    }
}

