/*
 * Decompiled with CFR 0.152.
 */
package mill.common;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import mill.common.Nodes;
import mill.common.NodesFactory;

public class Sample {
    protected Nodes mNodes;
    protected int mLabel;

    public Sample(Nodes vector, int label) {
        this.construct(vector, label);
    }

    public Sample() {
        this.mLabel = -1;
        this.mNodes = null;
    }

    public Sample(String line, NodesFactory factory) {
        int firstSpace = line.indexOf(32);
        if (firstSpace < 0) {
            firstSpace = line.indexOf(9);
        }
        if (firstSpace < 0) {
            throw new RuntimeException("Invalid sample: " + line);
        }
        int label = Integer.parseInt(line.substring(0, firstSpace));
        Nodes vector = NodesFactory.makeNodes(line.substring(firstSpace + 1));
        this.construct(vector, label);
    }

    private void construct(Nodes vector, int label) {
        this.mNodes = vector;
        this.mLabel = label;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.mLabel + " " + this.mNodes);
        return buf.toString();
    }

    public int getLabel() {
        return this.mLabel;
    }

    public void setLabel(int l) {
        this.mLabel = l;
    }

    public Nodes getNodes() {
        return this.mNodes;
    }

    public static List<Sample> readSamples(String fileName, NodesFactory factory) throws IOException {
        String line;
        BufferedReader is = new BufferedReader(new FileReader(fileName));
        LinkedList<Sample> samples = new LinkedList<Sample>();
        while ((line = is.readLine()) != null) {
            samples.add(new Sample(line, factory));
        }
        is.close();
        return samples;
    }
}

