/*
 * Decompiled with CFR 0.152.
 */
package mill.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;
import mill.common.Kernel;
import mill.common.Node;
import mill.common.SimpleTokenize;

public class Nodes {
    protected Node[] mNodes;
    protected double[] mExpanded;
    private Double mSelfProduct;

    public Nodes(Node[] nodes) {
        this.mNodes = nodes;
        this.mExpanded = null;
        this.mSelfProduct = null;
    }

    public Nodes(ArrayList<Node> nodes) {
        this.mNodes = new Node[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            this.mNodes[i] = nodes.get(i);
        }
        Arrays.sort(this.mNodes, new NodeComparator());
        this.mExpanded = null;
        this.mSelfProduct = null;
    }

    public Nodes() {
        this.mNodes = null;
        this.mExpanded = null;
        this.mSelfProduct = null;
    }

    public Nodes(int featCount) {
        this.mNodes = null;
        this.mSelfProduct = null;
        this.mExpanded = new double[featCount];
        for (int i = 0; i < this.mExpanded.length; ++i) {
            this.mExpanded[i] = 0.0;
        }
    }

    public Nodes(String str) {
        ArrayList<String> tokens = SimpleTokenize.tokenize(str);
        LinkedList<Node> nodes = new LinkedList<Node>();
        int nodeCount = 0;
        for (int i = 0; i < tokens.size(); ++i) {
            ArrayList<String> tuple = SimpleTokenize.tokenize(tokens.get(i), ":");
            if (tuple.size() != 2) {
                throw new RuntimeException("Invalid tuple " + tokens.get(i) + " in vector: " + str);
            }
            int index = Integer.parseInt(tuple.get(0));
            double value = Double.parseDouble(tuple.get(1));
            if (nodes.size() > 0 && ((Node)nodes.get(nodes.size() - 1)).getIndex() > index) {
                throw new RuntimeException("Features must be stored in increasing index order: \"" + str + "\"");
            }
            if (nodes.size() > 0 && ((Node)nodes.get(nodes.size() - 1)).getIndex() == index) {
                System.err.println("Warning: Found repeated index " + index + ".");
                continue;
            }
            nodes.add(new Node(index, value));
            ++nodeCount;
        }
        if (nodeCount > 0) {
            this.mNodes = new Node[nodeCount];
            int current = 0;
            ListIterator it = nodes.listIterator();
            while (it.hasNext()) {
                this.mNodes[current] = (Node)it.next();
                ++current;
            }
        }
    }

    public String toString() {
        StringBuffer buf;
        block5: {
            block4: {
                buf = new StringBuffer();
                if (this.mExpanded == null) break block4;
                boolean first = true;
                for (int i = 0; i < this.mExpanded.length; ++i) {
                    if (this.mExpanded[i] == 0.0) continue;
                    if (!first) {
                        buf.append(" ");
                    }
                    buf.append(i + ":" + this.mExpanded[i]);
                    first = false;
                }
                break block5;
            }
            if (this.mNodes == null) break block5;
            for (int i = 0; i < this.mNodes.length; ++i) {
                if (i > 0) {
                    buf.append(" ");
                }
                buf.append(this.mNodes[i]);
            }
        }
        return buf.toString();
    }

    public int size() {
        if (this.mNodes == null) {
            return 0;
        }
        return this.mNodes.length;
    }

    public Node get(int pos) {
        return this.mNodes[pos];
    }

    public Node[] getAll() {
        return this.mNodes;
    }

    public double[] getExpanded() {
        return this.mExpanded;
    }

    public Double getSelfProduct(Kernel kernel) {
        if (this.mSelfProduct == null) {
            this.mSelfProduct = kernel.multiplyUnnormalized(this, this);
        }
        return this.mSelfProduct;
    }

    public static Nodes sum(Nodes v1, Nodes v2, double sign) {
        LinkedList<Node> nodes = new LinkedList<Node>();
        int i1 = 0;
        int i2 = 0;
        while (i1 < v1.size() && i2 < v2.size()) {
            Node n1 = v1.get(i1);
            Node n2 = v2.get(i2);
            if (n1.getIndex() == n2.getIndex()) {
                double value = n1.getValue() + sign * n2.getValue();
                if (value != 0.0) {
                    Node n = new Node(n1.getIndex(), value);
                    nodes.add(n);
                }
                ++i1;
                ++i2;
                continue;
            }
            if (n1.getIndex() < n2.getIndex()) {
                nodes.add(n1);
                ++i1;
                continue;
            }
            if (sign != 1.0) {
                Node n = new Node(n2.getIndex(), n2.getValue() * sign);
                nodes.add(n);
            } else {
                nodes.add(n2);
            }
            ++i2;
        }
        if (i1 < v1.size()) {
            while (i1 < v1.size()) {
                nodes.add(v1.get(i1));
                ++i1;
            }
        } else if (i2 < v2.size()) {
            while (i2 < v2.size()) {
                if (sign != 1.0) {
                    Node n = new Node(v2.get(i2).getIndex(), v2.get(i2).getValue() * sign);
                    nodes.add(n);
                } else {
                    nodes.add(v2.get(i2));
                }
                ++i2;
            }
        }
        Node[] output = new Node[nodes.size()];
        int i = 0;
        ListIterator it = nodes.listIterator();
        while (it.hasNext()) {
            output[i] = (Node)it.next();
            ++i;
        }
        return new Nodes(output);
    }

    private double length() {
        double sum = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            Node n = this.get(i);
            sum += n.getValue() * n.getValue();
        }
        return Math.sqrt(sum);
    }

    public void normalize() {
        double len = this.length();
        for (int i = 0; i < this.size(); ++i) {
            Node n = this.get(i);
            n.setValue(n.getValue() / len);
        }
    }

    public int getMaxIndex() {
        int maxIndex = -1;
        for (int i = 0; i < this.size(); ++i) {
            Node n = this.get(i);
            if (n.getIndex() <= maxIndex) continue;
            maxIndex = n.getIndex();
        }
        return maxIndex;
    }

    public void expand(int featureCount) {
        int i;
        this.mExpanded = new double[featureCount];
        for (i = 0; i < featureCount; ++i) {
            this.mExpanded[i] = 0.0;
        }
        for (i = 0; i < this.size(); ++i) {
            Node n = this.get(i);
            if (n.getIndex() < 0 || n.getIndex() >= this.mExpanded.length) continue;
            this.mExpanded[n.getIndex()] = n.getValue();
        }
    }

    public static void main(String[] args) throws Exception {
        Nodes n1 = new Nodes("1:1 2:1 3:2");
        Nodes n2 = new Nodes("2:3 4:1");
        Nodes s = Nodes.sum(n1, n2, -2.0);
        System.out.println(s);
    }

    public void sumExpanded(Nodes other, double sign) {
        assert (this.mExpanded.length == other.mExpanded.length);
        for (int i = 0; i < this.mExpanded.length; ++i) {
            int n = i;
            this.mExpanded[n] = this.mExpanded[n] + other.mExpanded[i] * sign;
        }
    }

    public void sumNonExpanded(Nodes other, double sign) {
        if (other.mNodes != null) {
            for (int i = 0; i < other.mNodes.length; ++i) {
                int n = other.mNodes[i].mIndex;
                this.mExpanded[n] = this.mExpanded[n] + other.mNodes[i].mValue * sign;
            }
        }
    }

    public void setValues(double v, boolean doNorm) {
        for (int i = 0; i < this.mExpanded.length; ++i) {
            this.mExpanded[i] = v;
        }
        if (doNorm) {
            this.normalize();
        }
    }

    class NodeComparator
    implements Comparator<Node> {
        NodeComparator() {
        }

        @Override
        public int compare(Node n1, Node n2) {
            if (n1.mIndex < n2.mIndex) {
                return -1;
            }
            if (n1.mIndex == n2.mIndex) {
                return 0;
            }
            return 1;
        }
    }
}

