/*
 * Decompiled with CFR 0.152.
 */
package mill.common;

import mill.common.Nodes;

public abstract class Kernel {
    boolean mNormalized;

    protected Kernel(boolean n) {
        this.mNormalized = n;
    }

    public double multiply(Nodes v1, Nodes v2) {
        double value = 0.0;
        value = !this.mNormalized ? this.multiplyUnnormalized(v1, v2) : this.multiplyNormalized(v1, v2);
        return value;
    }

    public abstract double multiplyUnnormalized(Nodes var1, Nodes var2);

    public double multiplyNormalized(Nodes v1, Nodes v2) {
        double kv1 = v1.getSelfProduct(this);
        double kv2 = v2.getSelfProduct(this);
        double un = this.multiplyUnnormalized(v1, v2);
        if (kv1 != 0.0 && kv2 != 0.0) {
            return un / Math.sqrt(kv1 * kv2);
        }
        return un;
    }
}

