/*
 * Decompiled with CFR 0.152.
 */
package mill.common;

import mill.common.Kernel;
import mill.common.Node;
import mill.common.Nodes;

public abstract class DotKernel
extends Kernel {
    protected DotKernel(boolean norm) {
        super(norm);
    }

    protected double vectorLength(Nodes v) {
        double len = 0.0;
        for (int i = 0; i < v.size(); ++i) {
            double w = v.get(i).getValue();
            len += w * w;
        }
        len = Math.sqrt(len);
        return len;
    }

    protected double dot(Nodes v1, Nodes v2) {
        double[] ev1 = v1.getExpanded();
        double[] ev2 = v2.getExpanded();
        if (ev1 == null && ev2 == null) {
            return this.dotSparseSparse(v1, v2);
        }
        if (ev1 == null && ev2 != null) {
            return this.dotSparseExpanded(v1, ev2);
        }
        if (ev1 != null && ev2 == null) {
            return this.dotSparseExpanded(v2, ev1);
        }
        return this.dotExpandedExpanded(ev1, ev2);
    }

    protected double dotSparseSparse(Nodes v1, Nodes v2) {
        double sum = 0.0;
        int i1 = 0;
        int i2 = 0;
        while (i1 < v1.size() && i2 < v2.size()) {
            if (v1.get(i1).getIndex() == v2.get(i2).getIndex()) {
                sum += v1.get(i1).getValue() * v2.get(i2).getValue();
                ++i1;
                ++i2;
                continue;
            }
            if (v1.get(i1).getIndex() < v2.get(i2).getIndex()) {
                ++i1;
                continue;
            }
            ++i2;
        }
        return sum;
    }

    protected double dotSparseExpanded(Nodes v1, double[] v2) {
        double sum = 0.0;
        for (int i1 = 0; i1 < v1.size(); ++i1) {
            Node n1 = v1.get(i1);
            sum += n1.getValue() * v2[n1.getIndex()];
        }
        return sum;
    }

    protected double dotExpandedExpanded(double[] ev1, double[] ev2) {
        if (ev1.length != ev2.length) {
            throw new RuntimeException("Expanded vector lengths do not match: " + ev1.length + " versus " + ev2.length + "!");
        }
        double sum = 0.0;
        for (int i = 0; i < ev1.length; ++i) {
            sum += ev1[i] * ev2[i];
        }
        return sum;
    }
}

