/*
 * Decompiled with CFR 0.152.
 */
package mill.perk;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import mill.common.Kernel;
import mill.common.Nodes;
import mill.perk.BinaryModel;
import mill.perk.Cache;

public class PrimalExpandedBinaryModel
implements BinaryModel {
    protected Nodes mLastVector;
    protected double mLastWeight;
    private Nodes mAvgVector;
    protected int mFeatCount;
    protected int mUpdates;

    public PrimalExpandedBinaryModel(int featCount) {
        this.mFeatCount = featCount;
        this.mUpdates = 0;
        this.reset();
    }

    @Override
    public void reset() {
        this.mLastVector = new Nodes(this.mFeatCount);
        this.mAvgVector = new Nodes(this.mFeatCount);
        this.mLastWeight = 0.0;
    }

    @Override
    public int getSupportVectorCount() {
        return this.mUpdates;
    }

    @Override
    public void addWeight(int weight) {
        this.mLastWeight += (double)weight;
        this.mAvgVector.sumExpanded(this.mLastVector, this.mLastWeight);
    }

    @Override
    public void addVector(Nodes x, double sign) {
        this.mLastVector.sumNonExpanded(x, sign);
        this.mLastWeight = 0.0;
        ++this.mUpdates;
    }

    @Override
    public void compile(int featureCount) {
    }

    @Override
    public double multiply(Nodes vector, Kernel kernel, Cache cache) {
        return kernel.multiply(this.mLastVector, vector);
    }

    @Override
    public double predictVoting(Nodes vector, Kernel kernel) {
        double prediction = 0.0;
        return prediction;
    }

    @Override
    public double predictAverage(Nodes vector, Kernel kernel) {
        return kernel.multiply(this.mAvgVector, vector);
    }

    @Override
    public void save(PrintStream os) throws IOException {
        os.println(this.mAvgVector);
    }

    @Override
    public void load(BufferedReader is, int featureCount) throws IOException {
        String line = is.readLine();
        this.mAvgVector = new Nodes(line);
        this.mAvgVector.expand(featureCount);
    }
}

