/*
 * Decompiled with CFR 0.152.
 */
package mill.perk;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import mill.common.Kernel;
import mill.common.Nodes;
import mill.perk.BinaryModel;
import mill.perk.Cache;
import mill.perk.PrimalSupportVector;

public class PrimalBinaryModel
implements BinaryModel {
    protected Vector<PrimalSupportVector> mVectors = new Vector();
    Nodes mAvgVector = null;

    PrimalSupportVector getLastVector() {
        if (this.mVectors.isEmpty()) {
            return null;
        }
        return this.mVectors.lastElement();
    }

    @Override
    public int getSupportVectorCount() {
        return this.mVectors.size();
    }

    @Override
    public void addWeight(int weight) {
        if (this.mVectors.size() > 0) {
            this.getLastVector().addWeight(weight);
        }
    }

    @Override
    public void addVector(Nodes x, double sign) {
        Nodes lastGlobal = null;
        lastGlobal = this.mVectors.size() > 0 ? this.getLastVector().getVector() : new Nodes();
        Nodes newGlobal = Nodes.sum(lastGlobal, x, sign);
        this.mVectors.add(new PrimalSupportVector(newGlobal));
    }

    @Override
    public void reset() {
        this.mVectors.clear();
        this.mAvgVector = null;
    }

    @Override
    public void compile(int featureCount) {
        if (this.mAvgVector == null) {
            this.mAvgVector = new Nodes();
        }
        for (int i = 0; i < this.mVectors.size(); ++i) {
            PrimalSupportVector sv = this.mVectors.get(i);
            this.mAvgVector = Nodes.sum(this.mAvgVector, sv.getVector(), sv.getWeight());
        }
        this.mAvgVector.expand(featureCount);
        if (this.mVectors.size() > 0) {
            PrimalSupportVector lastVector = this.getLastVector();
            lastVector.resetWeight();
            this.mVectors.clear();
            this.mVectors.add(lastVector);
        }
    }

    @Override
    public double multiply(Nodes vector, Kernel kernel, Cache cache) {
        if (this.mVectors.size() == 0) {
            return 0.0;
        }
        return kernel.multiply(this.getLastVector().getVector(), vector);
    }

    @Override
    public double predictVoting(Nodes vector, Kernel kernel) {
        double prediction = 0.0;
        return prediction;
    }

    @Override
    public double predictAverage(Nodes vector, Kernel kernel) {
        if (this.mAvgVector == null) {
            return 0.0;
        }
        return kernel.multiply(this.mAvgVector, vector);
    }

    @Override
    public void save(PrintStream os) throws IOException {
        os.println(this.mAvgVector);
    }

    @Override
    public void load(BufferedReader is, int featureCount) throws IOException {
        String line = is.readLine();
        this.mAvgVector = new Nodes(line);
        this.mAvgVector.expand(featureCount);
    }
}

