/*
 * Decompiled with CFR 0.152.
 */
package mill.perk;

import java.util.LinkedList;
import java.util.List;
import mill.common.Kernel;
import mill.common.LinearKernel;
import mill.common.TrainingParameters;

public class MulticlassPerceptronClassifierTrainingParameters
extends TrainingParameters {
    Kernel mKernel;
    int mNumberOfEpochs;
    double mMinScore;
    List<LabelWeight> mLabelWeights;
    String mModelFile;
    public static final int DEFAULT_EPOCHS = 2;

    public MulticlassPerceptronClassifierTrainingParameters(Integer nilCat, Kernel kernel, Integer epochs, Double minScore, String modelFile) {
        super(nilCat);
        this.mKernel = kernel;
        this.mNumberOfEpochs = epochs != null ? epochs : 2;
        this.mMinScore = minScore != null ? minScore : 0.0;
        this.mLabelWeights = new LinkedList<LabelWeight>();
        this.mModelFile = modelFile;
    }

    public MulticlassPerceptronClassifierTrainingParameters(Integer nilCat) {
        super(nilCat);
        this.mKernel = new LinearKernel();
        this.mNumberOfEpochs = 2;
        this.mMinScore = 0.0;
        this.mLabelWeights = new LinkedList<LabelWeight>();
        this.mModelFile = null;
    }

    public void addLabelWeight(int label, double weight) {
        this.mLabelWeights.add(new LabelWeight(label, weight));
    }

    static class LabelWeight {
        int mLabel;
        double mWeight;

        LabelWeight(int label, double weight) {
            this.mLabel = label;
            this.mWeight = weight;
        }
    }
}

