/*
 * Decompiled with CFR 0.152.
 */
package mill.common;

import mill.common.DotKernel;
import mill.common.Nodes;

public class PolyKernel
extends DotKernel {
    private double mDegree;
    private double mGamma;
    private double mCoef0;
    public static final double DEFAULT_GAMMA = 1.0;
    public static final double DEFAULT_COEF0 = 1.0;

    public PolyKernel(Integer degree) {
        super(false);
        this.construct(degree, 1.0, 1.0);
    }

    public PolyKernel(Integer degree, Double gamma, Double coef0) {
        super(false);
        this.construct(degree, gamma, coef0);
    }

    private void construct(Integer degree, Double gamma, Double coef0) {
        this.mDegree = degree == null ? 1.0 : (double)degree.intValue();
        this.mGamma = gamma == null ? 1.0 : gamma;
        this.mCoef0 = coef0 == null ? 1.0 : coef0;
    }

    public PolyKernel() {
        super(true);
    }

    @Override
    public double multiplyUnnormalized(Nodes v1, Nodes v2) {
        double prod = this.dot(v1, v2);
        double sign = 1.0;
        return sign * Math.pow(this.mGamma * prod + this.mCoef0, this.mDegree);
    }

    public static void main(String[] args) throws Exception {
        Nodes v1 = new Nodes("1:2 3:3 4:3 7:1.5");
        Nodes v2 = new Nodes("2:3 3:5 7:1");
        PolyKernel k = new PolyKernel(2, 1.0, 0.0);
        System.out.println(v1 + "\n" + v2 + "\n" + k.multiply(v1, v2));
    }
}

