/*
 * Decompiled with CFR 0.152.
 */
package mill.common;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;

public class CommandLineParameters {
    private static HashMap<String, Object> _parameters = new HashMap();
    private static String PARAM_START_STRING = new String("--");

    public static void read(String file) throws FileNotFoundException, IOException {
        CommandLineParameters.read(file, false);
    }

    public static void read(String file, boolean overwrite) throws FileNotFoundException, IOException {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(file));
        while ((line = in.readLine()) != null) {
            String clean = CommandLineParameters.skipSpaces(line);
            if (clean.length() == 0 || clean.charAt(0) == '#') continue;
            String[] param = CommandLineParameters.readNameValue(clean, false);
            if (param == null) {
                throw new RuntimeException("Failed to parse argument: " + clean);
            }
            if (!overwrite && CommandLineParameters.contains(param[0])) continue;
            CommandLineParameters.setString(param[0], param[1]);
        }
    }

    public static int read(String[] args) throws FileNotFoundException, IOException {
        int current;
        for (current = 0; current < args.length && args[current].length() > 2 && args[current].substring(0, 2).equals(PARAM_START_STRING); ++current) {
            String input = args[current].substring(2, args[current].length());
            String[] param = CommandLineParameters.readNameValue(input, true);
            if (param == null) {
                throw new RuntimeException("Failed to parse argument: " + input);
            }
            CommandLineParameters.setString(param[0], param[1]);
        }
        String configValue = CommandLineParameters.getString("config");
        if (configValue != null) {
            CommandLineParameters.read(configValue, false);
        }
        return current;
    }

    public static void display(PrintStream os) {
        Object[] keys = _parameters.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i].equals("config")) continue;
            os.println(keys[i] + " = \"" + CommandLineParameters.getString((String)keys[i]) + "\"");
        }
    }

    public static void setString(String name, String value) {
        _parameters.put(name, value);
    }

    public static void setInteger(String name, int value) {
        _parameters.put(name, Integer.toString(value));
    }

    public static void setDouble(String name, double value) {
        _parameters.put(name, Double.toString(value));
    }

    public static String getString(String name) {
        return (String)_parameters.get(name);
    }

    public static Integer getInteger(String name) {
        String v = (String)_parameters.get(name);
        if (v != null) {
            return new Integer(v);
        }
        return null;
    }

    public static Boolean getBoolean(String name) {
        String v = (String)_parameters.get(name);
        if (v != null) {
            if (v.equalsIgnoreCase("true") || v.equalsIgnoreCase("1")) {
                return new Boolean(true);
            }
            return new Boolean(false);
        }
        return null;
    }

    public static Double getDouble(String name) {
        String v = (String)_parameters.get(name);
        if (v != null) {
            return new Double(v);
        }
        return null;
    }

    public static boolean contains(String name) {
        return _parameters.get(name) != null;
    }

    private static String skipSpaces(String s) {
        int i;
        for (i = 0; i < s.length() && (s.charAt(i) == ' ' || s.charAt(i) == '\t'); ++i) {
        }
        return s.substring(i, s.length());
    }

    private static String[] readNameValue(String input, boolean defaultValue) {
        String value;
        int nameStart = CommandLineParameters.findNonSeparator(input, 0);
        if (nameStart >= input.length()) {
            return null;
        }
        int nameEnd = CommandLineParameters.findSeparator(input, nameStart);
        String name = input.substring(nameStart, nameEnd);
        if (nameEnd < input.length()) {
            String raw;
            int valueStart = CommandLineParameters.findNonSeparator(input, nameEnd);
            if (valueStart >= input.length()) {
                return null;
            }
            if (input.charAt(valueStart) == '\"') {
                int valueEnd = CommandLineParameters.findQuote(input, valueStart + 1);
                raw = input.substring(valueStart + 1, valueEnd);
            } else {
                int valueEnd = CommandLineParameters.findSeparator(input, valueStart);
                raw = input.substring(valueStart, valueEnd);
            }
            value = CommandLineParameters.substitute(raw);
            if (value == null) {
                return null;
            }
        } else if (defaultValue) {
            value = "1";
        } else {
            return null;
        }
        String[] result = new String[]{name, value};
        return result;
    }

    private static String substitute(String raw) {
        String out = new String();
        int end = -1;
        for (int i = 0; i < raw.length(); ++i) {
            if (CommandLineParameters.isVariableStart(raw, i) && (end = CommandLineParameters.findVariableEnd(raw, i + 2)) != raw.length()) {
                String varName = raw.substring(i + 2, end);
                String varValue = CommandLineParameters.getString(varName);
                if (varValue == null) {
                    throw new RuntimeException("Undefined parameter: " + varName);
                }
                out = out + varValue;
                i = end;
                continue;
            }
            if (raw.charAt(i) == '\\' && i < raw.length() - 1) {
                out = out + raw.substring(i + 1, i + 2);
                ++i;
                continue;
            }
            out = out + raw.substring(i, i + 1);
        }
        return out;
    }

    private static boolean isVariableStart(String s, int offset) {
        return offset < s.length() - 3 && s.charAt(offset) == '$' && s.charAt(offset + 1) == '{';
    }

    private static int findVariableEnd(String s, int offset) {
        for (int i = offset; i < s.length(); ++i) {
            if (s.charAt(i) != '}') continue;
            return i;
        }
        return s.length();
    }

    private static int findSeparator(String input, int offset) {
        for (int i = offset; i < input.length(); ++i) {
            if (input.charAt(i) != ' ' && input.charAt(i) != '\t' && input.charAt(i) != '=') continue;
            return i;
        }
        return input.length();
    }

    private static int findNonSeparator(String input, int offset) {
        for (int i = offset; i < input.length(); ++i) {
            if (input.charAt(i) == ' ' || input.charAt(i) == '\t' || input.charAt(i) == '=') continue;
            return i;
        }
        return input.length();
    }

    private static int findQuote(String input, int offset) {
        for (int i = offset; i < input.length(); ++i) {
            if (input.charAt(i) != '\"' || i != 0 && input.charAt(i - 1) == '\\') continue;
            return i;
        }
        return input.length();
    }
}

