/*
 * Copyright 1999, 2005 Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <sys/resource.h>
#include "extraMain.h"
#include <vector>
#include <list>
#include "Item.h"
#include "MeChart.h"
#include "headFinder.h"
#include "ClassRule.h"

void
generalInit(ECString path)
{
  struct rlimit 	core_limits;
  core_limits.rlim_cur = 0;
  core_limits.rlim_max = 0;
  setrlimit( RLIMIT_CORE, &core_limits );

  struct rlimit stack_limits;
  stack_limits.rlim_cur = 0;
  stack_limits.rlim_max = 0;
  getrlimit( RLIMIT_STACK, &stack_limits );
  if (stack_limits.rlim_cur < stack_limits.rlim_max)
    {
      stack_limits.rlim_cur = stack_limits.rlim_max;
      setrlimit( RLIMIT_STACK, &stack_limits );
    }
  Term::init( path );
  readHeadInfo(path);
  InputTree::init();
  UnitRules* ur = new UnitRules;
  ur->readData(path); 
  Bchart::unitRules = ur;
  Bchart::readTermProbs(path);
  MeChart::init(path);
  Bchart::setPosStarts();
  ChartBase::midFactor = (1.0 - (.3684 *ChartBase::endFactor))/(1.0 - .3684);
  if(Feature::isLM) ClassRule::readCRules(path);
}

InputTree*
inputTreeFromAnsTree(AnsTree* at, short& pos, SentRep& sr)
{
  //cerr << "itfat " << at->trm << " " << at->subTrees.size() << endl;
  short trmInt = at->trm;
  assert(trmInt < 400);
  const Term* trm = NULL;
  ECString trmString;
  if(trmInt >= 0)
    {
      trm = Term::fromInt(trmInt);
      trmString = trm->name();
    }
  ECString wrdString;
  ECString ntString;
  list<InputTree*> subtrs;
  InputTree* ans;
  short begn = pos;
  if(trm && trm->terminal_p())
    {
      if(sr.length() > 0) wrdString = sr[pos].lexeme();
      else wrdString = Bchart::intToW(at->wrd);
      pos++;
    }
  else
    {
      assert(at);
      AnsTreeIter ati = at->subTrees.begin();
      Item* subi;
      for( ; ati != at->subTrees.end() ; ati++)
	{
	  //cerr << "SIT " << *subi->term() << endl;
	  AnsTree* sab = *ati;
	  InputTree* sit = inputTreeFromAnsTree(sab, pos,sr);
	  subtrs.push_back(sit);
	}
    }
  //cerr << "C itfat " << *trm << endl;
  ans = new InputTree(begn, pos, wrdString, trmString, ntString,
		      subtrs, NULL, NULL);
  
  /* This code inserts the position of the head word after the
     non-terminal */
  /*
  if(!trm->terminal_p())
    {
      int hp = headPosFromTree(ans);
      assert(hp >= 0);
      ans->ntInfo() = intToString(hp);
    }
  */
  InputTreesIter iti = subtrs.begin();
  for( ; iti != subtrs.end() ; iti++) (*iti)->parentSet() = ans;


  //cerr << "ITF " << *ans << endl;
  return ans;
}
