/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import gnu.trove.TIntArrayList;
import gnu.trove.TLinkedList;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opennlp.maxent.AbstractDataIndexer;
import opennlp.maxent.ComparableEvent;
import opennlp.maxent.Event;
import opennlp.maxent.EventStream;

public class OnePassDataIndexer
extends AbstractDataIndexer {
    public OnePassDataIndexer(EventStream eventStream) {
        this(eventStream, 0);
    }

    public OnePassDataIndexer(EventStream eventStream, int n) {
        TObjectIntHashMap tObjectIntHashMap = new TObjectIntHashMap();
        System.out.println("Indexing events using cutoff of " + n + "\n");
        System.out.print("\tComputing event counts...  ");
        TLinkedList tLinkedList = this.computeEventCounts(eventStream, tObjectIntHashMap, n);
        System.out.println("done. " + tLinkedList.size() + " events");
        System.out.print("\tIndexing...  ");
        List list = this.index(tLinkedList, tObjectIntHashMap);
        tLinkedList = null;
        tObjectIntHashMap = null;
        System.out.println("done.");
        System.out.print("Sorting and merging events... ");
        this.sortAndMerge(list);
        System.out.println("Done indexing.");
    }

    private TLinkedList computeEventCounts(EventStream eventStream, TObjectIntHashMap tObjectIntHashMap, int n) {
        TObjectIntHashMap tObjectIntHashMap2 = new TObjectIntHashMap();
        TLinkedList tLinkedList = new TLinkedList();
        int n2 = 0;
        while (eventStream.hasNext()) {
            Event event = eventStream.nextEvent();
            tLinkedList.addLast((Object)event);
            String[] stringArray = event.getContext();
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (!tObjectIntHashMap.containsKey((Object)stringArray[n3])) {
                    if (!tObjectIntHashMap2.increment((Object)stringArray[n3])) {
                        tObjectIntHashMap2.put((Object)stringArray[n3], 1);
                    }
                    if (tObjectIntHashMap2.get((Object)stringArray[n3]) >= n) {
                        tObjectIntHashMap.put((Object)stringArray[n3], n2++);
                        tObjectIntHashMap2.remove((Object)stringArray[n3]);
                    }
                }
                ++n3;
            }
        }
        tObjectIntHashMap.trimToSize();
        return tLinkedList;
    }

    private List index(TLinkedList tLinkedList, TObjectIntHashMap tObjectIntHashMap) {
        TObjectIntHashMap tObjectIntHashMap2 = new TObjectIntHashMap();
        int n = tLinkedList.size();
        int n2 = 0;
        boolean bl = false;
        ArrayList<ComparableEvent> arrayList = new ArrayList<ComparableEvent>(n);
        TIntArrayList tIntArrayList = new TIntArrayList();
        int n3 = 0;
        while (n3 < n) {
            int n4;
            Event event = (Event)((Object)tLinkedList.removeFirst());
            String[] stringArray = event.getContext();
            String string = event.getOutcome();
            if (tObjectIntHashMap2.containsKey((Object)string)) {
                n4 = tObjectIntHashMap2.get((Object)string);
            } else {
                n4 = n2++;
                tObjectIntHashMap2.put((Object)string, n4);
            }
            int n5 = 0;
            while (n5 < stringArray.length) {
                String string2 = stringArray[n5];
                if (tObjectIntHashMap.containsKey((Object)string2)) {
                    tIntArrayList.add(tObjectIntHashMap.get((Object)string2));
                }
                ++n5;
            }
            if (tIntArrayList.size() > 0) {
                ComparableEvent comparableEvent = new ComparableEvent(n4, tIntArrayList.toNativeArray());
                arrayList.add(comparableEvent);
            } else {
                System.err.println("Dropped event " + event.getOutcome() + ":" + Arrays.asList(event.getContext()));
            }
            tIntArrayList.resetQuick();
            ++n3;
        }
        this.outcomeLabels = AbstractDataIndexer.toIndexedStringArray(tObjectIntHashMap2);
        this.predLabels = AbstractDataIndexer.toIndexedStringArray(tObjectIntHashMap);
        return arrayList;
    }
}

