/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import java.text.DecimalFormat;
import opennlp.maxent.MaxentModel;
import opennlp.maxent.TIntParamHashMap;
import opennlp.maxent.TObjectIndexHashMap;

public final class GISModel
implements MaxentModel {
    private final TIntParamHashMap[] params;
    private final TObjectIndexHashMap pmap;
    private final String[] ocNames;
    private final double correctionConstant;
    private final double correctionParam;
    private final int numOutcomes;
    private final double iprob;
    private final double fval;
    private DecimalFormat df;
    private int[] numfeats;

    public GISModel(TIntParamHashMap[] tIntParamHashMapArray, String[] stringArray, String[] stringArray2, int n, double d) {
        this.pmap = new TObjectIndexHashMap(stringArray.length);
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.pmap.put(stringArray[n2], n2);
            ++n2;
        }
        this.params = tIntParamHashMapArray;
        this.ocNames = stringArray2;
        this.correctionConstant = n;
        this.correctionParam = d;
        this.numOutcomes = this.ocNames.length;
        this.iprob = Math.log(1.0 / (double)this.numOutcomes);
        this.fval = 1.0 / this.correctionConstant;
        this.numfeats = new int[this.numOutcomes];
    }

    public final double[] eval(String[] stringArray) {
        return this.eval(stringArray, new double[this.numOutcomes]);
    }

    public final double[] eval(String[] stringArray, double[] dArray) {
        int n;
        int n2;
        int n3 = 0;
        while (n3 < this.numOutcomes) {
            dArray[n3] = this.iprob;
            this.numfeats[n3] = 0;
            ++n3;
        }
        int n4 = 0;
        while (n4 < stringArray.length) {
            int n5 = this.pmap.get(stringArray[n4]);
            if (n5 >= 0) {
                TIntParamHashMap tIntParamHashMap = this.params[n5];
                int[] nArray = tIntParamHashMap.keys();
                n2 = 0;
                while (n2 < nArray.length) {
                    int n6 = n = nArray[n2];
                    this.numfeats[n6] = this.numfeats[n6] + 1;
                    int n7 = n;
                    dArray[n7] = dArray[n7] + tIntParamHashMap.get(n);
                    ++n2;
                }
            }
            ++n4;
        }
        double d = 0.0;
        n2 = 0;
        while (n2 < this.numOutcomes) {
            dArray[n2] = Math.exp(dArray[n2] * this.fval + (1.0 - (double)this.numfeats[n2] / this.correctionConstant) * this.correctionParam);
            d += dArray[n2];
            ++n2;
        }
        n = 0;
        while (n < this.numOutcomes) {
            int n8 = n++;
            dArray[n8] = dArray[n8] / d;
        }
        return dArray;
    }

    public final String getBestOutcome(double[] dArray) {
        int n = 0;
        int n2 = 1;
        while (n2 < dArray.length) {
            if (dArray[n2] > dArray[n]) {
                n = n2;
            }
            ++n2;
        }
        return this.ocNames[n];
    }

    public final String getAllOutcomes(double[] dArray) {
        if (dArray.length != this.ocNames.length) {
            return "The double array sent as a parameter to GISModel.getAllOutcomes() must not have been produced by this model.";
        }
        if (this.df == null) {
            this.df = new DecimalFormat("0.0000");
        }
        StringBuffer stringBuffer = new StringBuffer(dArray.length * 2);
        stringBuffer.append(this.ocNames[0]).append("[").append(this.df.format(dArray[0])).append("]");
        int n = 1;
        while (n < dArray.length) {
            stringBuffer.append("  ").append(this.ocNames[n]).append("[").append(this.df.format(dArray[n])).append("]");
            ++n;
        }
        return stringBuffer.toString();
    }

    public final String getOutcome(int n) {
        return this.ocNames[n];
    }

    public int getIndex(String string) {
        int n = 0;
        while (n < this.ocNames.length) {
            if (this.ocNames[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getNumOutcomes() {
        return this.numOutcomes;
    }

    public final Object[] getDataStructures() {
        Object[] objectArray = new Object[]{this.params, this.pmap, this.ocNames, new Integer((int)this.correctionConstant), new Double(this.correctionParam)};
        return objectArray;
    }
}

