/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.util.Collections;
import java.util.List;
import opennlp.maxent.ComparableEvent;
import opennlp.maxent.DataIndexer;

public abstract class AbstractDataIndexer
implements DataIndexer {
    protected int[][] contexts;
    protected int[] outcomeList;
    protected int[] numTimesEventsSeen;
    protected String[] predLabels;
    protected String[] outcomeLabels;

    public int[][] getContexts() {
        return this.contexts;
    }

    public int[] getNumTimesEventsSeen() {
        return this.numTimesEventsSeen;
    }

    public int[] getOutcomeList() {
        return this.outcomeList;
    }

    public String[] getPredLabels() {
        return this.predLabels;
    }

    public String[] getOutcomeLabels() {
        return this.outcomeLabels;
    }

    protected void sortAndMerge(List list) {
        Collections.sort(list);
        int n = list.size();
        int n2 = 1;
        if (n <= 1) {
            return;
        }
        ComparableEvent comparableEvent = (ComparableEvent)list.get(0);
        int n3 = 1;
        while (n3 < n) {
            ComparableEvent comparableEvent2 = (ComparableEvent)list.get(n3);
            if (comparableEvent.compareTo(comparableEvent2) == 0) {
                ++comparableEvent.seen;
                list.set(n3, null);
            } else {
                comparableEvent = comparableEvent2;
                ++n2;
            }
            ++n3;
        }
        System.out.println("done. Reduced " + n + " events to " + n2 + ".");
        this.contexts = new int[n2][];
        this.outcomeList = new int[n2];
        this.numTimesEventsSeen = new int[n2];
        int n4 = 0;
        int n5 = 0;
        while (n4 < n) {
            ComparableEvent comparableEvent3 = (ComparableEvent)list.get(n4);
            if (null != comparableEvent3) {
                this.numTimesEventsSeen[n5] = comparableEvent3.seen;
                this.outcomeList[n5] = comparableEvent3.outcome;
                this.contexts[n5] = comparableEvent3.predIndexes;
                ++n5;
            }
            ++n4;
        }
    }

    protected static String[] toIndexedStringArray(TObjectIntHashMap tObjectIntHashMap) {
        final String[] stringArray = new String[tObjectIntHashMap.size()];
        tObjectIntHashMap.forEachEntry(new TObjectIntProcedure(){

            public boolean execute(Object object, int n) {
                stringArray[n] = (String)object;
                return true;
            }
        });
        return stringArray;
    }
}

