/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPOutputStream;
import opennlp.maxent.GISModel;
import opennlp.maxent.io.GISModelWriter;

public class PlainTextGISModelWriter
extends GISModelWriter {
    BufferedWriter output;

    public PlainTextGISModelWriter(GISModel gISModel, File file) throws IOException, FileNotFoundException {
        super(gISModel);
        this.output = file.getName().endsWith(".gz") ? new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(file)))) : new BufferedWriter(new FileWriter(file));
    }

    public PlainTextGISModelWriter(GISModel gISModel, BufferedWriter bufferedWriter) {
        super(gISModel);
        this.output = bufferedWriter;
    }

    protected void writeUTF(String string) throws IOException {
        this.output.write(string);
        this.output.newLine();
    }

    protected void writeInt(int n) throws IOException {
        this.output.write(Integer.toString(n));
        this.output.newLine();
    }

    protected void writeDouble(double d) throws IOException {
        this.output.write(Double.toString(d));
        this.output.newLine();
    }

    protected void close() throws IOException {
        this.output.flush();
        this.output.close();
    }
}

