/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent.io;

import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opennlp.maxent.ComparablePredicate;
import opennlp.maxent.GISModel;
import opennlp.maxent.TIntParamHashMap;

public abstract class GISModelWriter {
    protected TIntParamHashMap[] PARAMS;
    protected String[] OUTCOME_LABELS;
    protected int CORRECTION_CONSTANT;
    protected double CORRECTION_PARAM;
    protected String[] PRED_LABELS;

    public GISModelWriter(GISModel gISModel) {
        Object[] objectArray = gISModel.getDataStructures();
        this.PARAMS = (TIntParamHashMap[])objectArray[0];
        TObjectIntHashMap tObjectIntHashMap = (TObjectIntHashMap)objectArray[1];
        this.OUTCOME_LABELS = (String[])objectArray[2];
        this.CORRECTION_CONSTANT = (Integer)objectArray[3];
        this.CORRECTION_PARAM = (Double)objectArray[4];
        this.PRED_LABELS = new String[tObjectIntHashMap.size()];
        tObjectIntHashMap.forEachEntry(new TObjectIntProcedure(){

            public boolean execute(Object object, int n) {
                GISModelWriter.this.PRED_LABELS[n] = (String)object;
                return true;
            }
        });
    }

    protected abstract void writeUTF(String var1) throws IOException;

    protected abstract void writeInt(int var1) throws IOException;

    protected abstract void writeDouble(double var1) throws IOException;

    protected abstract void close() throws IOException;

    public void persist() throws IOException {
        this.writeUTF("GIS");
        this.writeInt(this.CORRECTION_CONSTANT);
        this.writeDouble(this.CORRECTION_PARAM);
        this.writeInt(this.OUTCOME_LABELS.length);
        int n = 0;
        while (n < this.OUTCOME_LABELS.length) {
            this.writeUTF(this.OUTCOME_LABELS[n]);
            ++n;
        }
        ComparablePredicate[] comparablePredicateArray = this.sortValues();
        List list = this.compressOutcomes(comparablePredicateArray);
        this.writeInt(list.size());
        int n2 = 0;
        while (n2 < list.size()) {
            List list2 = (List)list.get(n2);
            this.writeUTF(list2.size() + ((ComparablePredicate)list2.get(0)).toString());
            ++n2;
        }
        this.writeInt(this.PARAMS.length);
        int n3 = 0;
        while (n3 < comparablePredicateArray.length) {
            this.writeUTF(comparablePredicateArray[n3].name);
            ++n3;
        }
        int n4 = 0;
        while (n4 < comparablePredicateArray.length) {
            int n5 = 0;
            while (n5 < comparablePredicateArray[n4].params.length) {
                this.writeDouble(comparablePredicateArray[n4].params[n5]);
                ++n5;
            }
            ++n4;
        }
        this.close();
    }

    protected ComparablePredicate[] sortValues() {
        Object[] objectArray = new ComparablePredicate[this.PARAMS.length];
        int n = 0;
        int n2 = 0;
        while (n2 < this.PARAMS.length) {
            int[] nArray = this.PARAMS[n2].keys();
            Arrays.sort(nArray);
            int n3 = nArray.length;
            n += n3;
            int[] nArray2 = new int[n3];
            double[] dArray = new double[n3];
            int n4 = 0;
            int n5 = 0;
            while (n5 < nArray.length) {
                int n6;
                nArray2[n4] = n6 = nArray[n5];
                dArray[n4] = this.PARAMS[n2].get(n6);
                ++n4;
                ++n5;
            }
            objectArray[n2] = new ComparablePredicate(this.PRED_LABELS[n2], nArray2, dArray);
            ++n2;
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    protected List compressOutcomes(ComparablePredicate[] comparablePredicateArray) {
        ComparablePredicate comparablePredicate = comparablePredicateArray[0];
        ArrayList arrayList = new ArrayList();
        ArrayList<ComparablePredicate> arrayList2 = new ArrayList<ComparablePredicate>();
        int n = 0;
        while (n < comparablePredicateArray.length) {
            if (comparablePredicate.compareTo(comparablePredicateArray[n]) == 0) {
                arrayList2.add(comparablePredicateArray[n]);
            } else {
                comparablePredicate = comparablePredicateArray[n];
                arrayList.add(arrayList2);
                arrayList2 = new ArrayList();
                arrayList2.add(comparablePredicateArray[n]);
            }
            ++n;
        }
        arrayList.add(arrayList2);
        return arrayList;
    }
}

