/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent.io;

import java.io.IOException;
import java.util.StringTokenizer;
import opennlp.maxent.GISModel;
import opennlp.maxent.TIntParamHashMap;

public abstract class GISModelReader {
    protected int NUM_PREDS;

    protected abstract int readInt() throws IOException;

    protected abstract double readDouble() throws IOException;

    protected abstract String readUTF() throws IOException;

    public GISModel getModel() throws IOException {
        this.checkModelType();
        int n = this.getCorrectionConstant();
        double d = this.getCorrectionParameter();
        String[] stringArray = this.getOutcomes();
        int[][] nArray = this.getOutcomePatterns();
        String[] stringArray2 = this.getPredicates();
        TIntParamHashMap[] tIntParamHashMapArray = this.getParameters(nArray);
        return new GISModel(tIntParamHashMapArray, stringArray2, stringArray, n, d);
    }

    protected void checkModelType() throws IOException {
        String string = this.readUTF();
        if (!string.equals("GIS")) {
            System.out.println("Error: attempting to load a " + string + " model as a GIS model." + " You should expect problems.");
        }
    }

    protected int getCorrectionConstant() throws IOException {
        return this.readInt();
    }

    protected double getCorrectionParameter() throws IOException {
        return this.readDouble();
    }

    protected String[] getOutcomes() throws IOException {
        int n = this.readInt();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.readUTF();
            ++n2;
        }
        return stringArray;
    }

    protected int[][] getOutcomePatterns() throws IOException {
        int n = this.readInt();
        int[][] nArrayArray = new int[n][];
        int n2 = 0;
        while (n2 < n) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.readUTF(), " ");
            int[] nArray = new int[stringTokenizer.countTokens()];
            int n3 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                nArray[n3] = Integer.parseInt(stringTokenizer.nextToken());
                ++n3;
            }
            nArrayArray[n2] = nArray;
            ++n2;
        }
        return nArrayArray;
    }

    protected String[] getPredicates() throws IOException {
        this.NUM_PREDS = this.readInt();
        String[] stringArray = new String[this.NUM_PREDS];
        int n = 0;
        while (n < this.NUM_PREDS) {
            stringArray[n] = this.readUTF();
            ++n;
        }
        return stringArray;
    }

    protected TIntParamHashMap[] getParameters(int[][] nArray) throws IOException {
        TIntParamHashMap[] tIntParamHashMapArray = new TIntParamHashMap[this.NUM_PREDS];
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = 0;
            while (n3 < nArray[n2][0]) {
                tIntParamHashMapArray[n] = new TIntParamHashMap();
                int n4 = 1;
                while (n4 < nArray[n2].length) {
                    double d = this.readDouble();
                    tIntParamHashMapArray[n].put(nArray[n2][n4], d);
                    ++n4;
                }
                tIntParamHashMapArray[n].compact();
                ++n;
                ++n3;
            }
            ++n2;
        }
        return tIntParamHashMapArray;
    }
}

