/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Filter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredIterator<T>
implements Iterator<T> {
    Iterator<T> iterator = null;
    Filter<T> filter = null;
    T current = null;
    boolean hasCurrent = false;

    T currentCandidate() {
        return this.current;
    }

    void advanceCandidate() {
        if (!this.iterator.hasNext()) {
            this.hasCurrent = false;
            this.current = null;
            return;
        }
        this.hasCurrent = true;
        this.current = this.iterator.next();
    }

    boolean hasCurrentCandidate() {
        return this.hasCurrent;
    }

    boolean currentCandidateIsAcceptable() {
        return this.filter.accept(this.currentCandidate());
    }

    void skipUnacceptableCandidates() {
        while (this.hasCurrentCandidate() && !this.currentCandidateIsAcceptable()) {
            this.advanceCandidate();
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasCurrentCandidate();
    }

    @Override
    public T next() {
        T result = this.currentCandidate();
        this.advanceCandidate();
        this.skipUnacceptableCandidates();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public FilteredIterator(Iterator<T> iterator, Filter<T> filter) {
        this.iterator = iterator;
        this.filter = filter;
        this.advanceCandidate();
        this.skipUnacceptableCandidates();
    }

    public static void main(String[] args) {
        List<String> c = Arrays.asList("a", "aa", "b", "bb", "cc");
        FilteredIterator<String> i = new FilteredIterator<String>(c.iterator(), new Filter<String>(){

            @Override
            public boolean accept(String o) {
                return o.length() == 1;
            }
        });
        while (i.hasNext()) {
            System.out.println("Accepted: " + (String)i.next());
        }
    }
}

