/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.negra;

import edu.stanford.nlp.ling.StringLabelFactory;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.international.negra.NegraPennTokenizer;
import edu.stanford.nlp.trees.international.negra.NegraPennTreeNormalizer;
import java.io.Reader;
import java.io.Serializable;

public class NegraPennTreeReaderFactory
implements TreeReaderFactory,
Serializable {
    int nodeCleanup;
    TreebankLanguagePack tlp;
    boolean treeNormalizerInsertNPinPP;
    private static final long serialVersionUID = 1L;

    public NegraPennTreeReaderFactory() {
    }

    public NegraPennTreeReaderFactory(boolean treeNormalizerInsertNPinPP, boolean treeNormalizerLeaveGF) {
        this.treeNormalizerInsertNPinPP = treeNormalizerInsertNPinPP;
    }

    public NegraPennTreeReaderFactory(int nodeCleanup, boolean treeNormalizerInsertNPinPP, boolean treeNormalizerLeaveGF, TreebankLanguagePack tlp) {
        this.nodeCleanup = nodeCleanup;
        this.treeNormalizerInsertNPinPP = treeNormalizerInsertNPinPP;
        this.tlp = tlp;
        System.out.println("Node cleanup = " + nodeCleanup);
    }

    public TreeReader newTreeReader(Reader in) {
        NegraPennTreeNormalizer tn = new NegraPennTreeNormalizer(this.tlp, this.nodeCleanup);
        if (this.treeNormalizerInsertNPinPP) {
            tn.setInsertNPinPP(true);
        }
        return new PennTreeReader(in, new LabeledScoredTreeFactory(new StringLabelFactory()), tn, new NegraPennTokenizer(in));
    }
}

