/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.negra;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.ling.StringLabel;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NegraLabel
extends StringLabel {
    public static final String FEATURE_SEP = "#";
    private String edge;
    private Map<String, String> features;

    @Override
    public LabelFactory labelFactory() {
        return new NegraLabelFactory();
    }

    public void setEdge(String edge) {
        this.edge = edge;
    }

    public String getEdge() {
        return this.edge;
    }

    private NegraLabel() {
    }

    public NegraLabel(String str) {
        this(str, new HashMap<String, String>());
    }

    public NegraLabel(String str, Map<String, String> features) {
        this(str, null, features);
    }

    public NegraLabel(String str, String edge, Map<String, String> features) {
        super(str);
        this.edge = edge;
        this.features = features;
    }

    public void setFeatureValue(String feature, String value) {
        this.features.put(feature, value);
    }

    public String featureValue(String feature) {
        return this.features.get(feature);
    }

    @Override
    public String toString() {
        String str = this.value();
        if (this.edge != null) {
            str = str + "->" + this.getEdge();
        }
        if (!this.features.isEmpty()) {
            str = str + "." + this.features.toString();
        }
        return str;
    }

    private static class NegraLabelFactory
    implements LabelFactory {
        private NegraLabelFactory() {
        }

        public Label newLabel(String labelStr) {
            return new NegraLabel(labelStr);
        }

        public Label newLabel(String labelStr, int options) {
            return this.newLabel(labelStr);
        }

        public Label newLabelFromString(String encodedLabelStr) {
            return this.newLabel(encodedLabelStr);
        }

        public Label newLabel(Label oldLabel) {
            NegraLabel result;
            if (oldLabel instanceof NegraLabel) {
                NegraLabel l = (NegraLabel)oldLabel;
                result = new NegraLabel(l.value(), l.getEdge(), new HashMap<String, String>());
                for (Map.Entry e : l.features.entrySet()) {
                    result.features.put(e.getKey(), e.getValue());
                }
            } else {
                result = new NegraLabel(oldLabel.value());
            }
            return result;
        }
    }
}

