/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.ling.StringLabelFactory;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.LabeledScoredTreeLeaf;
import edu.stanford.nlp.trees.LabeledScoredTreeNode;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeFunctions;
import edu.stanford.nlp.trees.TreeNormalizer;
import edu.stanford.nlp.trees.TreeVisitor;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.MutableInteger;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trees {
    public static int leftEdge(Tree t, Tree root) {
        MutableInteger i = new MutableInteger(0);
        if (Trees.leftEdge(t, root, i)) {
            return i.intValue();
        }
        return -1;
    }

    static boolean leftEdge(Tree t, Tree t1, MutableInteger i) {
        if (t == t1) {
            return true;
        }
        if (t1.isLeaf()) {
            int j = t1.yield().size();
            i.set(i.intValue() + j);
            return false;
        }
        Tree[] kids = t1.children();
        int n = kids.length;
        for (int j = 0; j < n; ++j) {
            if (!Trees.leftEdge(t, kids[j], i)) continue;
            return true;
        }
        return false;
    }

    public static int rightEdge(Tree t, Tree root) {
        MutableInteger i = new MutableInteger(root.yield().size());
        if (Trees.rightEdge(t, root, i)) {
            return i.intValue();
        }
        return root.yield().size() + 1;
    }

    static boolean rightEdge(Tree t, Tree t1, MutableInteger i) {
        if (t == t1) {
            return true;
        }
        if (t1.isLeaf()) {
            int j = t1.yield().size();
            i.set(i.intValue() - j);
            return false;
        }
        Tree[] kids = t1.children();
        for (int j = kids.length - 1; j >= 0; --j) {
            if (!Trees.rightEdge(t, kids[j], i)) continue;
            return true;
        }
        return false;
    }

    public static Tree lexicalize(Tree t, HeadFinder hf) {
        Function<Tree, Tree> a = TreeFunctions.getLabeledTreeToCategoryWordTagTreeFunction();
        Tree t1 = a.apply(t);
        t1.percolateHeads(hf);
        return t1;
    }

    public static List<Tree> leaves(Tree t) {
        ArrayList<Tree> l = new ArrayList<Tree>();
        Trees.leaves(t, l);
        return l;
    }

    private static void leaves(Tree t, List<Tree> l) {
        if (t.isLeaf()) {
            l.add(t);
        } else {
            Tree[] kids = t.children();
            int n = kids.length;
            for (int j = 0; j < n; ++j) {
                Trees.leaves(kids[j], l);
            }
        }
    }

    public static List<Tree> preTerminals(Tree t) {
        ArrayList<Tree> l = new ArrayList<Tree>();
        Trees.preTerminals(t, l);
        return l;
    }

    private static void preTerminals(Tree t, List<Tree> l) {
        if (t.isPreTerminal()) {
            l.add(t);
        } else {
            Tree[] kids = t.children();
            int n = kids.length;
            for (int j = 0; j < n; ++j) {
                Trees.preTerminals(kids[j], l);
            }
        }
    }

    public static List<Label> leafLabels(Tree t) {
        ArrayList<Label> l = new ArrayList<Label>();
        Trees.leafLabels(t, l);
        return l;
    }

    private static void leafLabels(Tree t, List<Label> l) {
        if (t.isLeaf()) {
            l.add(t.label());
        } else {
            Tree[] kids = t.children();
            int n = kids.length;
            for (int j = 0; j < n; ++j) {
                Trees.leafLabels(kids[j], l);
            }
        }
    }

    public static List<CoreLabel> taggedLeafLabels(Tree t) {
        ArrayList<CoreLabel> l = new ArrayList<CoreLabel>();
        Trees.taggedLeafLabels(t, l);
        return l;
    }

    private static void taggedLeafLabels(Tree t, List<CoreLabel> l) {
        if (t.isPreTerminal()) {
            CoreLabel fl = (CoreLabel)t.getChild(0).label();
            fl.set(CoreAnnotations.TagLabelAnnotation.class, t.label());
            l.add(fl);
        } else {
            Tree[] kids = t.children();
            int n = kids.length;
            for (int j = 0; j < n; ++j) {
                Trees.taggedLeafLabels(kids[j], l);
            }
        }
    }

    public static boolean heads(Tree head, Tree node, HeadFinder hf) {
        if (node.isLeaf()) {
            return false;
        }
        return Trees.heads(head, hf.determineHead(node), hf);
    }

    public static Tree maximalProjection(Tree head, Tree root, HeadFinder hf) {
        Tree projection = head;
        if (projection == root) {
            return root;
        }
        Tree parent = projection.parent(root);
        while (hf.determineHead(parent) == projection) {
            projection = parent;
            if (projection == root) {
                return root;
            }
            parent = projection.parent(root);
        }
        return projection;
    }

    public static Tree applyToProjections(TreeVisitor v, Tree head, Tree root, HeadFinder hf) {
        Tree projection = head;
        Tree parent = projection.parent(root);
        if (parent == null && projection != root) {
            return null;
        }
        v.visitTree(projection);
        if (projection == root) {
            return root;
        }
        while (hf.determineHead(parent) == projection) {
            projection = parent;
            v.visitTree(projection);
            if (projection == root) {
                return root;
            }
            parent = projection.parent(root);
        }
        return projection;
    }

    public static Tree getTerminal(Tree tree, int n) {
        return Trees.getTerminal(tree, new MutableInteger(0), n);
    }

    static Tree getTerminal(Tree tree, MutableInteger i, int n) {
        if (i.intValue() == n) {
            if (tree.isLeaf()) {
                return tree;
            }
            return Trees.getTerminal(tree.children()[0], i, n);
        }
        if (tree.isLeaf()) {
            i.set(i.intValue() + tree.yield().size());
            return null;
        }
        Tree[] kids = tree.children();
        for (int j = 0; j < kids.length; ++j) {
            Tree result = Trees.getTerminal(kids[j], i, n);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static Tree getPreTerminal(Tree tree, int n) {
        return Trees.getPreTerminal(tree, new MutableInteger(0), n);
    }

    static Tree getPreTerminal(Tree tree, MutableInteger i, int n) {
        if (i.intValue() == n) {
            if (tree.isPreTerminal()) {
                return tree;
            }
            return Trees.getPreTerminal(tree.children()[0], i, n);
        }
        if (tree.isPreTerminal()) {
            i.set(i.intValue() + tree.yield().size());
            return null;
        }
        Tree[] kids = tree.children();
        for (int j = 0; j < kids.length; ++j) {
            Tree result = Trees.getPreTerminal(kids[j], i, n);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static List<String> localTreeAsCatList(Tree t) {
        ArrayList<String> l = new ArrayList<String>(t.children().length + 1);
        l.add(t.label().value());
        for (int i = 0; i < t.children().length; ++i) {
            l.add(t.children()[i].label().value());
        }
        return l;
    }

    public static int objectEqualityIndexOf(Tree parent, Tree daughter) {
        for (int i = 0; i < parent.children().length; ++i) {
            if (daughter != parent.children()[i]) continue;
            return i;
        }
        return -1;
    }

    public static String toDebugStructureString(Tree t) {
        StringBuilder sb = new StringBuilder();
        String tCl = StringUtils.getShortClassName(t);
        String tfCl = StringUtils.getShortClassName(t.treeFactory());
        String lCl = StringUtils.getShortClassName(t.label());
        String lfCl = StringUtils.getShortClassName(t.label().labelFactory());
        HashSet<String> otherClasses = new HashSet<String>();
        for (Tree st : t) {
            String stCl = StringUtils.getShortClassName(st);
            String stfCl = StringUtils.getShortClassName(st.treeFactory());
            String slCl = StringUtils.getShortClassName(st.label());
            String slfCl = StringUtils.getShortClassName(st.label().labelFactory());
            if (!tCl.equals(stCl)) {
                otherClasses.add(stCl);
            }
            if (!tfCl.equals(stfCl)) {
                otherClasses.add(stfCl);
            }
            if (!lCl.equals(slCl)) {
                otherClasses.add(slCl);
            }
            if (lfCl.equals(slfCl)) continue;
            otherClasses.add(slfCl);
        }
        sb.append("Tree with root of class ").append(tCl).append(" and factory ").append(tfCl);
        sb.append(" with label class ").append(lCl).append(" and factory ").append(lfCl);
        if (!otherClasses.isEmpty()) {
            sb.append(" with the following classes also found within the tree: ").append(otherClasses);
        }
        return sb.toString();
    }

    public static Tree toFlatTree(Sentence<?> s) {
        return Trees.toFlatTree(s, new StringLabelFactory());
    }

    public static Tree toFlatTree(Sentence<?> s, LabelFactory lf) {
        ArrayList<Tree> daughters = new ArrayList<Tree>(s.length());
        for (HasWord word : s) {
            Tree wordNode = new LabeledScoredTreeLeaf(lf.newLabel(word.word()));
            if (word instanceof TaggedWord) {
                TaggedWord taggedWord = (TaggedWord)word;
                wordNode = new LabeledScoredTreeNode(new StringLabel(taggedWord.tag()), Collections.singletonList(wordNode));
            } else {
                wordNode = new LabeledScoredTreeNode(lf.newLabel("WD"), Collections.singletonList(wordNode));
            }
            daughters.add(wordNode);
        }
        return new LabeledScoredTreeNode(new StringLabel("S"), daughters);
    }

    public static String treeToLatex(Tree t) {
        StringBuilder connections = new StringBuilder();
        StringBuilder hierarchy = new StringBuilder();
        Trees.treeToLatexHelper(t, connections, hierarchy, 0, 1, 0);
        return "\\tree" + hierarchy + "\n" + connections + "\n";
    }

    private static int treeToLatexHelper(Tree t, StringBuilder c, StringBuilder h, int n, int nextN, int indent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            sb.append("  ");
        }
        h.append("\n" + sb);
        h.append("{\\" + (t.isLeaf() ? "" : "n") + "tnode{z" + n + "}{" + t.label() + "}");
        if (!t.isLeaf()) {
            for (int k = 0; k < t.children().length; ++k) {
                h.append(", ");
                c.append("\\nodeconnect{z" + n + "}{z" + nextN + "}\n");
                nextN = Trees.treeToLatexHelper(t.children()[k], c, h, nextN, nextN + 1, indent + 1);
            }
        }
        h.append("}");
        return nextN;
    }

    public static String treeToLatexEven(Tree t) {
        StringBuilder connections = new StringBuilder();
        StringBuilder hierarchy = new StringBuilder();
        int maxDepth = t.depth();
        Trees.treeToLatexEvenHelper(t, connections, hierarchy, 0, 1, 0, 0, maxDepth);
        return "\\tree" + hierarchy + "\n" + connections + "\n";
    }

    private static int treeToLatexEvenHelper(Tree t, StringBuilder c, StringBuilder h, int n, int nextN, int indent, int curDepth, int maxDepth) {
        int pad;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            sb.append("  ");
        }
        h.append("\n" + sb);
        int tDepth = t.depth();
        if (tDepth == 0 && tDepth + curDepth < maxDepth) {
            for (pad = 0; pad < maxDepth - tDepth - curDepth; ++pad) {
                h.append("{\\ntnode{pad}{}, ");
            }
        }
        h.append("{\\ntnode{z" + n + "}{" + t.label() + "}");
        if (!t.isLeaf()) {
            for (int k = 0; k < t.children().length; ++k) {
                h.append(", ");
                c.append("\\nodeconnect{z" + n + "}{z" + nextN + "}\n");
                nextN = Trees.treeToLatexEvenHelper(t.children()[k], c, h, nextN, nextN + 1, indent + 1, curDepth + 1, maxDepth);
            }
        }
        if (tDepth == 0 && tDepth + curDepth < maxDepth) {
            for (pad = 0; pad < maxDepth - tDepth - curDepth; ++pad) {
                h.append("}");
            }
        }
        h.append("}");
        return nextN;
    }

    static String texTree(Tree t) {
        return Trees.treeToLatex(t);
    }

    static Tree readTree(String s) throws IOException {
        return new PennTreeReader((Reader)new StringReader(s), new LabeledScoredTreeFactory(new StringLabelFactory())).readTree();
    }

    static String escape(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '^') {
                sb.append('\\');
            }
            sb.append(c);
            if (c != '^') continue;
            sb.append("{}");
        }
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        Tree tree;
        int i;
        for (i = 0; i < args.length; ++i) {
            tree = Trees.readTree(args[i]);
            System.out.println(Trees.escape(Trees.texTree(tree)));
        }
        if (i == 0) {
            tree = new PennTreeReader((Reader)new BufferedReader(new InputStreamReader(System.in)), new LabeledScoredTreeFactory(new StringLabelFactory())).readTree();
            System.out.println(Trees.escape(Trees.texTree(tree)));
        }
    }

    public static Tree normalizeTree(Tree tree, TreeNormalizer tn, TreeFactory tf) {
        for (Tree node : tree) {
            if (node.isLeaf()) {
                node.label().setValue(tn.normalizeTerminal(node.label().value()));
                continue;
            }
            node.label().setValue(tn.normalizeNonterminal(node.label().value()));
        }
        return tn.normalizeWholeTree(tree, tf);
    }
}

