/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.CyclicCoreLabel;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.trees.Dependency;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.SemanticHeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeGraph;
import edu.stanford.nlp.trees.TreeGraphNodeFactory;
import edu.stanford.nlp.trees.UnnamedDependency;
import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.Generics;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeGraphNode
extends Tree {
    protected CyclicCoreLabel label;
    protected TreeGraphNode parent = null;
    protected TreeGraphNode[] children = ZERO_TGN_CHILDREN;
    protected TreeGraph tg;
    protected static final TreeGraphNode[] ZERO_TGN_CHILDREN = new TreeGraphNode[0];
    private static LabelFactory mlf = CyclicCoreLabel.factory();
    private static final long serialVersionUID = 5080098143617475328L;

    public TreeGraphNode() {
    }

    public TreeGraphNode(Label label) {
        this.label = (CyclicCoreLabel)mlf.newLabel(label);
    }

    public TreeGraphNode(Label label, List<Tree> children) {
        this(label);
        this.setChildren(children);
    }

    public TreeGraphNode(Tree t, TreeGraph graph) {
        this(t, (TreeGraphNode)null);
        this.setTreeGraph(graph);
    }

    public TreeGraphNode(TreeGraphNode t) {
        this((Tree)t, t.parent);
        this.setTreeGraph(t.treeGraph());
    }

    protected TreeGraphNode(Tree t, TreeGraphNode parent) {
        this.parent = parent;
        Tree[] tKids = t.children();
        int numKids = tKids.length;
        this.children = new TreeGraphNode[numKids];
        for (int i = 0; i < numKids; ++i) {
            this.children[i] = new TreeGraphNode(tKids[i], this);
            if (!t.isPreTerminal()) continue;
            this.children[i].label.setTag(t.label().value());
        }
        this.label = (CyclicCoreLabel)mlf.newLabel(t.label());
    }

    @Override
    public boolean equals(Object o) {
        return o == this;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public CyclicCoreLabel label() {
        return this.label;
    }

    public void setLabel(CyclicCoreLabel label) {
        this.label = label;
    }

    public int index() {
        return this.label.index();
    }

    protected void setIndex(int index) {
        this.label.setIndex(index);
    }

    private int indexLeaves(int startIndex) {
        if (this.isLeaf()) {
            int oldIndex = this.index();
            if (oldIndex >= 0) {
                startIndex = oldIndex;
            } else {
                this.setIndex(startIndex);
            }
            if (this.tg != null) {
                this.tg.addNodeToIndexMap(startIndex, this);
            }
            ++startIndex;
        } else {
            for (int i = 0; i < this.children.length; ++i) {
                startIndex = this.children[i].indexLeaves(startIndex);
            }
        }
        return startIndex;
    }

    private int indexNodes(int startIndex) {
        if (this.index() < 0) {
            if (this.tg != null) {
                this.tg.addNodeToIndexMap(startIndex, this);
            }
            this.setIndex(startIndex++);
        }
        if (!this.isLeaf()) {
            for (int i = 0; i < this.children.length; ++i) {
                startIndex = this.children[i].indexNodes(startIndex);
            }
        }
        return startIndex;
    }

    protected void indexNodes() {
        this.indexNodes(this.indexLeaves(1));
    }

    @Override
    public Tree parent() {
        return this.parent;
    }

    public void setParent(TreeGraphNode parent) {
        this.parent = parent;
    }

    public TreeGraphNode[] children() {
        return this.children;
    }

    @Override
    public void setChildren(Tree[] children) {
        this.children = children == null ? ZERO_TGN_CHILDREN : (TreeGraphNode[])children;
    }

    protected TreeGraph treeGraph() {
        return this.tg;
    }

    protected void setTreeGraph(TreeGraph tg) {
        this.tg = tg;
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i].setTreeGraph(tg);
        }
    }

    public boolean addArc(Class<? extends GrammaticalRelation.GrammaticalRelationAnnotation> arcLabel, TreeGraphNode node) {
        if (node == null) {
            return false;
        }
        if (!this.treeGraph().equals(node.treeGraph())) {
            System.err.println("Warning: you are trying to add an arc from node " + this + " to node " + node + ", but they do not belong to the same TreeGraph!");
        }
        if (!this.label.containsKey(arcLabel)) {
            this.label.set(arcLabel, new HashSet());
        }
        return ((Set)this.label.get(arcLabel)).add(node);
    }

    public Set<TreeGraphNode> followArcToSet(Class<? extends GrammaticalRelation.GrammaticalRelationAnnotation> arcLabel) {
        return (Set)this.label().get(arcLabel);
    }

    public TreeGraphNode followArcToNode(Class<? extends GrammaticalRelation.GrammaticalRelationAnnotation> arcLabel) {
        Set<TreeGraphNode> valueSet = this.followArcToSet(arcLabel);
        if (valueSet == null) {
            return null;
        }
        return valueSet.iterator().next();
    }

    public Set<Class<? extends GrammaticalRelation.GrammaticalRelationAnnotation>> arcLabelsToNode(TreeGraphNode destNode) {
        HashSet<Class<? extends GrammaticalRelation.GrammaticalRelationAnnotation>> arcLabels = Generics.newHashSet();
        CyclicCoreLabel cl = this.label();
        for (Class<?> key : cl.keySet()) {
            Object val = cl.get(key);
            if (val == null || !(val instanceof Set) || !((Set)val).contains(destNode) || key == null) continue;
            arcLabels.add(key);
        }
        return arcLabels;
    }

    public Class<? extends GrammaticalRelation.GrammaticalRelationAnnotation> arcLabelToNode(TreeGraphNode destNode) {
        Set<Class<? extends GrammaticalRelation.GrammaticalRelationAnnotation>> arcLabels = this.arcLabelsToNode(destNode);
        if (arcLabels == null) {
            return null;
        }
        return new ArrayList<Class<? extends GrammaticalRelation.GrammaticalRelationAnnotation>>(arcLabels).get(0);
    }

    @Override
    public void percolateHeads(HeadFinder hf) {
        if (this.isLeaf()) {
            TreeGraphNode hwn = this.headWordNode();
            if (hwn == null) {
                this.setHeadWordNode(this);
            }
        } else {
            TreeGraphNode[] kids = this.children();
            for (int i = 0; i < kids.length; ++i) {
                ((Tree)kids[i]).percolateHeads(hf);
            }
            TreeGraphNode head = this.safeCast(hf.determineHead(this, this.parent));
            if (head != null) {
                TreeGraphNode hwn = head.headWordNode();
                if (hwn == null && head.isLeaf()) {
                    this.setHeadWordNode(head);
                } else {
                    this.setHeadWordNode(hwn);
                }
                TreeGraphNode htn = head.headTagNode();
                if (htn == null && head.isLeaf()) {
                    this.setHeadTagNode(this);
                } else {
                    this.setHeadTagNode(htn);
                }
            } else {
                System.err.println("Head is null: " + this);
            }
        }
    }

    @Override
    public Set<Dependency> dependencies(Filter<Dependency> f, HeadFinder hf) {
        HashSet<Dependency> deps = Generics.newHashSet();
        Iterator<Tree> it = this.subTrees().iterator();
        while (it.hasNext()) {
            TreeGraphNode node = this.safeCast(it.next());
            if (node == null || node.isLeaf() || node.children().length < 2) continue;
            TreeGraphNode headWordNode = hf != null ? this.safeCast(node.headTerminal(hf)) : node.headWordNode();
            TreeGraphNode[] kids = node.children();
            for (int i = 0; i < kids.length; ++i) {
                UnnamedDependency d;
                TreeGraphNode kid = this.safeCast(kids[i]);
                if (kid == null) continue;
                TreeGraphNode kidHeadWordNode = hf != null ? this.safeCast(kid.headTerminal(hf)) : kid.headWordNode();
                if (headWordNode == null || headWordNode == kidHeadWordNode || !f.accept(d = new UnnamedDependency(headWordNode, kidHeadWordNode))) continue;
                deps.add(d);
            }
        }
        return deps;
    }

    public TreeGraphNode headWordNode() {
        TreeGraphNode hwn = this.safeCast(this.label.get(TreeCoreAnnotations.HeadWordAnnotation.class));
        if (hwn == null || hwn.treeGraph() != null && !hwn.treeGraph().equals(this.treeGraph())) {
            return null;
        }
        return hwn;
    }

    private void setHeadWordNode(TreeGraphNode hwn) {
        this.label.set(TreeCoreAnnotations.HeadWordAnnotation.class, hwn);
    }

    public TreeGraphNode headTagNode() {
        TreeGraphNode htn = this.safeCast(this.label.get(TreeCoreAnnotations.HeadTagAnnotation.class));
        if (htn == null || htn.treeGraph() != null && !htn.treeGraph().equals(this.treeGraph())) {
            return null;
        }
        return htn;
    }

    private void setHeadTagNode(TreeGraphNode htn) {
        this.label.set(TreeCoreAnnotations.HeadTagAnnotation.class, htn);
    }

    private TreeGraphNode safeCast(Object t) {
        if (t == null || !(t instanceof TreeGraphNode)) {
            return null;
        }
        return (TreeGraphNode)t;
    }

    public TreeGraphNode highestNodeWithSameHead() {
        TreeGraphNode parent = null;
        TreeGraphNode node = this;
        while ((parent = this.safeCast(node.parent())) != null && parent.headWordNode() == node.headWordNode()) {
            node = parent;
        }
        return node;
    }

    @Override
    public TreeFactory treeFactory() {
        LabelFactory lf = this.label() != null ? this.label().labelFactory() : CyclicCoreLabel.factory();
        return new TreeGraphNodeFactory(lf);
    }

    public static TreeFactory factory() {
        return TreeFactoryHolder.tgnf;
    }

    public static TreeFactory factory(LabelFactory lf) {
        return new TreeGraphNodeFactory(lf);
    }

    public String toPrettyString(int indentLevel) {
        int i;
        StringBuilder buf = new StringBuilder("\n");
        for (i = 0; i < indentLevel; ++i) {
            buf.append("  ");
        }
        if (this.children == null || this.children.length == 0) {
            buf.append(this.label.toString("value-index{map}"));
        } else {
            buf.append("(").append(this.label.toString("value-index{map}"));
            for (i = 0; i < this.children.length; ++i) {
                buf.append(" ").append(this.children[i].toPrettyString(indentLevel + 1));
            }
            buf.append(")");
        }
        return buf.toString();
    }

    public String toOneLineString() {
        StringBuilder buf = new StringBuilder();
        if (this.children == null || this.children.length == 0) {
            buf.append(this.label);
        } else {
            buf.append("(").append(this.label);
            for (int i = 0; i < this.children.length; ++i) {
                buf.append(" ").append(this.children[i].toString());
            }
            buf.append(")");
        }
        return buf.toString();
    }

    @Override
    public String toString() {
        return this.label.toString();
    }

    public static void main(String[] args) {
        try {
            PennTreeReader tr = new PennTreeReader((Reader)new StringReader("(S (NP (NNP Sam)) (VP (VBD died) (NP (NN today))))"), new LabeledScoredTreeFactory());
            Tree t = tr.readTree();
            System.out.println(t);
            TreeGraphNode tgn = new TreeGraphNode(t, (TreeGraphNode)null);
            System.out.println(tgn.toPrettyString(0));
            tgn.indexNodes();
            System.out.println(tgn.toPrettyString(0));
            tgn.percolateHeads(new SemanticHeadFinder());
            System.out.println(tgn.toPrettyString(0));
        }
        catch (Exception e) {
            System.err.println("Horrible error: " + e);
            e.printStackTrace();
        }
    }

    private static class TreeFactoryHolder {
        static final TreeGraphNodeFactory tgnf = new TreeGraphNodeFactory();

        private TreeFactoryHolder() {
        }
    }
}

