/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.trees.ModCollinsHeadFinder;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticHeadFinder
extends ModCollinsHeadFinder {
    private static final boolean DEBUG = false;
    private HashSet<String> verbalAuxiliaries;
    private HashSet<String> copulars;
    private HashSet<String> verbalTags;
    private static final long serialVersionUID = 5721799188009249808L;

    public SemanticHeadFinder() {
        this(new PennTreebankLanguagePack(), true);
    }

    public SemanticHeadFinder(boolean cop) {
        this(new PennTreebankLanguagePack(), cop);
    }

    public SemanticHeadFinder(TreebankLanguagePack tlp, boolean cop) {
        super(tlp);
        this.ruleChanges();
        this.verbalAuxiliaries = new HashSet();
        this.verbalAuxiliaries.addAll(Arrays.asList("will", "wo", "shall", "may", "might", "should", "would", "can", "could", "ca", "must", "has", "have", "had", "having", "be", "being", "been", "get", "gets", "getting", "got", "gotten", "do", "does", "did", "to", "'ve", "'d", "'ll"));
        this.copulars = new HashSet();
        if (cop) {
            this.copulars.addAll(Arrays.asList("be", "being", "Being", "am", "are", "is", "was", "were", "'m", "'re", "'s", "s", "seem", "seems", "seemed", "appear", "appears", "appeared", "stay", "stays", "stayed", "remain", "remains", "remained", "resemble", "resembles", "resembled", "become", "becomes", "became"));
        }
        this.verbalTags = new HashSet();
        this.verbalTags.addAll(Arrays.asList("TO", "MD", "VB", "VBD", "VBP", "VBZ", "VBG", "VBN", "AUX", "AUXG"));
    }

    private void ruleChanges() {
        this.nonTerminalInfo.remove("NP");
        this.nonTerminalInfo.put("NP", new String[][]{{"rightdis", "NN", "NNP", "NNPS", "NNS", "NX", "JJR"}, {"left", "NP", "PRP"}, {"rightdis", "$", "ADJP", "PRN"}, {"right", "CD"}, {"rightdis", "JJ", "JJS", "RB", "QP", "DT", "WDT", "RBR", "ADVP"}, {"left", "POS"}});
        this.nonTerminalInfo.remove("WHNP");
        this.nonTerminalInfo.put("WHNP", new String[][]{{"left", "NP", "WP"}, {"rightdis", "NN", "NNP", "NNPS", "NNS", "NX", "POS", "JJR"}, {"rightdis", "$", "ADJP", "PRN"}, {"right", "CD"}, {"rightdis", "JJ", "JJS", "RB", "QP"}, {"left", "WHNP", "WHPP", "WHADJP", "WP$", "WP", "WDT"}});
        this.nonTerminalInfo.remove("WHADJP");
        this.nonTerminalInfo.put("WHADJP", new String[][]{{"left", "ADJP", "JJ", "WRB", "CC"}});
        this.nonTerminalInfo.remove("ADJP");
        this.nonTerminalInfo.put("ADJP", new String[][]{{"left", "$", "JJ", "NNS", "NN", "QP", "VBN", "VBG", "ADJP", "JJR", "NP", "JJS", "DT", "FW", "RBR", "RBS", "SBAR", "RB"}});
        this.nonTerminalInfo.remove("QP");
        this.nonTerminalInfo.put("QP", new String[][]{{"right", "$", "NNS", "NN", "CD", "JJ", "PDT", "DT", "IN", "RB", "NCD", "QP", "JJR", "JJS"}});
        this.nonTerminalInfo.remove("S");
        this.nonTerminalInfo.put("S", new String[][]{{"left", "VP", "S", "FRAG", "SBAR", "ADJP", "UCP", "TO"}, {"right", "NP"}});
        this.nonTerminalInfo.remove("SBAR");
        this.nonTerminalInfo.put("SBAR", new String[][]{{"left", "S", "SQ", "SINV", "SBAR", "FRAG", "WHNP", "WHPP", "WHADVP", "WHADJP", "IN", "DT"}});
        this.nonTerminalInfo.remove("SQ");
        this.nonTerminalInfo.put("SQ", new String[][]{{"left", "VP", "SQ", "VB", "VBZ", "VBD", "VBP", "MD"}});
        this.nonTerminalInfo.remove("UCP");
        this.nonTerminalInfo.put("UCP", new String[][]{{"left"}});
        this.nonTerminalInfo.remove("CONJP");
        this.nonTerminalInfo.put("CONJP", new String[][]{{"right", "TO", "RB", "IN", "CC"}});
        this.nonTerminalInfo.remove("FRAG");
        this.nonTerminalInfo.put("FRAG", new String[][]{{"left", "ADJP", "ADVP", "FRAG", "S"}});
        this.nonTerminalInfo.remove("PP");
        this.nonTerminalInfo.put("PP", new String[][]{{"right", "IN", "TO", "VBG", "VBN", "RP", "FW"}, {"left", "PP"}});
        this.nonTerminalInfo.put("PRN", new String[][]{{"left", "VP", "S", "SINV", "SBAR", "NP", "ADJP", "PP", "ADVP", "INTJ", "WHNP", "NAC", "VBP", "JJ", "NN", "NNP"}});
        this.nonTerminalInfo.put("XS", new String[][]{{"right", "IN"}});
    }

    @Override
    protected int postOperationFix(int headIdx, Tree[] daughterTrees) {
        String prevLab;
        if (headIdx >= 2 && ((prevLab = this.tlp.basicCategory(daughterTrees[headIdx - 1].value())).equals("CC") || prevLab.equals("CONJP"))) {
            int newHeadIdx;
            Tree t = daughterTrees[newHeadIdx];
            for (newHeadIdx = headIdx - 2; newHeadIdx >= 0 && t.isPreTerminal() && this.tlp.isPunctuationTag(t.value()); --newHeadIdx) {
            }
            while (newHeadIdx >= 2 && this.tlp.isPunctuationTag(daughterTrees[newHeadIdx - 1].value())) {
                newHeadIdx -= 2;
            }
            if (newHeadIdx >= 0) {
                headIdx = newHeadIdx;
            }
        }
        return headIdx;
    }

    @Override
    protected Tree determineNonTrivialHead(Tree t, Tree parent) {
        String motherCat = this.tlp.basicCategory(t.label().value());
        if (motherCat.equals("VP") || motherCat.equals("SQ") || motherCat.equals("SINV")) {
            String[] how;
            Tree pti;
            Tree[] kids = t.children();
            if (this.hasVerbalAuxiliary(kids, this.verbalAuxiliaries) && (pti = this.traverseLocate(kids, how = new String[]{"left", "VP", "ADJP"}, false)) != null) {
                return pti;
            }
            if (this.hasVerbalAuxiliary(kids, this.copulars) && !this.isExistential(t, parent) && !SemanticHeadFinder.isWHQ(t, parent) && (pti = this.traverseLocate(kids, how = motherCat.equals("SQ") ? new String[]{"right", "VP", "ADJP", "NP", "WHADJP", "WHNP"} : new String[]{"left", "VP", "ADJP", "NP", "WHADJP", "WHNP"}, false)) != null) {
                return pti;
            }
        }
        return super.determineNonTrivialHead(t, parent);
    }

    private boolean isExistential(Tree t, Tree parent) {
        boolean toReturn;
        block5: {
            Tree[] kids;
            String motherCat;
            block4: {
                Tree[] kids2;
                toReturn = false;
                motherCat = this.tlp.basicCategory(t.label().value());
                if (!motherCat.equals("VP") || parent == null) break block4;
                for (Tree kid : kids2 = parent.children()) {
                    if (kid.value().equals("VP")) break;
                    List<Label> tags = kid.preTerminalYield();
                    for (Label tag : tags) {
                        if (!tag.value().equals("EX")) continue;
                        toReturn = true;
                    }
                }
                break block5;
            }
            if (!motherCat.startsWith("SQ") || parent == null) break block5;
            for (Tree kid : kids = parent.children()) {
                if (kid.value().startsWith("VB")) continue;
                List<Label> tags = kid.preTerminalYield();
                for (Label tag : tags) {
                    if (!tag.value().equals("EX")) continue;
                    toReturn = true;
                }
            }
        }
        return toReturn;
    }

    private static boolean isWHQ(Tree t, Tree parent) {
        if (t == null) {
            return false;
        }
        boolean toReturn = false;
        if (t.value().startsWith("SQ") && parent != null && parent.value().equals("SBARQ")) {
            Tree[] kids;
            for (Tree kid : kids = parent.children()) {
                if (!kid.value().startsWith("WH")) continue;
                toReturn = true;
            }
        }
        return toReturn;
    }

    public boolean isVerbalAuxiliary(Tree t) {
        Tree[] trees = new Tree[]{t};
        return this.hasVerbalAuxiliary(trees, this.verbalAuxiliaries);
    }

    private boolean hasVerbalAuxiliary(Tree[] kids, HashSet<String> verbalSet) {
        for (int i = 0; i < kids.length; ++i) {
            Label kidLabel = kids[i].label();
            String cat = this.tlp.basicCategory(kidLabel.value());
            String word = null;
            if (kidLabel instanceof HasWord) {
                word = ((HasWord)((Object)kidLabel)).word();
            }
            if (word == null) {
                Label htl = kids[i].headTerminal(this).label();
                if (htl instanceof HasWord) {
                    word = ((HasWord)((Object)htl)).word();
                }
                if (word == null) {
                    word = htl.value();
                }
            }
            String tag = null;
            if (kidLabel instanceof HasTag) {
                tag = ((HasTag)((Object)kidLabel)).tag();
            }
            if (tag == null) {
                tag = kids[i].headPreTerminal(this).value();
            }
            String lcWord = word.toLowerCase();
            if ("PP".equals(cat) || !this.verbalTags.contains(tag) || !verbalSet.contains(lcWord)) continue;
            return true;
        }
        return false;
    }
}

