/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasIndex;
import edu.stanford.nlp.objectbank.ObjectBank;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.LabeledScoredTreeReaderFactory;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.SimpleTreeReaderFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.TreeVisitor;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.util.CollectionValuedMap;
import edu.stanford.nlp.util.FilePathProcessor;
import edu.stanford.nlp.util.FileProcessor;
import edu.stanford.nlp.util.Timing;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MemoryTreebank
extends Treebank
implements FileProcessor,
List<Tree> {
    private static final boolean PRINT_FILENAMES = false;
    private List<Tree> parseTrees;
    private Map<String, CollectionValuedMap<Integer, String>> srlMap = null;

    public MemoryTreebank() {
        this(new LabeledScoredTreeReaderFactory());
    }

    public MemoryTreebank(String encoding) {
        this(new LabeledScoredTreeReaderFactory(), encoding);
    }

    public MemoryTreebank(TreeReaderFactory trf) {
        super(trf);
        this.parseTrees = new ArrayList<Tree>();
    }

    public MemoryTreebank(TreeReaderFactory trf, String encoding) {
        super(trf, encoding);
        this.parseTrees = new ArrayList<Tree>();
    }

    public MemoryTreebank(List<Tree> trees, TreeReaderFactory trf, String encoding) {
        super(trf, encoding);
        this.parseTrees = trees;
    }

    public MemoryTreebank(int initialCapacity) {
        this(initialCapacity, new SimpleTreeReaderFactory());
    }

    public MemoryTreebank(int initialCapacity, TreeReaderFactory trf) {
        super(initialCapacity, trf);
        this.parseTrees = new ArrayList<Tree>(initialCapacity);
    }

    @Override
    public void clear() {
        this.parseTrees.clear();
    }

    @Override
    public void loadPath(File path, FileFilter filt) {
        FilePathProcessor.processPath(path, filt, this);
    }

    public void loadPath(String path, FileFilter filt, String srlFile) {
        this.readSRLFile(srlFile);
        FilePathProcessor.processPath(new File(path), filt, this);
        this.srlMap = null;
    }

    private void readSRLFile(String srlFile) {
        this.srlMap = new HashMap<String, CollectionValuedMap<Integer, String>>();
        for (String line : ObjectBank.getLineIteratorObjectBank(srlFile)) {
            String[] bits = line.split("\\s+", 3);
            String filename = bits[0];
            int treeNum = Integer.parseInt(bits[1]);
            String info = bits[2];
            CollectionValuedMap<Integer, String> cvm = this.srlMap.get(filename);
            if (cvm == null) {
                cvm = new CollectionValuedMap();
                this.srlMap.put(filename, cvm);
            }
            cvm.add(treeNum, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processFile(File file) {
        TreeReader tr = null;
        CollectionValuedMap<Integer, String> srlMap = null;
        if (this.srlMap != null) {
            String filename = file.getAbsolutePath();
            for (String suffix : this.srlMap.keySet()) {
                if (!filename.endsWith(suffix)) continue;
                srlMap = this.srlMap.get(suffix);
                break;
            }
            if (srlMap == null) {
                System.err.println("could not find SRL entries for file: " + file);
            }
        }
        try {
            Tree pt;
            tr = this.treeReaderFactory().newTreeReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.encoding())));
            int sentIndex = 0;
            while ((pt = tr.readTree()) != null) {
                if (pt.label() instanceof HasIndex) {
                    HasIndex hi = (HasIndex)((Object)pt.label());
                    hi.setDocID(file.getName());
                    hi.setSentIndex(sentIndex);
                }
                if (srlMap == null) {
                    this.parseTrees.add(pt);
                } else {
                    Object srls = srlMap.get(sentIndex);
                    this.parseTrees.add(pt);
                    if (!srls.isEmpty()) {
                        Iterator i$ = srls.iterator();
                        while (i$.hasNext()) {
                            String srl = (String)i$.next();
                            String[] bits = srl.split("\\s+");
                            int verbIndex = Integer.parseInt(bits[0]);
                            String lemma = bits[2].split("\\.")[0];
                            Tree verb = Trees.getTerminal(pt, verbIndex);
                            ((CoreLabel)verb.label()).set(CoreAnnotations.CoNLLPredicateAnnotation.class, true);
                            for (int i = 4; i < bits.length; ++i) {
                                String arg = bits[i];
                                String[] bits1 = arg.indexOf("ARGM") >= 0 ? arg.split("-") : arg.split("-");
                                String locs = bits1[0];
                                String argType = bits1[1];
                                if (argType.equals("rel")) continue;
                                for (String loc : locs.split("[*,]")) {
                                    bits1 = loc.split(":");
                                    int term = Integer.parseInt(bits1[0]);
                                    int height = Integer.parseInt(bits1[1]);
                                    Tree t1 = Trees.getPreTerminal(pt, term);
                                    for (int j = 0; j < height; ++j) {
                                        t1 = t1.parent(pt);
                                    }
                                    HashMap<Integer, String> roleMap = (HashMap<Integer, String>)((CoreLabel)t1.label()).get(CoreAnnotations.CoNLLSRLAnnotation.class);
                                    if (roleMap == null) {
                                        roleMap = new HashMap<Integer, String>();
                                        ((CoreLabel)t1.label()).set(CoreAnnotations.CoNLLSRLAnnotation.class, roleMap);
                                    }
                                    roleMap.put(verbIndex, argType);
                                }
                            }
                        }
                    }
                }
                ++sentIndex;
            }
        }
        catch (IOException e) {
            System.err.println("loadTree IO Exception: " + e + " in file " + file);
        }
        finally {
            try {
                if (tr != null) {
                    tr.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public void load(Reader r) {
        this.load(r, null);
    }

    public void load(Reader r, String id) {
        try {
            Tree pt;
            TreeReader tr = this.treeReaderFactory().newTreeReader(r);
            int sentIndex = 0;
            while ((pt = tr.readTree()) != null) {
                if (pt.label() instanceof HasIndex) {
                    HasIndex hi = (HasIndex)((Object)pt.label());
                    if (id != null) {
                        hi.setDocID(id);
                    }
                    hi.setSentIndex(sentIndex);
                }
                this.parseTrees.add(pt);
                ++sentIndex;
            }
        }
        catch (IOException e) {
            System.err.println("load IO Exception: " + e);
        }
    }

    @Override
    public Tree get(int i) {
        return this.parseTrees.get(i);
    }

    @Override
    public void apply(TreeVisitor tp) {
        int size = this.parseTrees.size();
        for (int i = 0; i < size; ++i) {
            tp.visitTree(this.parseTrees.get(i));
        }
    }

    @Override
    public Iterator<Tree> iterator() {
        return this.parseTrees.iterator();
    }

    @Override
    public int size() {
        return this.parseTrees.size();
    }

    @Override
    public void add(int index, Tree element) {
        this.parseTrees.add(index, element);
    }

    @Override
    public boolean add(Tree element) {
        return this.parseTrees.add(element);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Tree> c) {
        return this.parseTrees.addAll(index, c);
    }

    @Override
    public int indexOf(Object o) {
        return this.parseTrees.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.parseTrees.lastIndexOf(o);
    }

    @Override
    public Tree remove(int index) {
        return this.parseTrees.remove(index);
    }

    @Override
    public Tree set(int index, Tree element) {
        return this.parseTrees.set(index, element);
    }

    @Override
    public ListIterator<Tree> listIterator() {
        return this.parseTrees.listIterator();
    }

    @Override
    public ListIterator<Tree> listIterator(int index) {
        return this.parseTrees.listIterator(index);
    }

    @Override
    public List<Tree> subList(int fromIndex, int toIndex) {
        return this.parseTrees.subList(fromIndex, toIndex);
    }

    @Override
    public Treebank transform(TreeTransformer treeTrans) {
        MemoryTreebank mtb = new MemoryTreebank(this.size(), this.treeReaderFactory());
        for (Tree t : this) {
            ((AbstractCollection)mtb).add(treeTrans.transformTree(t));
        }
        return mtb;
    }

    public static void main(String[] args) {
        Timing.startTime();
        MemoryTreebank treebank = new MemoryTreebank(new TreeReaderFactory(){

            public TreeReader newTreeReader(Reader in) {
                return new PennTreeReader(in, new LabeledScoredTreeFactory());
            }
        });
        treebank.loadPath(args[0]);
        Timing.endTime();
        System.out.println(treebank);
    }
}

