/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.fsm.TransducerGraph;
import edu.stanford.nlp.parser.lexparser.BinaryGrammar;
import edu.stanford.nlp.parser.lexparser.BinaryRule;
import edu.stanford.nlp.parser.lexparser.Rule;
import edu.stanford.nlp.parser.lexparser.Train;
import edu.stanford.nlp.parser.lexparser.UnaryGrammar;
import edu.stanford.nlp.parser.lexparser.UnaryRule;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Distribution;
import edu.stanford.nlp.util.Numberer;
import edu.stanford.nlp.util.Pair;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GrammarCompactor {
    Set<TransducerGraph> compactedGraphs;
    public static final Object RAW_COUNTS = new Object();
    public static final Object NORMALIZED_LOG_PROBABILITIES = new Object();
    public Object outputType = RAW_COUNTS;
    protected Numberer stateNumberer;
    protected Numberer newStateNumberer;
    protected String stateSpace;
    protected Distribution<String> inputPrior;
    private static Object END = "END";
    private static Object EPSILON = "EPSILON";
    protected boolean verbose = false;

    protected abstract TransducerGraph doCompaction(TransducerGraph var1, List<List<String>> var2, List<List<String>> var3);

    public Pair<UnaryGrammar, BinaryGrammar> compactGrammar(Pair<UnaryGrammar, BinaryGrammar> grammar) {
        return this.compactGrammar(grammar, new HashMap<String, List<List<String>>>(), new HashMap<String, List<List<String>>>());
    }

    public Pair<UnaryGrammar, BinaryGrammar> compactGrammar(Pair<UnaryGrammar, BinaryGrammar> grammar, Map<String, List<List<String>>> allTrainPaths, Map<String, List<List<String>>> allTestPaths) {
        this.inputPrior = this.computeInputPrior(allTrainPaths);
        BinaryGrammar bg = (BinaryGrammar)grammar.second;
        this.stateSpace = bg.stateSpace();
        this.stateNumberer = Numberer.getGlobalNumberer(this.stateSpace);
        HashSet<UnaryRule> unaryRules = new HashSet<UnaryRule>();
        HashSet<BinaryRule> binaryRules = new HashSet<BinaryRule>();
        Map<String, TransducerGraph> graphs = this.convertGrammarToGraphs(grammar, unaryRules, binaryRules);
        this.compactedGraphs = new HashSet<TransducerGraph>();
        if (this.verbose) {
            System.out.println("There are " + graphs.size() + " categories to compact.");
        }
        int i = 0;
        Iterator<Map.Entry<String, TransducerGraph>> graphIter = graphs.entrySet().iterator();
        while (graphIter.hasNext()) {
            List<List<String>> testPaths;
            List<List<String>> trainPaths;
            Map.Entry<String, TransducerGraph> entry = graphIter.next();
            String cat = entry.getKey();
            TransducerGraph graph = entry.getValue();
            if (this.verbose) {
                System.out.println("About to compact grammar for " + cat + " with numNodes=" + graph.getNodes().size());
            }
            if ((trainPaths = allTrainPaths.remove(cat)) == null) {
                trainPaths = new ArrayList<List<String>>();
            }
            if ((testPaths = allTestPaths.remove(cat)) == null) {
                testPaths = new ArrayList<List<String>>();
            }
            TransducerGraph compactedGraph = this.doCompaction(graph, trainPaths, testPaths);
            ++i;
            if (this.verbose) {
                System.out.println(i + ". Compacted grammar for " + cat + " from " + graph.getArcs().size() + " arcs to " + compactedGraph.getArcs().size() + " arcs.");
            }
            graphIter.remove();
            this.compactedGraphs.add(compactedGraph);
        }
        return this.convertGraphsToGrammar(this.compactedGraphs, unaryRules, binaryRules);
    }

    protected Distribution<String> computeInputPrior(Map<String, List<List<String>>> allTrainPaths) {
        ClassicCounter<String> result = new ClassicCounter<String>();
        for (List<List<String>> pathList : allTrainPaths.values()) {
            for (List<String> path : pathList) {
                for (String input : path) {
                    result.incrementCount(input);
                }
            }
        }
        return Distribution.laplaceSmoothedDistribution(result, result.size() * 2, 0.5);
    }

    private double smartNegate(double output) {
        if (this.outputType == NORMALIZED_LOG_PROBABILITIES) {
            return -output;
        }
        return output;
    }

    public static boolean writeFile(TransducerGraph graph, String dir, String name) {
        try {
            File baseDir = new File(dir);
            if (baseDir.exists() ? !baseDir.isDirectory() : !baseDir.mkdirs()) {
                return false;
            }
            File file = new File(baseDir, name + ".dot");
            try {
                PrintWriter w = new PrintWriter(new FileWriter(file));
                String dotString = graph.asDOTString();
                w.print(dotString);
                w.flush();
                w.close();
            }
            catch (FileNotFoundException e) {
                System.err.println("Failed to open file in writeToDOTfile: " + file);
                return false;
            }
            catch (IOException e) {
                System.err.println("Failed to open file in writeToDOTfile: " + file);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Map<String, TransducerGraph> convertGrammarToGraphs(Pair<UnaryGrammar, BinaryGrammar> grammar, Set<UnaryRule> unaryRules, Set<BinaryRule> binaryRules) {
        boolean wasAdded;
        int numRules = 0;
        UnaryGrammar ug = (UnaryGrammar)grammar.first;
        BinaryGrammar bg = (BinaryGrammar)grammar.second;
        HashMap<String, TransducerGraph> graphs = new HashMap<String, TransducerGraph>();
        for (Rule rule : bg) {
            ++numRules;
            wasAdded = this.addOneBinaryRule((BinaryRule)rule, (Map<String, TransducerGraph>)graphs);
            if (wasAdded) continue;
            binaryRules.add((BinaryRule)rule);
        }
        for (Rule rule : ug) {
            ++numRules;
            wasAdded = this.addOneUnaryRule((UnaryRule)rule, graphs);
            if (wasAdded) continue;
            unaryRules.add((UnaryRule)rule);
        }
        if (this.verbose) {
            System.out.println("Number of raw rules: " + numRules);
            System.out.println("Number of raw states: " + this.stateNumberer.total());
        }
        return graphs;
    }

    protected TransducerGraph getGraphFromMap(Map<String, TransducerGraph> m, String o) {
        TransducerGraph graph = m.get(o);
        if (graph == null) {
            graph = new TransducerGraph();
            graph.setEndNode(o);
            m.put(o, graph);
        }
        return graph;
    }

    protected String getTopCategoryOfSyntheticState(String s) {
        if (s.charAt(0) != '@') {
            return null;
        }
        int bar = s.indexOf(124);
        if (bar < 0) {
            throw new RuntimeException("Grammar format error. Expected bar in state name: " + s);
        }
        String topcat = s.substring(1, bar);
        return topcat;
    }

    protected boolean addOneUnaryRule(UnaryRule rule, Map<String, TransducerGraph> graphs) {
        String parentString = (String)this.stateNumberer.object(rule.parent);
        String childString = (String)this.stateNumberer.object(rule.child);
        if (this.isSyntheticState(parentString)) {
            String topcat = this.getTopCategoryOfSyntheticState(parentString);
            TransducerGraph graph = this.getGraphFromMap(graphs, topcat);
            Double output = new Double(this.smartNegate(rule.score()));
            graph.addArc(graph.getStartNode(), parentString, childString, output);
            return true;
        }
        if (this.isSyntheticState(childString)) {
            TransducerGraph graph = this.getGraphFromMap(graphs, parentString);
            Double output = new Double(this.smartNegate(rule.score()));
            graph.addArc(childString, parentString, END, output);
            graph.setEndNode(parentString);
            return true;
        }
        return false;
    }

    protected boolean addOneBinaryRule(BinaryRule rule, Map<String, TransducerGraph> graphs) {
        String input;
        String source;
        String parentString = (String)this.stateNumberer.object(rule.parent);
        String leftString = (String)this.stateNumberer.object(rule.leftChild);
        String rightString = (String)this.stateNumberer.object(rule.rightChild);
        String bracket = null;
        if (Train.markFinalStates) {
            bracket = parentString.substring(parentString.length() - 1, parentString.length());
        }
        if (this.isSyntheticState(leftString)) {
            source = leftString;
            input = rightString + (bracket == null ? ">" : bracket);
        } else if (this.isSyntheticState(rightString)) {
            source = rightString;
            input = leftString + (bracket == null ? "<" : bracket);
        } else {
            return false;
        }
        String target = parentString;
        Double output = new Double(this.smartNegate(rule.score()));
        String topcat = this.getTopCategoryOfSyntheticState(source);
        if (topcat == null) {
            throw new RuntimeException("can't have null topcat");
        }
        TransducerGraph graph = this.getGraphFromMap(graphs, topcat);
        graph.addArc(source, target, input, output);
        return true;
    }

    protected boolean isSyntheticState(String state) {
        return state.charAt(0) == '@';
    }

    /*
     * WARNING - void declaration
     */
    public Pair<UnaryGrammar, BinaryGrammar> convertGraphsToGrammar(Set<TransducerGraph> graphs, Set<UnaryRule> unaryRules, Set<BinaryRule> binaryRules) {
        void var7_23;
        Object parent;
        this.newStateNumberer = new Numberer();
        for (UnaryRule unaryRule : unaryRules) {
            parent = this.stateNumberer.object(unaryRule.parent);
            unaryRule.parent = this.newStateNumberer.number(parent);
            Object object = this.stateNumberer.object(unaryRule.child);
            unaryRule.child = this.newStateNumberer.number(object);
        }
        for (BinaryRule binaryRule : binaryRules) {
            parent = this.stateNumberer.object(binaryRule.parent);
            binaryRule.parent = this.newStateNumberer.number(parent);
            Object object = this.stateNumberer.object(binaryRule.leftChild);
            binaryRule.leftChild = this.newStateNumberer.number(object);
            Object rightChild = this.stateNumberer.object(binaryRule.rightChild);
            binaryRule.rightChild = this.newStateNumberer.number(rightChild);
        }
        Map<String, Numberer> numbs = Numberer.getNumberers();
        numbs.put(this.stateSpace, this.newStateNumberer);
        for (TransducerGraph graph : graphs) {
            Object object = graph.getStartNode();
            for (TransducerGraph.Arc arc : graph.getArcs()) {
                BinaryRule br;
                Object source = arc.getSourceNode();
                Object object2 = arc.getTargetNode();
                Object input = arc.getInput();
                String inputString = input.toString();
                double output = (Double)arc.getOutput();
                if (source.equals(object)) {
                    UnaryRule ur = new UnaryRule(this.newStateNumberer.number(object2), this.newStateNumberer.number(inputString), this.smartNegate(output));
                    unaryRules.add(ur);
                    continue;
                }
                if (inputString.equals(END) || inputString.equals(EPSILON)) {
                    UnaryRule ur = new UnaryRule(this.newStateNumberer.number(object2), this.newStateNumberer.number(source), this.smartNegate(output));
                    unaryRules.add(ur);
                    continue;
                }
                int length = inputString.length();
                char leftOrRight = inputString.charAt(length - 1);
                inputString = inputString.substring(0, length - 1);
                if (leftOrRight == '<' || leftOrRight == '[') {
                    br = new BinaryRule(this.newStateNumberer.number(object2), this.newStateNumberer.number(inputString), this.newStateNumberer.number(source), this.smartNegate(output));
                } else if (leftOrRight == '>' || leftOrRight == ']') {
                    br = new BinaryRule(this.newStateNumberer.number(object2), this.newStateNumberer.number(source), this.newStateNumberer.number(inputString), this.smartNegate(output));
                } else {
                    throw new RuntimeException("Arc input is in unexpected format: " + arc);
                }
                binaryRules.add(br);
            }
        }
        ClassicCounter<String> classicCounter = new ClassicCounter<String>();
        if (this.outputType == RAW_COUNTS) {
            for (UnaryRule unaryRule : unaryRules) {
                classicCounter.incrementCount((String)this.newStateNumberer.object(unaryRule.parent), unaryRule.score);
            }
            for (BinaryRule binaryRule : binaryRules) {
                classicCounter.incrementCount((String)this.newStateNumberer.object(binaryRule.parent), binaryRule.score);
            }
        }
        int numStates = this.newStateNumberer.total();
        boolean bl = false;
        UnaryGrammar ug = new UnaryGrammar(numStates);
        BinaryGrammar bg = new BinaryGrammar(numStates);
        for (UnaryRule unaryRule : unaryRules) {
            void var7_22;
            if (this.outputType == RAW_COUNTS) {
                double count = classicCounter.getCount((String)this.newStateNumberer.object(unaryRule.parent));
                unaryRule.score = (float)Math.log((double)unaryRule.score / count);
            }
            ug.addRule(unaryRule);
            ++var7_22;
        }
        for (BinaryRule binaryRule : binaryRules) {
            if (this.outputType == RAW_COUNTS) {
                double count = classicCounter.getCount((String)this.newStateNumberer.object(binaryRule.parent));
                binaryRule.score = (float)Math.log(((double)binaryRule.score - Train.ruleDiscount) / count);
            }
            bg.addRule(binaryRule);
            ++var7_23;
        }
        if (this.verbose) {
            System.out.println("Number of minimized rules: " + (int)var7_23);
            System.out.println("Number of minimized states: " + this.newStateNumberer.total());
        }
        ug.purgeRules();
        bg.splitRules();
        return new Pair<UnaryGrammar, BinaryGrammar>(ug, bg);
    }
}

