/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.util.CoreMap;
import java.util.Comparator;
import java.util.TreeMap;

public class CyclicCoreLabel
extends CoreLabel {
    private static final long serialVersionUID = 1L;
    private static String printOptions = "value-index";
    private static final Comparator<Class<?>> asClassComparator = new Comparator<Class<?>>(){

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    public CyclicCoreLabel() {
    }

    public CyclicCoreLabel(Label label) {
        super(label);
    }

    public CyclicCoreLabel(CoreMap label) {
        super(label);
    }

    public CyclicCoreLabel(CoreLabel label) {
        super(label);
    }

    public CyclicCoreLabel(CyclicCoreLabel label) {
        this((CoreMap)label);
    }

    public boolean equals(Object obj) {
        return this.cyclicEquals(obj);
    }

    public int hashCode() {
        return this.cyclicHashCode();
    }

    public String toString() {
        return this.toString(printOptions);
    }

    public String toString(String format) {
        StringBuilder buf = new StringBuilder();
        if (format.equals("value")) {
            buf.append(this.value());
        } else if (format.equals("{map}")) {
            TreeMap map2 = new TreeMap(asClassComparator);
            for (Class<?> key : this.keySet()) {
                map2.put(key, this.get(key));
            }
            buf.append(map2);
        } else if (format.equals("value{map}")) {
            buf.append(this.value());
            TreeMap map2 = new TreeMap(asClassComparator);
            for (Class<?> key : this.keySet()) {
                map2.put(key, this.get(key));
            }
            map2.remove(CoreAnnotations.ValueAnnotation.class);
            buf.append(map2);
        } else if (format.equals("value-index")) {
            buf.append(this.value());
            Integer index = (Integer)this.get(CoreAnnotations.IndexAnnotation.class);
            if (index != null) {
                buf.append("-").append(index);
            }
        } else if (format.equals("value-index{map}")) {
            buf.append(this.value());
            Integer index = (Integer)this.get(CoreAnnotations.IndexAnnotation.class);
            if (index != null) {
                buf.append("-").append(index);
            }
            TreeMap map2 = new TreeMap(asClassComparator);
            for (Class<?> key : this.keySet()) {
                map2.put(key, this.get(key));
            }
            map2.remove(CoreAnnotations.IndexAnnotation.class);
            map2.remove(CoreAnnotations.ValueAnnotation.class);
            if (!map2.isEmpty()) {
                buf.append(map2);
            }
        } else if (format.equals("word")) {
            buf.append(this.word());
        }
        return buf.toString();
    }

    public static LabelFactory factory() {
        return new LabelFactory(){

            public Label newLabel(String labelStr) {
                CyclicCoreLabel label = new CyclicCoreLabel();
                label.setValue(labelStr);
                return label;
            }

            public Label newLabel(String labelStr, int options) {
                return this.newLabel(labelStr);
            }

            public Label newLabel(Label oldLabel) {
                return new CyclicCoreLabel(oldLabel);
            }

            public Label newLabelFromString(String encodedLabelStr) {
                throw new UnsupportedOperationException("This code branch left blank because we do not understand what this method should do.");
            }
        };
    }

    public LabelFactory labelFactory() {
        return CyclicCoreLabel.factory();
    }

    public String cyclicToString() {
        return this.toString();
    }

    public int cyclicHashCode() {
        int keyscode = 0;
        int valuescode = 0;
        for (Class<?> key : this.keySet()) {
            keyscode += key.hashCode();
            valuescode += this.get(key) != null ? System.identityHashCode(this.get(key)) : 0;
        }
        return keyscode * 37 + valuescode;
    }

    public boolean cyclicEquals(Object obj) {
        if (!(obj instanceof CoreLabel)) {
            return false;
        }
        CoreLabel other = (CoreLabel)obj;
        if (!((Object)this.keySet()).equals(other.keySet())) {
            return false;
        }
        for (Class<?> key : this.keySet()) {
            if (this.get(key) == other.get(key)) continue;
            return false;
        }
        return true;
    }
}

