/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class IOUtils {
    private IOUtils() {
    }

    public static File writeObjectToFile(Object o, String filename) throws IOException {
        return IOUtils.writeObjectToFile(o, new File(filename));
    }

    public static File writeObjectToFile(Object o, File file) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(file))));
        oos.writeObject(o);
        oos.close();
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeObjectToFileNoExceptions(Object o, String filename) {
        File file = null;
        ObjectOutputStream oos = null;
        try {
            file = new File(filename);
            oos = new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(file))));
            oos.writeObject(o);
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (Exception ioe) {}
            }
        }
        return file;
    }

    public static File writeObjectToTempFile(Object o, String filename) throws IOException {
        File file = File.createTempFile(filename, ".tmp");
        file.deleteOnExit();
        ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(file))));
        oos.writeObject(o);
        oos.close();
        return file;
    }

    public static File writeObjectToTempFileNoExceptions(Object o, String filename) {
        try {
            return IOUtils.writeObjectToTempFile(o, filename);
        }
        catch (Exception e) {
            System.err.println("Error writing object to file " + filename);
            e.printStackTrace();
            return null;
        }
    }

    public static Object readObjectFromFile(File file) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(file))));
        Object o = ois.readObject();
        ois.close();
        return o;
    }

    public static Object readObjectFromFile(String filename) throws IOException, ClassNotFoundException {
        return IOUtils.readObjectFromFile(new File(filename));
    }

    public static Object readObjectFromFileNoExceptions(File file) {
        Object o = null;
        try {
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(file))));
            o = ois.readObject();
            ois.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return o;
    }

    public static int lineCount(File textFile) throws IOException {
        BufferedReader r = new BufferedReader(new FileReader(textFile));
        int numLines = 0;
        while (r.readLine() != null) {
            ++numLines;
        }
        return numLines;
    }

    public static ObjectOutputStream writeStreamFromString(String serializePath) throws IOException {
        ObjectOutputStream oos = serializePath.endsWith(".gz") ? new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(serializePath)))) : new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(serializePath)));
        return oos;
    }

    public static ObjectInputStream readStreamFromString(String filenameOrUrl) throws IOException {
        InputStream is;
        if (filenameOrUrl.matches("https?://")) {
            URL u = new URL(filenameOrUrl);
            URLConnection uc = u.openConnection();
            is = uc.getInputStream();
        } else {
            is = new FileInputStream(filenameOrUrl);
        }
        ObjectInputStream in = filenameOrUrl.endsWith(".gz") ? new ObjectInputStream(new GZIPInputStream(new BufferedInputStream(is))) : new ObjectInputStream(new BufferedInputStream(is));
        return in;
    }

    public static BufferedReader readReaderFromString(String textFileOrUrl) throws IOException {
        InputStream is;
        if (textFileOrUrl.matches("https?://.*")) {
            URL u = new URL(textFileOrUrl);
            URLConnection uc = u.openConnection();
            is = uc.getInputStream();
        } else {
            is = new FileInputStream(textFileOrUrl);
        }
        BufferedReader in = textFileOrUrl.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(is))) : new BufferedReader(new InputStreamReader(is));
        return in;
    }

    public static BufferedReader readReaderFromString(String textFileOrUrl, String encoding) throws IOException {
        InputStream is;
        if (textFileOrUrl.matches("https?://")) {
            URL u = new URL(textFileOrUrl);
            URLConnection uc = u.openConnection();
            is = uc.getInputStream();
        } else {
            is = new FileInputStream(textFileOrUrl);
        }
        if (textFileOrUrl.endsWith(".gz")) {
            is = new GZIPInputStream(is);
        }
        return new BufferedReader(new InputStreamReader(is, encoding));
    }
}

