/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.python.core.Py;
import org.python.core.PyClass;
import org.python.core.PyComplex;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyTuple;

public class PyLong
extends PyObject {
    private static final BigInteger minLong = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger maxLong = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger minDouble = new BigDecimal(Double.MIN_VALUE).toBigInteger();
    private static final BigInteger maxDouble = new BigDecimal(Double.MAX_VALUE).toBigInteger();
    public static PyClass __class__;
    private BigInteger value;
    private static /* synthetic */ Class class$Ljava$lang$Byte;
    private static /* synthetic */ Class class$Ljava$lang$Short;
    private static /* synthetic */ Class class$Ljava$lang$Integer;
    private static /* synthetic */ Class class$Ljava$lang$Long;
    private static /* synthetic */ Class class$Ljava$lang$Float;
    private static /* synthetic */ Class class$Ljava$lang$Double;
    private static /* synthetic */ Class class$Ljava$math$BigInteger;
    private static /* synthetic */ Class class$Ljava$lang$Number;
    private static /* synthetic */ Class class$Ljava$lang$Object;
    private static /* synthetic */ Class class$Ljava$io$Serializable;

    public String toString() {
        return this.value.toString() + "L";
    }

    public int hashCode() {
        return this.value.intValue();
    }

    public boolean __nonzero__() {
        return !this.value.equals(BigInteger.valueOf(0L));
    }

    public double doubleValue() {
        double v = this.value.doubleValue();
        if (v == Double.NEGATIVE_INFINITY || v == Double.POSITIVE_INFINITY) {
            throw Py.OverflowError("long int too long to convert");
        }
        return v;
    }

    private final long getLong(long min, long max) {
        long v;
        if (this.value.compareTo(maxLong) <= 0 && this.value.compareTo(minLong) >= 0 && (v = this.value.longValue()) >= min && v <= max) {
            return v;
        }
        throw Py.OverflowError("long int too long to convert");
    }

    public Object __tojava__(Class c) {
        try {
            if (c == Byte.TYPE || c == (class$Ljava$lang$Byte != null ? class$Ljava$lang$Byte : (class$Ljava$lang$Byte = PyLong.class$("java.lang.Byte")))) {
                return new Byte((byte)this.getLong(-128L, 127L));
            }
            if (c == Short.TYPE || c == (class$Ljava$lang$Short != null ? class$Ljava$lang$Short : (class$Ljava$lang$Short = PyLong.class$("java.lang.Short")))) {
                return new Short((short)this.getLong(-32768L, 32767L));
            }
            if (c == Integer.TYPE || c == (class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = PyLong.class$("java.lang.Integer")))) {
                return new Integer((int)this.getLong(Integer.MIN_VALUE, Integer.MAX_VALUE));
            }
            if (c == Long.TYPE || c == (class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = PyLong.class$("java.lang.Long")))) {
                return new Long(this.getLong(Long.MIN_VALUE, Long.MAX_VALUE));
            }
            if (c == Float.TYPE || c == Double.TYPE || c == (class$Ljava$lang$Float != null ? class$Ljava$lang$Float : (class$Ljava$lang$Float = PyLong.class$("java.lang.Float"))) || c == (class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = PyLong.class$("java.lang.Double")))) {
                return this.__float__().__tojava__(c);
            }
            if (c == (class$Ljava$math$BigInteger != null ? class$Ljava$math$BigInteger : (class$Ljava$math$BigInteger = PyLong.class$("java.math.BigInteger"))) || c == (class$Ljava$lang$Number != null ? class$Ljava$lang$Number : (class$Ljava$lang$Number = PyLong.class$("java.lang.Number"))) || c == (class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = PyLong.class$("java.lang.Object"))) || c == (class$Ljava$io$Serializable != null ? class$Ljava$io$Serializable : (class$Ljava$io$Serializable = PyLong.class$("java.io.Serializable")))) {
                return this.value;
            }
        }
        catch (PyException e) {
            return Py.NoConversion;
        }
        return super.__tojava__(c);
    }

    public int __cmp__(PyObject other) {
        return this.value.compareTo(((PyLong)other).value);
    }

    public Object __coerce_ex__(PyObject other) {
        if (other instanceof PyLong) {
            return other;
        }
        if (other instanceof PyInteger) {
            return new PyLong(((PyInteger)other).getValue());
        }
        return Py.None;
    }

    private static final boolean canCoerce(PyObject other) {
        return other instanceof PyLong || other instanceof PyInteger;
    }

    private static final BigInteger coerce(PyObject other) {
        if (other instanceof PyLong) {
            return ((PyLong)other).value;
        }
        if (other instanceof PyInteger) {
            return BigInteger.valueOf(((PyInteger)other).getValue());
        }
        throw Py.TypeError("xxx");
    }

    public PyObject __add__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return new PyLong(this.value.add(PyLong.coerce(right)));
    }

    public PyObject __radd__(PyObject left) {
        return this.__add__(left);
    }

    public PyObject __sub__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return new PyLong(this.value.subtract(PyLong.coerce(right)));
    }

    public PyObject __rsub__(PyObject left) {
        return new PyLong(PyLong.coerce(left).subtract(this.value));
    }

    public PyObject __mul__(PyObject right) {
        if (right instanceof PySequence) {
            return ((PySequence)right).repeat(PyLong.coerceInt(this));
        }
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return new PyLong(this.value.multiply(PyLong.coerce(right)));
    }

    public PyObject __rmul__(PyObject left) {
        if (left instanceof PySequence) {
            return ((PySequence)left).repeat(PyLong.coerceInt(this));
        }
        if (!PyLong.canCoerce(left)) {
            return null;
        }
        return new PyLong(PyLong.coerce(left).multiply(this.value));
    }

    private final BigInteger divide(BigInteger x, BigInteger y) {
        BigInteger zero = BigInteger.valueOf(0L);
        if (y.equals(zero)) {
            throw Py.ZeroDivisionError("long division or modulo");
        }
        if (y.compareTo(zero) < 0) {
            if (x.compareTo(zero) > 0) {
                return x.subtract(y).subtract(BigInteger.valueOf(1L)).divide(y);
            }
        } else if (x.compareTo(zero) < 0) {
            return x.subtract(y).add(BigInteger.valueOf(1L)).divide(y);
        }
        return x.divide(y);
    }

    public PyObject __div__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return new PyLong(this.divide(this.value, PyLong.coerce(right)));
    }

    public PyObject __rdiv__(PyObject left) {
        if (!PyLong.canCoerce(left)) {
            return null;
        }
        return new PyLong(this.divide(PyLong.coerce(left), this.value));
    }

    private final BigInteger modulo(BigInteger x, BigInteger y, BigInteger xdivy) {
        return x.subtract(xdivy.multiply(y));
    }

    public PyObject __mod__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        BigInteger rightv = PyLong.coerce(right);
        return new PyLong(this.modulo(this.value, rightv, this.divide(this.value, rightv)));
    }

    public PyObject __rmod__(PyObject left) {
        if (!PyLong.canCoerce(left)) {
            return null;
        }
        BigInteger leftv = PyLong.coerce(left);
        return new PyLong(this.modulo(leftv, this.value, this.divide(leftv, this.value)));
    }

    public PyObject __divmod__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        BigInteger rightv = PyLong.coerce(right);
        BigInteger xdivy = this.divide(this.value, rightv);
        return new PyTuple(new PyObject[]{new PyLong(xdivy), new PyLong(this.modulo(this.value, rightv, xdivy))});
    }

    public PyObject __rdivmod__(PyObject left) {
        if (!PyLong.canCoerce(left)) {
            return null;
        }
        BigInteger leftv = PyLong.coerce(left);
        BigInteger xdivy = this.divide(leftv, this.value);
        return new PyTuple(new PyObject[]{new PyLong(xdivy), new PyLong(this.modulo(leftv, this.value, xdivy))});
    }

    public PyObject __pow__(PyObject right, PyObject modulo) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        if (modulo != null && !PyLong.canCoerce(right)) {
            return null;
        }
        return PyLong._pow(this.value, PyLong.coerce(right), modulo);
    }

    public PyObject __rpow__(PyObject left) {
        if (!PyLong.canCoerce(left)) {
            return null;
        }
        return PyLong._pow(PyLong.coerce(left), this.value, null);
    }

    public static PyLong _pow(BigInteger value, BigInteger y, PyObject modulo) {
        if (y.compareTo(BigInteger.valueOf(0L)) < 0) {
            if (value.compareTo(BigInteger.valueOf(0L)) != 0) {
                throw Py.ValueError("long integer to a negative power");
            }
            throw Py.ZeroDivisionError("zero to a negative power");
        }
        if (modulo == null) {
            return new PyLong(value.pow(y.intValue()));
        }
        BigInteger z = PyLong.coerce(modulo);
        int zi = z.intValue();
        if (zi == 0) {
            throw Py.ValueError("pow(x, y, z) with z == 0");
        }
        if (zi == 1 || zi == -1) {
            return new PyLong(0L);
        }
        if (z.compareTo(BigInteger.valueOf(0L)) <= 0) {
            if ((y = value.modPow(y, z.negate())).compareTo(BigInteger.valueOf(0L)) > 0) {
                return new PyLong(z.add(y));
            }
            return new PyLong(y);
        }
        return new PyLong(value.modPow(y, z));
    }

    private static final int coerceInt(PyObject other) {
        if (other instanceof PyLong) {
            return (int)((PyLong)other).getLong(Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
        if (other instanceof PyInteger) {
            return ((PyInteger)other).getValue();
        }
        throw Py.TypeError("xxx");
    }

    public PyObject __lshift__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return new PyLong(this.value.shiftLeft(PyLong.coerceInt(right)));
    }

    public PyObject __rshift__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return new PyLong(this.value.shiftRight(PyLong.coerceInt(right)));
    }

    public PyObject __and__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return new PyLong(this.value.and(PyLong.coerce(right)));
    }

    public PyObject __xor__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return new PyLong(this.value.xor(PyLong.coerce(right)));
    }

    public PyObject __or__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return new PyLong(this.value.or(PyLong.coerce(right)));
    }

    public PyObject __neg__() {
        return new PyLong(this.value.negate());
    }

    public PyObject __pos__() {
        return this;
    }

    public PyObject __abs__() {
        return new PyLong(this.value.abs());
    }

    public PyObject __invert__() {
        return new PyLong(this.value.not());
    }

    public PyInteger __int__() {
        return new PyInteger((int)this.getLong(Integer.MIN_VALUE, Integer.MAX_VALUE));
    }

    public PyLong __long__() {
        return this;
    }

    public PyFloat __float__() {
        return new PyFloat(this.doubleValue());
    }

    public PyComplex __complex__() {
        return new PyComplex(this.doubleValue(), 0.0);
    }

    public PyString __oct__() {
        String s = this.value.toString(8);
        if (s.startsWith("-")) {
            return new PyString("-0" + s.substring(1, s.length()) + "L");
        }
        if (s.startsWith("0")) {
            return new PyString(s + "L");
        }
        return new PyString("0" + s + "L");
    }

    public PyString __hex__() {
        String s = this.value.toString(16).toUpperCase();
        if (s.startsWith("-")) {
            return new PyString("-0x" + s.substring(1, s.length()) + "L");
        }
        return new PyString("0x" + s + "L");
    }

    public PyString __str__() {
        return Py.newString(this.value.toString());
    }

    public boolean isMappingType() {
        return false;
    }

    public boolean isSequenceType() {
        return false;
    }

    protected PyClass getPyClass() {
        return __class__;
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PyLong(BigInteger v) {
        this.value = v;
    }

    public PyLong(double v) {
        this(new BigDecimal(v).toBigInteger());
    }

    public PyLong(long v) {
        this(BigInteger.valueOf(v));
    }

    public PyLong(String s) {
        this(new BigInteger(s));
    }
}

