/*
 * Decompiled with CFR 0.152.
 */
package montylingua;

import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyFunction;
import org.python.core.PyFunctionTable;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyRunnable;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.imp;

public class MontyLingua {
    static String[] jpy$mainProperties = new String[]{"python.modules.builtin", "exceptions:org.python.core.exceptions"};
    static String[] jpy$proxyProperties = new String[]{"python.modules.builtin", "exceptions:org.python.core.exceptions", "python.options.showJavaExceptions", "true"};
    static String[] jpy$packages = new String[]{"org.python.core", null, "java.util.zip", null, "java.lang", null, "java.io", null};
    static /* synthetic */ Class class$montylingua$MontyLingua$_PyInner;

    public static void moduleDictInit(PyObject pyObject) {
        pyObject.__setitem__("__name__", (PyObject)new PyString("MontyLingua"));
        Py.runCode(new _PyInner().getMain(), pyObject, pyObject);
    }

    public static void main(String[] stringArray) throws Exception {
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = "MontyLingua";
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        Py.runMain(class$montylingua$MontyLingua$_PyInner == null ? (class$montylingua$MontyLingua$_PyInner = MontyLingua.class$("montylingua.MontyLingua$_PyInner")) : class$montylingua$MontyLingua$_PyInner, stringArray2, jpy$packages, jpy$mainProperties, "montylingua", new String[]{"string", "random", "MontyContextualRuleParser", "MontyCommonsense", "sre_compile", "MontyLexiconFast", "sre", "sre_constants", "MontySettings", "MontyUtils", "javaos", "MontyNLGenerator", "__future__", "repr", "MontyLingua", "zlib", "MontyLexicalRuleParser", "copy_reg", "MontyTokenizer", "re", "javapath", "UserDict", "MontyExtractor", "copy", "MontyLexiconCustom", "MontyTagger", "MontyLemmatiser", "MontyREChunker", "sre_parse", "JMontyLingua"});
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class _PyInner
    extends PyFunctionTable
    implements PyRunnable {
        private static PyObject s$0;
        private static PyObject s$1;
        private static PyObject s$2;
        private static PyObject s$3;
        private static PyObject s$4;
        private static PyObject s$5;
        private static PyObject s$6;
        private static PyObject i$7;
        private static PyObject s$8;
        private static PyObject s$9;
        private static PyObject s$10;
        private static PyObject s$11;
        private static PyObject s$12;
        private static PyObject i$13;
        private static PyObject s$14;
        private static PyObject s$15;
        private static PyObject s$16;
        private static PyObject s$17;
        private static PyObject s$18;
        private static PyObject s$19;
        private static PyObject i$20;
        private static PyObject s$21;
        private static PyObject s$22;
        private static PyObject s$23;
        private static PyObject s$24;
        private static PyObject s$25;
        private static PyObject s$26;
        private static PyObject s$27;
        private static PyObject s$28;
        private static PyObject s$29;
        private static PyObject s$30;
        private static PyObject s$31;
        private static PyObject s$32;
        private static PyObject s$33;
        private static PyObject s$34;
        private static PyObject s$35;
        private static PyObject s$36;
        private static PyObject s$37;
        private static PyObject s$38;
        private static PyObject s$39;
        private static PyObject s$40;
        private static PyObject s$41;
        private static PyObject i$42;
        private static PyObject s$43;
        private static PyObject s$44;
        private static PyObject s$45;
        private static PyFunctionTable funcTable;
        private static PyCode c$0___init__;
        private static PyCode c$1_generate_summary;
        private static PyCode c$2_generate_sentence;
        private static PyCode c$3_jist_predicates;
        private static PyCode c$4_jist;
        private static PyCode c$5_pp_info;
        private static PyCode c$6_split_paragraphs;
        private static PyCode c$7_split_sentences;
        private static PyCode c$8_tokenize;
        private static PyCode c$9_tag_tokenized;
        private static PyCode c$10_lambda;
        private static PyCode c$11_lambda;
        private static PyCode c$12_strip_tags;
        private static PyCode c$13_parse_pred_arg;
        private static PyCode c$14_chunk_tagged;
        private static PyCode c$15_chunk_lemmatised;
        private static PyCode c$16_lemmatise_tagged;
        private static PyCode c$17_extract_info;
        private static PyCode c$18_MontyLingua;
        private static PyCode c$19_lambda;
        private static PyCode c$20_lambda;
        private static PyCode c$21_lambda;
        private static PyCode c$22_main;

        private static void initConstants() {
            s$0 = Py.newString("\n Module MontyLingua\n MONTY LINGUA - An end-to-end natural language processor\n                for English, for the Python/Java platform\n \n Author: Hugo Liu <hugo@media.mit.edu>\n Project Page: <http://web.media.mit.edu/~hugo/montylingua>\n \n Copyright (c) 2002-2004 by Hugo Liu, MIT Media Lab\n  All rights reserved.\n\n Non-commercial use is free, as provided in the GNU GPL\n By downloading and using MontyLingua, you agree to abide\n by the additional copyright and licensing information in\n  \"license.txt\", included in this distribution\n \n If you use this software in your research, please \n acknowledge MontyLingua and its author, and link to back\n to the project page http://web.media.mit.edu/~hugo/montylingua.\n Please cite montylingua in academic publications as: \n \n Liu, Hugo (2004). MontyLingua: An end-to-end natural \n language processor with common sense. Available \n at: web.media.mit.edu/~hugo/montylingua.\n\n ************************************************\n DOCUMENTATION OVERVIEW\n\n   About MontyLingua:\n   - MontyTokenizer\n     - normalizes punctuation, spacing and\n       contractions, with sensitivity to abbrevs.\n   - MontyTagger\n     - Part-of-speech tagging using PENN TREEBANK tagset\n     - enriched with \"Common Sense\" from the Open Mind\n       Common Sense project\n     - exceeds accuracy of Brill94 tbl tagger\n       using default training files\n   - MontyREChunker\n     - chunks tagged text into verb, noun, and adjective\n       chunks (VX,NX, and AX respectively)\n     - incredible speed and accuracy improvement over\n       previous MontyChunker\n   - MontyExtractor\n     - extracts verb-argument structures, phrases, and\n       other semantically valuable information\n       from sentences and returns sentences as \"digests\"\n   - MontyLemmatiser\n     - part-of-speech sensitive lemmatisation\n     - strips plurals (geese-->goose) and\n       tense (were-->be, had-->have)\n     - includes regexps from Humphreys and Carroll's\n       morph.lex, and UPENN's XTAG corpus\n   - MontyNLGenerator\n     - generates summaries\n     - generates surface form sentences\n     - determines and numbers NPs and tenses verbs\n     - accounts for sentence_type\n\n  WHERE MUST THE DATAFILES BE?\n  - the \"datafiles\" include all files ending in *.MDF\n  - the best solution is to create an environment variable called\n    \"MONTYLINGUA\" and put the path to the datafiles there\n  - alternatively, MontyLingua can find the datafiles if they are \n    in the operating system \"PATH\" variable, or in the current\n    working directory\n    \n   API:\n     The MontyLingua Python API is MontyLingua.html\n     The MontyLingua Java API is JMontyLingua.html\n\n   RUNNING:\n     MontyLingua can be called from Python, Java,\n     or run at the command line.\n     \n     A. From Python, import the MontyLingua.py file\n     B. From your Java code:\n       1. make sure \"montylingua.jar\" is\n         in your class path, in addition to\n         associated subdirectories and data files\n       2. in your code, you need something like:\n\n       import montylingua.JMontyLingua; // loads namespace\n       public class YourClassHere {\n         public static JMontyLingua j = new JMontyLingua();\n         public yourFunction(String raw, String toked) {\n            jisted = j.jist_predicates(raw); // an example function\n\n       3. For a good use case example, see Sample.java.\n     C. From the command line:\n       1. if you have python installed and in your path:\n          type \"run.bat\"\n       2. if you have java installed and in your path:\n          type \"runJavaCommandline.bat\"\n \n  VERSION HISTORY:\n\n   New in version 2.1 (6 Aug 2004)\n     - new MontyNLGenerator component (in Beta phase)\n     - includes version 2.0.1 bugfix for problem\n       where java api wasn't being exposed\n       \n   New in version 2.0 (29 Jul 2004)\n     - 2.5X speed enhancement for whole system\n       2X speed enhancement for tagger component\n     - rule-based chunker replaced with much faster\n       and more accurate regular expression chunker\n     - common sense added to MontyTagger component\n       improves word-level tagger accuracy to 97%\n     - updated and expanded lexicon for English\n     - added a user-customizable lexicon\n       CUSTOMLEXICON.MDF\n     - improvements to MontyLemmatiser incorporating\n       exception cases\n     - html documentation added\n     - speed optimizations to all code\n     - improvements made to semantic extraction\n     - added a morphological analyzer component,\n       MontyMorph\n     - expanded Java API\n     \n   New in version 1.3.1 (11 Nov 2003)\n     - mainly bugfixes\n     - datafiles can now sit in the current working directory (\".\")\n       or in the path of either of the two environment variables \n       \"MONTYLINGUA\" or \"PATH\" \n     - presence of the '/' token in input won't crash system\n \n   New in Version 1.3 (5 Nov 2003)\n     - lisp-style predicate output added\n     - Sample.java example file added to illustrate API\n   \n   New in Version 1.2 (12 Sep 2003)\n     - MontyChunker rules expanded\n     - MontyLingua JAVA API added\n     - MontyLingua documentation added\n\n   New in Version 1.1 (1 Sep 2003)\n     - MontyTagger optimized, 2X loading and 2.5X tagging speed\n     - MontyLemmatiser added to MontyLingua suite\n     - MontyChunker added\n     - MontyLingua command-line capability added\n\n   New in Version 1.0 (3 Aug 2003)\n     - First release\n     - MontyTagger (since 15 Jan 2001) added to MontyLingua\n\n --please send bugs & suggestions to hugo@media.mit.edu--\n\n");
            s$1 = Py.newString("Hugo Liu <hugo@media.mit.edu>");
            s$2 = Py.newString("2.1");
            s$3 = Py.newString("\n****** MontyLingua v.");
            s$4 = Py.newString(" ******");
            s$5 = Py.newString("***** by hugo@media.mit.edu *****");
            s$6 = Py.newString("*********************************\n");
            i$7 = Py.newInteger(0);
            s$8 = Py.newString("\n        uses MontyNLGenerator to generate a paragraph text summary\n        in the past tense\n        inputs a flat list of verb-subject-object-object tuples\n      ");
            s$9 = Py.newString("\n        inputs verb-subject-object-object tuple\n        outputs a generated sentence\n        \n        valid sentence types: declarative, imperative, (can|may|would|should|could), (who|what|when|where|why|how), question\n        valid tenses: past, present, progressive, past_progressive, future, infinitive\n        dtnum is a pair of determiner, number e.g. ('the',1),('some',2)\n        valid determiners = 'a','the','some','',etc\n        valid numbers = 1,2,3\n      ");
            s$10 = Py.newString("declaration");
            s$11 = Py.newString("past");
            s$12 = Py.newString("");
            i$13 = Py.newInteger(1);
            s$14 = Py.newString("\n        similar to jist() except output is simpler\n        returns a list (document-level)\n        of lists (sentence-level) of \n        lisp-style predicate argument structures\n        - each structure should look something like this:\n           - (\"verb\" \"subject\" \"obj1\" \"obj2\" ... )\n        - words are all lemmatised, and determiners and\n          modals are stripped out\n        - obj's can be direct or indirect, but not\n          subordinate clauses for now.\n\t");
            s$15 = Py.newString("verb_arg_structures_concise");
            s$16 = Py.newString("\n\tinputs raw text, outputs a list of \n\tdictionaries with information digests of \n\teach sentence\n\t");
            s$17 = Py.newString("pretty prints sentence information digests returned by jist()");
            s$18 = Py.newString("\n\n   SENTENCE #%s DIGEST:\n");
            s$19 = Py.newString(": ");
            i$20 = Py.newInteger(22);
            s$21 = Py.newString("inputs a raw text and outputs a list of paragraph segments");
            s$22 = Py.newString("input a raw text and outputs a list of sentence segments");
            s$23 = Py.newString("\n\tinputs a raw text sentence and outputs that sentence \n\twith punctuation tokenized, except in the case of abbreviations\n    \tiff expand_contractions_p == 1, then contractions will be\n    \tresolved (e.g. \"can't\"-->\"can not\")\n    \t");
            s$24 = Py.newString("\n\ttakes tokenized text and returns Penn Treebank tagset tagged text:\n\ti.e.:  \"This/DT is/VB a/DT sentence/NN\". \n\tmore information on the tagset can be found at:\n\thttp://www.cis.upenn.edu/~treebank/\n\t");
            s$25 = Py.newString("\n    \tstrips part-of-speech and chunk tags from text\n    \tand returns plaintext\n    \t");
            s$26 = Py.newString("/");
            s$27 = Py.newString(" ");
            s$28 = Py.newString("\n        parses the predicate-argument string\n        returned by jist_predicates(), of the form:\n        '(\"pred name\" \"arg 1\" \"arg 2\" etc)'\n        and returns them as a list\n        ");
            s$29 = Py.newString("\" \"");
            s$30 = Py.newString("\n\tchunks tagged text and outputs the form:\n    \t\"(NX He/PRP NX) (VX is/VB VX) (NX the/DT mailman/NN NX)\"    \t\n        ");
            s$31 = Py.newString(" \n        inputs lemmatised text of the form:\n        \"He/PRP/he ran/VBD/run\"\n        and outputs the form:\n        \"(NX He/PRP/he NX) (VX is/VB/be VX) (NX the/DT/the mailman/NN/mailman NX)\"    \t\n       \t");
            s$32 = Py.newString("\n\tlemmatises tagged text and outputs the form:\n    \t'These/DT/These sentences/NNS/sentence were/VBZ/be false/JJ/false'\n    \t(lemma follows the pos tag)\n    \t");
            s$33 = Py.newString("\n    \textracts many useful things from chunked_text\n    \toutputted in a dictionary, which can be printed using pp_info()\n    \tits keys and sample values:\n    \tnoun_phrases: ['the dog','the cat']\n    \tnoun_phrases_tagged: ['the/DT dog/NN','the/DT cat/NN']\n        verb_phrases: ['will go quickly','go slowly']\n        verb_phrases_tagged: ['will/MD go/VB quickly/RB','go/VB slowly/RB']\n        prep_phrases: ['by the road','by chance']\n        prep_phrases_tagged: ['by/IN the/DT road/NN','by/IN chance/NN']\n        modifiers: ['red','best','quickly']\n        modifiers_tagged: ['red/JJ','best/JJS','quickly/RB']\n        verb_arg_structures: ['will/MD go/VB quickly/RB','the/DT dog/NN','to/IN the/DT cats/NNS']\n        verb_arg_structures_concise: ['(\"go\" \"dog\" \"to cat\")]\n    \t");
            s$34 = Py.newString("__main__");
            s$35 = Py.newString("/?");
            s$36 = Py.newString("-?");
            s$37 = Py.newString("\n        USAGE: >> python MontyLingua.py \n        ");
            s$38 = Py.newString("\n");
            s$39 = Py.newString("> ");
            s$40 = Py.newString("\nGENERATED SUMMARY:\n");
            s$41 = Py.newString("-- monty took");
            i$42 = Py.newInteger(2);
            s$43 = Py.newString("seconds. --\n");
            s$44 = Py.newString("\n-- monty says goodbye! --");
            s$45 = Py.newString("C:\\work\\montylingua-2.0\\copy\\MontyLingua.py");
            funcTable = new _PyInner();
            c$0___init__ = Py.newCode(2, new String[]{"self", "trace_p"}, "C:\\work\\montylingua-2.0\\copy\\MontyLingua.py", "__init__", false, false, funcTable, 0, null, null, 0, 1);
            c$1_generate_summary = Py.newCode(2, new String[]{"self", "vsoos"}, "C:\\work\\montylingua-2.0\\copy\\MontyLingua.py", "generate_summary", false, false, funcTable, 1, null, null, 0, 1);
            c$2_generate_sentence = Py.newCode(8, new String[]{"self", "vsoo", "sentence_type", "tense", "s_dtnum", "o1_dtnum", "o2_dtnum", "o3_dtnum"}, "C:\\work\\montylingua-2.0\\copy\\MontyLingua.py", "generate_sentence", false, false, funcTable, 2, null, null, 0, 1);
            c$3_jist_predicates = Py.newCode(2, new String[]{"self", "text", "svoos_list", "info", "svoos", "infos"}, "C:\\work\\montylingua-2.0\\copy\\MontyLingua.py", "jist_predicates", false, false, funcTable, 3, null, null, 0, 1);
            c$4_jist = Py.newCode(2, new String[]{"self", "text", "extracted", "tagged", "chunked", "sentences", "tokenized"}, "C:\\work\\montylingua-2.0\\copy\\MontyLingua.py", "jist", false, false, funcTable, 4, null, null, 0, 1);
            c$5_pp_info = Py.newCode(2, new String[]{"self", "extracted_infos", "key", "i", "keys"}, "C:\\work\\montylingua-2.0\\copy\\MontyLingua.py", "pp_info", false, false, funcTable, 5, null, null, 0, 1);
            c$6_split_paragraphs = Py.newCode(2, new String[]{"self", "text"}, "C:\\work\\montylingua-2.0\\copy\\MontyLingua.py", "split_paragraphs", false, false, funcTable, 6, null, null, 0, 1);
            c$7_split_sentences = Py.newCode(2, new String[]{"self", "text"}, "C:\\work\\montylingua-2.0\\copy\\MontyLingua.py", "split_sentences", false, false, funcTable, 7, null, null, 0, 1);
            c$8_tokenize = Py.newCode(3, new String[]{"self", "sentence", "expand_contractions_p"}, "C:\\work\\montylingua-2.0\\copy\\MontyLingua.py", "tokenize", false, false, funcTable, 8, null, null, 0, 1);
            c$9_tag_tokenized = Py.newCode(2, new String[]{"self", "tokenized_text"}, "C:\\work\\montylingua-2.0\\copy\\MontyLingua.py", "tag_tokenized", false, false, funcTable, 9, null, null, 0, 1);
            c$10_lambda = Py.newCode(1, new String[]{"x"}, "C:\\work\\montylingua-2.0\\copy\\MontyLingua.py", "<lambda>", false, false, funcTable, 10, null, null, 0, 1);
            c$11_lambda = Py.newCode(1, new String[]{"x"}, "C:\\work\\montylingua-2.0\\copy\\MontyLingua.py", "<lambda>", false, false, funcTable, 11, null, null, 0, 1);
            c$12_strip_tags = Py.newCode(2, new String[]{"self", "tagged_or_chunked_text", "toks"}, "C:\\work\\montylingua-2.0\\copy\\MontyLingua.py", "strip_tags", false, false, funcTable, 12, null, null, 0, 1);
            c$13_parse_pred_arg = Py.newCode(2, new String[]{"self", "pp", "args", "toks"}, "C:\\work\\montylingua-2.0\\copy\\MontyLingua.py", "parse_pred_arg", false, false, funcTable, 13, null, null, 0, 1);
            c$14_chunk_tagged = Py.newCode(2, new String[]{"self", "tagged_text"}, "C:\\work\\montylingua-2.0\\copy\\MontyLingua.py", "chunk_tagged", false, false, funcTable, 14, null, null, 0, 1);
            c$15_chunk_lemmatised = Py.newCode(2, new String[]{"self", "lemmatised_text"}, "C:\\work\\montylingua-2.0\\copy\\MontyLingua.py", "chunk_lemmatised", false, false, funcTable, 15, null, null, 0, 1);
            c$16_lemmatise_tagged = Py.newCode(2, new String[]{"self", "tagged_text"}, "C:\\work\\montylingua-2.0\\copy\\MontyLingua.py", "lemmatise_tagged", false, false, funcTable, 16, null, null, 0, 1);
            c$17_extract_info = Py.newCode(2, new String[]{"self", "chunked_text"}, "C:\\work\\montylingua-2.0\\copy\\MontyLingua.py", "extract_info", false, false, funcTable, 17, null, null, 0, 1);
            c$18_MontyLingua = Py.newCode(0, new String[0], "C:\\work\\montylingua-2.0\\copy\\MontyLingua.py", "MontyLingua", false, false, funcTable, 18, null, null, 0, 0);
            c$19_lambda = Py.newCode(1, new String[]{"a"}, "C:\\work\\montylingua-2.0\\copy\\MontyLingua.py", "<lambda>", false, false, funcTable, 19, null, null, 0, 1);
            c$20_lambda = Py.newCode(2, new String[]{"y", "z"}, "C:\\work\\montylingua-2.0\\copy\\MontyLingua.py", "<lambda>", false, false, funcTable, 20, null, null, 0, 1);
            c$21_lambda = Py.newCode(1, new String[]{"x"}, "C:\\work\\montylingua-2.0\\copy\\MontyLingua.py", "<lambda>", false, false, funcTable, 21, null, null, 0, 1);
            c$22_main = Py.newCode(0, new String[0], "C:\\work\\montylingua-2.0\\copy\\MontyLingua.py", "main", false, false, funcTable, 22, null, null, 0, 0);
        }

        public PyCode getMain() {
            if (c$22_main == null) {
                _PyInner.initConstants();
            }
            return c$22_main;
        }

        public PyObject call_function(int n, PyFrame pyFrame) {
            switch (n) {
                case 0: {
                    return _PyInner.__init__$1(pyFrame);
                }
                case 1: {
                    return _PyInner.generate_summary$2(pyFrame);
                }
                case 2: {
                    return _PyInner.generate_sentence$3(pyFrame);
                }
                case 3: {
                    return _PyInner.jist_predicates$4(pyFrame);
                }
                case 4: {
                    return _PyInner.jist$5(pyFrame);
                }
                case 5: {
                    return _PyInner.pp_info$6(pyFrame);
                }
                case 6: {
                    return _PyInner.split_paragraphs$7(pyFrame);
                }
                case 7: {
                    return _PyInner.split_sentences$8(pyFrame);
                }
                case 8: {
                    return _PyInner.tokenize$9(pyFrame);
                }
                case 9: {
                    return _PyInner.tag_tokenized$10(pyFrame);
                }
                case 10: {
                    return _PyInner.lambda$11(pyFrame);
                }
                case 11: {
                    return _PyInner.lambda$12(pyFrame);
                }
                case 12: {
                    return _PyInner.strip_tags$13(pyFrame);
                }
                case 13: {
                    return _PyInner.parse_pred_arg$14(pyFrame);
                }
                case 14: {
                    return _PyInner.chunk_tagged$15(pyFrame);
                }
                case 15: {
                    return _PyInner.chunk_lemmatised$16(pyFrame);
                }
                case 16: {
                    return _PyInner.lemmatise_tagged$17(pyFrame);
                }
                case 17: {
                    return _PyInner.extract_info$18(pyFrame);
                }
                case 18: {
                    return _PyInner.MontyLingua$19(pyFrame);
                }
                case 19: {
                    return _PyInner.lambda$20(pyFrame);
                }
                case 20: {
                    return _PyInner.lambda$21(pyFrame);
                }
                case 21: {
                    return _PyInner.lambda$22(pyFrame);
                }
                case 22: {
                    return _PyInner.main$23(pyFrame);
                }
            }
            return null;
        }

        private static PyObject __init__$1(PyFrame pyFrame) {
            Py.println(s$3._add(pyFrame.getglobal("__version__"))._add(s$4));
            Py.println(s$5);
            pyFrame.getlocal(0).__setattr__("trace_p", pyFrame.getlocal(1));
            pyFrame.getlocal(0).__setattr__("theMontyTokenizer", pyFrame.getglobal("MontyTokenizer").__getattr__("MontyTokenizer").__call__());
            pyFrame.getlocal(0).__setattr__("theMontyLemmatiser", pyFrame.getglobal("MontyLemmatiser").__getattr__("MontyLemmatiser").__call__());
            pyFrame.getlocal(0).__setattr__("theMontyTagger", pyFrame.getglobal("MontyTagger").__getattr__("MontyTagger").__call__(pyFrame.getlocal(1), pyFrame.getlocal(0).__getattr__("theMontyLemmatiser")));
            pyFrame.getlocal(0).__setattr__("theMontyChunker", pyFrame.getglobal("MontyREChunker").__getattr__("MontyREChunker").__call__());
            pyFrame.getlocal(0).__setattr__("theMontyExtractor", pyFrame.getglobal("MontyExtractor").__getattr__("MontyExtractor").__call__());
            pyFrame.getlocal(0).__setattr__("theMontyNLGenerator", pyFrame.getglobal("MontyNLGenerator").__getattr__("MontyNLGenerator").__call__());
            Py.println(s$6);
            return Py.None;
        }

        private static PyObject generate_summary$2(PyFrame pyFrame) {
            return pyFrame.getlocal(0).__getattr__("theMontyNLGenerator").invoke("generate_summary", pyFrame.getlocal(1));
        }

        private static PyObject generate_sentence$3(PyFrame pyFrame) {
            return pyFrame.getlocal(0).__getattr__("theMontyNLGenerator").__getattr__("generate_sentence").__call__(new PyObject[]{pyFrame.getlocal(1), pyFrame.getlocal(2), pyFrame.getlocal(3), pyFrame.getlocal(4), pyFrame.getlocal(5), pyFrame.getlocal(6), pyFrame.getlocal(7)}, new String[]{"sentence_type", "tense", "s_dtnum", "o1_dtnum", "o2_dtnum", "o3_dtnum"});
        }

        private static PyObject jist_predicates$4(PyFrame pyFrame) {
            PyObject pyObject;
            pyFrame.setlocal(5, pyFrame.getlocal(0).invoke("jist", pyFrame.getlocal(1)));
            pyFrame.setlocal(2, (PyObject)new PyList(new PyObject[0]));
            int n = 0;
            PyObject pyObject2 = pyFrame.getlocal(5);
            while ((pyObject = pyObject2.__finditem__(n++)) != null) {
                pyFrame.setlocal(3, pyObject);
                pyFrame.setlocal(4, pyFrame.getlocal(3).__getitem__(s$15));
                pyFrame.getlocal(2).invoke("append", pyFrame.getlocal(4));
            }
            return pyFrame.getlocal(2);
        }

        private static PyObject jist$5(PyFrame pyFrame) {
            pyFrame.setlocal(5, pyFrame.getlocal(0).invoke("split_sentences", pyFrame.getlocal(1)));
            pyFrame.setlocal(6, pyFrame.getglobal("map").__call__(pyFrame.getlocal(0).__getattr__("tokenize"), pyFrame.getlocal(5)));
            pyFrame.setlocal(3, pyFrame.getglobal("map").__call__(pyFrame.getlocal(0).__getattr__("tag_tokenized"), pyFrame.getlocal(6)));
            pyFrame.setlocal(4, pyFrame.getglobal("map").__call__(pyFrame.getlocal(0).__getattr__("chunk_tagged"), pyFrame.getlocal(3)));
            pyFrame.setlocal(2, pyFrame.getglobal("map").__call__(pyFrame.getlocal(0).__getattr__("extract_info"), pyFrame.getlocal(4)));
            return pyFrame.getlocal(2);
        }

        private static PyObject pp_info$6(PyFrame pyFrame) {
            PyObject pyObject;
            int n = 0;
            PyObject pyObject2 = pyFrame.getglobal("range").__call__(pyFrame.getglobal("len").__call__(pyFrame.getlocal(1)));
            while ((pyObject = pyObject2.__finditem__(n++)) != null) {
                PyObject pyObject3;
                pyFrame.setlocal(3, pyObject);
                pyFrame.setlocal(4, pyFrame.getlocal(1).__getitem__(pyFrame.getlocal(3)).invoke("keys"));
                pyFrame.getlocal(4).invoke("sort");
                Py.println(s$18._mod(pyFrame.getglobal("str").__call__(pyFrame.getlocal(3)._add(i$13))));
                int n2 = 0;
                PyObject pyObject4 = pyFrame.getlocal(4);
                while ((pyObject3 = pyObject4.__finditem__(n2++)) != null) {
                    pyFrame.setlocal(2, pyObject3);
                    Py.println(pyFrame.getlocal(2)._add(s$19).invoke("rjust", i$20)._add(pyFrame.getglobal("str").__call__(pyFrame.getlocal(1).__getitem__(pyFrame.getlocal(3)).__getitem__(pyFrame.getlocal(2)))));
                }
            }
            return Py.None;
        }

        private static PyObject split_paragraphs$7(PyFrame pyFrame) {
            return pyFrame.getlocal(0).__getattr__("theMontyTokenizer").invoke("split_paragraphs", pyFrame.getlocal(1));
        }

        private static PyObject split_sentences$8(PyFrame pyFrame) {
            return pyFrame.getlocal(0).__getattr__("theMontyTokenizer").invoke("split_sentences", pyFrame.getlocal(1));
        }

        private static PyObject tokenize$9(PyFrame pyFrame) {
            return pyFrame.getlocal(0).__getattr__("theMontyTokenizer").invoke("tokenize", pyFrame.getlocal(1), pyFrame.getlocal(2));
        }

        private static PyObject tag_tokenized$10(PyFrame pyFrame) {
            return pyFrame.getlocal(0).__getattr__("theMontyTagger").invoke("tag_tokenized", pyFrame.getlocal(1));
        }

        private static PyObject lambda$11(PyFrame pyFrame) {
            return s$26._in(pyFrame.getlocal(0));
        }

        private static PyObject lambda$12(PyFrame pyFrame) {
            return pyFrame.getlocal(0).invoke("split", s$26).__getitem__(i$7);
        }

        private static PyObject strip_tags$13(PyFrame pyFrame) {
            pyFrame.setlocal(2, pyFrame.getlocal(1).invoke("split"));
            pyFrame.setlocal(2, pyFrame.getglobal("filter").__call__(new PyFunction(pyFrame.f_globals, new PyObject[0], c$10_lambda), pyFrame.getlocal(2)));
            pyFrame.setlocal(2, pyFrame.getglobal("map").__call__(new PyFunction(pyFrame.f_globals, new PyObject[0], c$11_lambda), pyFrame.getlocal(2)));
            return s$27.invoke("join", pyFrame.getlocal(2));
        }

        private static PyObject parse_pred_arg$14(PyFrame pyFrame) {
            pyFrame.getlocal(1).__getattr__("strip");
            pyFrame.setlocal(3, pyFrame.getlocal(1).invoke("strip").__getslice__(i$13, i$13.__neg__(), null).invoke("split"));
            pyFrame.setlocal(2, s$27.invoke("join", pyFrame.getlocal(3)).__getslice__(i$13, i$13.__neg__(), null).invoke("split", s$29));
            return pyFrame.getlocal(2);
        }

        private static PyObject chunk_tagged$15(PyFrame pyFrame) {
            return pyFrame.getlocal(0).__getattr__("theMontyChunker").invoke("Process", pyFrame.getlocal(1));
        }

        private static PyObject chunk_lemmatised$16(PyFrame pyFrame) {
            return pyFrame.getlocal(0).__getattr__("theMontyChunker").invoke("chunk_multitag", pyFrame.getlocal(1));
        }

        private static PyObject lemmatise_tagged$17(PyFrame pyFrame) {
            return pyFrame.getlocal(0).__getattr__("theMontyLemmatiser").invoke("lemmatise_tagged_sentence", pyFrame.getlocal(1));
        }

        private static PyObject extract_info$18(PyFrame pyFrame) {
            return pyFrame.getlocal(0).__getattr__("theMontyExtractor").invoke("extract_info", pyFrame.getlocal(1), pyFrame.getlocal(0).__getattr__("theMontyLemmatiser").__getattr__("lemmatise_tagged_sentence"));
        }

        private static PyObject MontyLingua$19(PyFrame pyFrame) {
            pyFrame.setlocal("__init__", (PyObject)new PyFunction(pyFrame.f_globals, new PyObject[]{i$7}, c$0___init__));
            pyFrame.setlocal("generate_summary", (PyObject)new PyFunction(pyFrame.f_globals, new PyObject[0], c$1_generate_summary));
            pyFrame.setlocal("generate_sentence", (PyObject)new PyFunction(pyFrame.f_globals, new PyObject[]{s$10, s$11, new PyTuple(new PyObject[]{s$12, i$13}), new PyTuple(new PyObject[]{s$12, i$13}), new PyTuple(new PyObject[]{s$12, i$13}), new PyTuple(new PyObject[]{s$12, i$13})}, c$2_generate_sentence));
            pyFrame.setlocal("jist_predicates", (PyObject)new PyFunction(pyFrame.f_globals, new PyObject[0], c$3_jist_predicates));
            pyFrame.setlocal("jist", (PyObject)new PyFunction(pyFrame.f_globals, new PyObject[0], c$4_jist));
            pyFrame.setlocal("pp_info", (PyObject)new PyFunction(pyFrame.f_globals, new PyObject[0], c$5_pp_info));
            pyFrame.setlocal("split_paragraphs", (PyObject)new PyFunction(pyFrame.f_globals, new PyObject[0], c$6_split_paragraphs));
            pyFrame.setlocal("split_sentences", (PyObject)new PyFunction(pyFrame.f_globals, new PyObject[0], c$7_split_sentences));
            pyFrame.setlocal("tokenize", (PyObject)new PyFunction(pyFrame.f_globals, new PyObject[]{i$13}, c$8_tokenize));
            pyFrame.setlocal("tag_tokenized", (PyObject)new PyFunction(pyFrame.f_globals, new PyObject[0], c$9_tag_tokenized));
            pyFrame.setlocal("strip_tags", (PyObject)new PyFunction(pyFrame.f_globals, new PyObject[0], c$12_strip_tags));
            pyFrame.setlocal("parse_pred_arg", (PyObject)new PyFunction(pyFrame.f_globals, new PyObject[0], c$13_parse_pred_arg));
            pyFrame.setlocal("chunk_tagged", (PyObject)new PyFunction(pyFrame.f_globals, new PyObject[0], c$14_chunk_tagged));
            pyFrame.setlocal("chunk_lemmatised", (PyObject)new PyFunction(pyFrame.f_globals, new PyObject[0], c$15_chunk_lemmatised));
            pyFrame.setlocal("lemmatise_tagged", (PyObject)new PyFunction(pyFrame.f_globals, new PyObject[0], c$16_lemmatise_tagged));
            pyFrame.setlocal("extract_info", (PyObject)new PyFunction(pyFrame.f_globals, new PyObject[0], c$17_extract_info));
            return pyFrame.getf_locals();
        }

        private static PyObject lambda$20(PyFrame pyFrame) {
            return pyFrame.getglobal("m").invoke("parse_pred_arg", pyFrame.getlocal(0));
        }

        private static PyObject lambda$21(PyFrame pyFrame) {
            return pyFrame.getlocal(0)._add(pyFrame.getlocal(1));
        }

        private static PyObject lambda$22(PyFrame pyFrame) {
            return pyFrame.getlocal(0).__getitem__(s$15);
        }

        private static PyObject main$23(PyFrame pyFrame) {
            pyFrame.setglobal("__file__", s$45);
            pyFrame.setlocal("__author__", s$1);
            pyFrame.setlocal("__version__", s$2);
            pyFrame.setlocal("MontyTokenizer", imp.importOne("MontyTokenizer", pyFrame));
            pyFrame.setlocal("MontyTagger", imp.importOne("MontyTagger", pyFrame));
            pyFrame.setlocal("MontyLemmatiser", imp.importOne("MontyLemmatiser", pyFrame));
            pyFrame.setlocal("MontyREChunker", imp.importOne("MontyREChunker", pyFrame));
            pyFrame.setlocal("MontyExtractor", imp.importOne("MontyExtractor", pyFrame));
            pyFrame.setlocal("MontyNLGenerator", imp.importOne("MontyNLGenerator", pyFrame));
            pyFrame.setlocal("MontyLingua", Py.makeClass("MontyLingua", new PyObject[0], c$18_MontyLingua, null));
            if (pyFrame.getname("__name__")._eq(s$34).__nonzero__()) {
                pyFrame.setlocal("sys", imp.importOne("sys", pyFrame));
                pyFrame.setlocal("time", imp.importOne("time", pyFrame));
                PyObject pyObject = s$35._in(pyFrame.getname("sys").__getattr__("argv"));
                if ((pyObject.__nonzero__() ? pyObject : s$36._in(pyFrame.getname("sys").__getattr__("argv"))).__nonzero__()) {
                    Py.println(s$37);
                    pyFrame.getname("sys").__getattr__("exit").__call__(i$7);
                }
                pyFrame.setlocal("m", pyFrame.getname("MontyLingua").__call__());
                Py.println(s$38);
                try {
                    while (i$13.__nonzero__()) {
                        pyFrame.setlocal("sentence", s$12);
                        try {
                            pyFrame.setlocal("sentence", pyFrame.getname("raw_input").__call__(s$39));
                        }
                        catch (Throwable throwable) {
                            PyException pyException = Py.setException(throwable, pyFrame);
                            throw Py.makeException();
                        }
                        pyFrame.setlocal("time1", pyFrame.getname("time").__getattr__("time").__call__());
                        Py.println(s$38);
                        pyFrame.setlocal("extractions", pyFrame.getname("m").invoke("jist", pyFrame.getname("sentence")));
                        Py.println(pyFrame.getname("m").invoke("pp_info", pyFrame.getname("extractions")));
                        pyFrame.setlocal("predicates_list", pyFrame.getname("map").__call__(new PyFunction(pyFrame.f_globals, new PyObject[0], c$19_lambda), pyFrame.getname("reduce").__call__(new PyFunction(pyFrame.f_globals, new PyObject[0], c$20_lambda), pyFrame.getname("map").__call__(new PyFunction(pyFrame.f_globals, new PyObject[0], c$21_lambda), pyFrame.getname("extractions")))));
                        Py.println(pyFrame.getname("predicates_list"));
                        Py.println(s$40._add(pyFrame.getname("m").invoke("generate_summary", pyFrame.getname("predicates_list"))));
                        pyFrame.setlocal("time2", pyFrame.getname("time").__getattr__("time").__call__());
                        Py.printComma(s$41);
                        Py.printComma(pyFrame.getname("str").__call__(pyFrame.getname("round").__call__(pyFrame.getname("time2")._sub(pyFrame.getname("time1")), i$42)));
                        Py.println(s$43);
                    }
                }
                catch (Throwable throwable) {
                    PyException pyException = Py.setException(throwable, pyFrame);
                    if (Py.matchException(pyException, pyFrame.getname("KeyboardInterrupt"))) {
                        Py.println(s$44);
                        pyFrame.getname("sys").__getattr__("exit").__call__(i$7);
                    }
                    throw pyException;
                }
            }
            return Py.None;
        }
    }
}

