# Craig R. Farrand
# Computer Science 699
# Directed by Professor Michael Gleicher
# March 18, 1999


# import the system and os modules
import sys, os
# import the math module
from math import *
# setup the path to the imaging module
# need this since PIL doesn't have an installer
sys.path.append('C:\PROGRA~1\PYTHON\PIL')
# import the entire Tk interface module
from Tkinter import *
import Image, ImageTk
# import our swigged note module
import notemodule
# import the image filter module
import ImageFilter
# import the imaging shared library
# import _imaging


class Note(Label):


	# initialization method called when an instance of the class is made
	def __init__(self):
		self.im = None
		self.bmp = None
		# the data of the image opened
		self.data = None
		self.root = None
		self.filename = None
		# class variable to store histogram information
		self.hist = None
		# class variable to store probability that a pixel is ink color
		self.prob = []
		# calculated luminance values for each pixel
		self.lumValues = []
		self.width = 0
		self.height = 0
		# data structures for line detection and removal
		self.linePos = []
		self.lineTheta = []
		self.lineStartColor = []
		self.lineCount = 0
		self.RGB_RANGE = 35
		self.LUM_CUT = 235


	# open method
	def Open(self, filename):
		try:
			self.filename = filename
			self.im = Image.open(filename)
			self.width = self.im.size[0]
			self.height = self.im.size[1]
			# get the pixel data fromt the image
			self.data = self.im.getdata()
			print "\nOpening file: %s" % (filename)
		except:
			print "File or directory does not exist."
			return


	# save method
	# - saves the current image with the specified file format
	# - PIL automatically changes the file format if you change the
	#   extension name.  For example, when you open a .tif file and then
	#   call this method as (Save("name.gif")), PIL will convert the tif image
	#   to a GIF image then save it in GIF format.
	def Save(self, filename):
		if(self.im == None):
			print "No image opened to save."
			return
		try:
			self.im.save(filename)
			print "Saving current image with filename: %s" \
				% (filename)
		except:
			print "Bad filename or directory."


	# convert the current image to black and white format
	def Convert(self):
		if(self.im == None):
			print "No image opened to convert to black and white."
			return
		else:
			print "Converting current image to black and white."
			self.im = self.im.convert("L")


	# cut out the pixel data from the image for the sheet of paper
	# -  assumes 150 DPI scanning resolution in TIF format
	# -  assumes an 8 1/2 x 11 inch sheet of paper was scanned
	# -  cuts out the extra garbage on the sides and bottom of the scanned
	#    image to get a nice clean image.
	# -  most of the images scanned on the HP scanner in the vision lab are
	#    1275 x 2100 pixels - 8 1/2 x 14 inches
	def Extract(self):
		if(self.im == None):
			print "No image to clean."
			return
		else:
			print "Extracting sheet data."
			# quick test to see if the image is taller than 11 inches at 150 DPI
			if(self.height >= 1650):
				sheet = self.im.crop((30, 10, 1240, 1630))
				self.im = sheet
				# reset self.width, self.height, and self.data from the new pixel data
				self.width = self.im.size[0]
				self.height = self.im.size[1]
				# get the pixel data fromt the image
				self.data = self.im.getdata()



	# resize the image to a default size
	def Resize(self):
		if(self.im == None):
			print "No image opened to resize."
			return

		# calculate the aspect ration
		# width / height
		aspectRatio = float(self.width) / float(self.height)

		# resize images with a width greater than 612 - this will put
		# the output GIF images in roughly 8 1/2 x 11 inch format since
		# the PIL GIF output files are 72 pixels per inch
		# Maintain the aspect ratio
		if(self.width > 612):
			print "Resizing the current image maintaining its aspect ratio."
			# RESIZE filter options are
			# NEARESET = 0
			# BILINEAR = 2
			# BICUBIC  = 3
			# use bicubic filter for resizing
			self.im = self.im.resize((612, int(612 / float(aspectRatio))), 3)
			# reset self.width, self.height, and self.data from the new pixel data
			self.width = self.im.size[0]
			self.height = self.im.size[1]
			# get the pixel data fromt the image
			self.data = self.im.getdata()
			print "New image dimensions are (%d, %d)." % (self.width, self.height)
		else:
			print "Image all ready has acceptable dimensions.  No need to resize."


	# display the image using the Image Tk Module
	# - opens a file in any format supported by PIL
	# - this works on my computer at home, but it does not work on the machine in
	#   3370.  File permissions?
	def Display(self):
		if(self.im == None):
			print "No image opened to save."
			return
		self.root = Tk()
		self.root.title(self.filename)
		if(self.im.mode == "1"):
			# bitmap image
			print "Image displayed is a bmp."
			self.image = ImageTk.BitmapImage(self.im, foreground = "white")
			self.label = Label.__init__(self, self.root, image = self.image, bg = "black", bd = 0)
		else:
			# photo image
			print "Image displayed is a photo image."
			self.image = ImageTk.PhotoImage(self.im)
			self.label = Label.__init__(self, self.root, image = self.image, bd = 0)
		self.pack()
		self.tkloop = self.root.mainloop()
		# cleanup Tk data structures
		self.root = None
		self.label = None
		self.image = None


	# print out statistics of the currently loaded image
	def Stat(self):
		if(self.im != None):
			print "\n"
			print "File:    %s" % (self.filename)
			print "Format:  %s" % (self.im.format)
			if(self.im.palette == None):
				print "Palette: No"
			else:
				print "Palette: Yes"
			print "Width:   %d" % (self.im.size[0])
			print "height:  %d" % (self.im.size[1])
			print "Mode:    %s" % (self.im.mode)
			print "\n"
		else:
			print "No image currently opened.";


	# calculate the probability that a given pixel is ink
	# - this function is obsolete, kept for reference
	def Prob(self):
		curProb = 0
		curLum = 0

		if(self.im == None):
			print "No image opened to calculate probabilities on."
			return

		# get a histogram of the image
		self.hist = self.im.histogram()

		print "Calculating luminance values..."

		# calculate luminance values for all pixels in the image
		# luminance = .299*R + .587*G + .114*B
		for y in range(self.height):
			for x in range(self.width):
				curPixel = self.data[x + (y * self.width)]
				self.lumValues.append(0.299 * float(curPixel[0]) + \
					0.587 * float(curPixel[1]) + 0.114 * float(curPixel[2]))
				if(self.lumValues[x + (y * self.width)] > 255.0):
					self.lumValues[x + (y * self.width)] = 255.0
				elif(self.lumValues[x + (y * self.width)] < 0.0):
					self.lumValues[x + (y * self.width)] = 0.0

		print "Calculating probabilities..."

		scale = 50.0 / 255.0

		# traverse height of image
		for y in range(self.height):
			# traverse the width of the current height
			for x in range(self.width):
				# curPixel = self.data[x + (y * self.width)]
				# if the number pixels with this luminance is greater than
				# half of the number of pixels in the image, it's most likely
				# a pixel within the background
				if((self.hist[int(self.lumValues[x + y * self.width])]) > \
					(self.width * self.height /2)):
					curProb = 0
					self.prob.append(curProb)
				# very bright pixel, most likely background
				elif((curPixel[0] > 250) and (curPixel[1] > 250) and \
					(curPixel[2] > 250)):
					curProb = 0
					self.prob.append(curProb)
				# very dark pixel, most likely ink
				elif((curPixel[0] < 6) and (curPixel[1] < 6) and \
					(curPixel[2] < 6)):
					curProb = 100
					self.prob.append(curProb)
				# otherwise, we don't know if its ink or background
				# start with a 50/50 value
				else:
					curProb = 50

					# check the luminance values of nearby pixels and
					# adjust the probability according to the difference
					# in the luminances
					# - if a nearby pixel has a much higher luminance
					#   than the current pixel, then chances are that
					#   the current pixel is ink
					# - if a nearby pixel has a much lower luminance
					#   than the current pixel, then chances are that
					#   the current pixel is background

					# right neighboring pixel
					if(x + 1 < self.width):
						curProb = curProb + \
							((self.lumValues[x + 1 + (y * self.width)] - \
							self.lumValues[x + (y * self.width)]) * scale)
					# left neighboring pixel
					if(x - 1 >= 0):
						curProb = curProb + \
							((self.lumValues[x - 1 + (y * self.width)] - \
							self.lumValues[x + (y * self.width)]) * scale)
					# pixel above this pixel
					if(y - 1 >= 0):
						curProb = curProb + \
							((self.lumValues[x + ((y - 1)* self.width)] - \
							self.lumValues[x + (y * self.width)]) * scale)
					# pixel below this pixel
					if(y + 1 < self.height):
						curProb = curProb + \
							((self.lumValues[x + ((y + 1) * self.width)] - \
							self.lumValues[x + (y * self.width)]) * scale)
					# right upper pixel
					if((x + 1 < self.width) and (y - 1 >= 0)):
						curProb = curProb + \
							((self.lumValues[x + 1 + ((y - 1) * self.width)] - \
							self.lumValues[x + (y * self.width)]) * scale)
					# right lower pixel
					if((x + 1 < self.width) and (y + 1 < self.height)):
						curProb = curProb + \
							((self.lumValues[x + 1 + ((y + 1) * self.width)] - \
							self.lumValues[x + (y * self.width)]) * scale)
					# left upper pixel
					if((x - 1 >= 0) and (y - 1 >= 0)):
						curProb = curProb + \
							((self.lumValues[x - 1 + ((y - 1) * self.width)] - \
							self.lumValues[x + (y * self.width)]) * scale)
					# left lower pixel
					if((x - 1 >= 0) and (y + 1 < self.height)):
						curProb = curProb + \
							((self.lumValues[x - 1 + ((y + 1) * self.width)] - \
							self.lumValues[x + (y * self.width)]) * scale)

					# add the probability to the probability list
					self.prob.append(curProb)

					# modify the existing probability from MH edge finding
					#self.prob[x + y * self.height] = self.prob[x + y * self.height] + curProb




	# perform Marr-Hildreth Edge Detection Algorithm to find text and lines
	# adjust probabilities according to the values calculated by the algorithm
	def MarrHildreth(self):
		curProb = 0
		if(self.im == None):
			print "No image opened to perform Marr-Hildreth edge detection on."
			return

		print "Calculating luminance values..."

		# calculate luminance values for all pixels in the image
		# luminance = .299*R + .587*G + .114*B
		for y in range(self.height):
			for x in range(self.width):
				curPixel = self.data[x + (y * self.width)]
				self.lumValues.append(0.299 * float(curPixel[0]) + \
					0.587 * float(curPixel[1]) + 0.114 * float(curPixel[2]))
				if(self.lumValues[x + (y * self.width)] > 255.0):
					self.lumValues[x + (y * self.width)] = 255.0
				elif(self.lumValues[x + (y * self.width)] < 0.0):
					self.lumValues[x + (y * self.width)] = 0.0
				#print "%d" % (self.lumValues[x + y])

		print "Calculating probabilities for edges..."

		scale = 100.0 / 255.0

		# traverse height of image
		for y in range(self.height):
			# traverse the width of the current height
			for x in range(self.width):
				curPixel = self.data[x + (y * self.width)]
				curProb = 0.0

				# use the Marr-Hildreth edge detection filter for
				# marking pixel probabilities, we'll use the calculated
				# luminance values for the filter operations and scale them
				# to make the maximum value 100.  We'll skip the zero parts
				# of the filter.

				# pixel positions listed will be relative to the current
				# pixel location (x, y)

				# ROW ONE OF FILTER
				# pixel -2, -5
				if((x - 2 >= 0) and (y - 5 >= 0)):
					curProb = curProb - self.lumValues[x - 2 + ((y - 5) * self.width)]
				# pixel -1, -5
				if((x - 1 >= 0) and (y - 5 >= 0)):
					curProb = curProb - self.lumValues[x - 1 + ((y - 5) * self.width)]
				# pixel 0, -5
				if(y - 5 >= 0):
					curProb = curProb - 2 * self.lumValues[x + ((y - 5) * self.width)]
				# pixel 1, -5
				if((x + 1 < self.width) and (y - 5 >= 0)):
					curProb = curProb - self.lumValues[x + 1 + ((y - 5) * self.width)]
				# pixel 2, -5
				if((x + 2 < self.width) and (y - 5 >= 0)):
					curProb = curProb - self.lumValues[x + 2 + ((y - 5) * self.width)]

				# ROW TWO OF FILTER
				# pixel -3, -4
				if((x - 3 >= 0) and (y - 4 >= 0)):
					curProb = curProb - 2 * self.lumValues[x - 3 + ((y - 4) * self.width)]
				# pixel -2, -4
				if((x - 2 >= 0) and (y - 4 >= 0)):
					curProb = curProb - 4 * self.lumValues[x - 2 + ((y - 4) * self.width)]
				# pixel -1, -4
				if((x - 1 >= 0) and (y - 4 >= 0)):
					curProb = curProb - 8 * self.lumValues[x - 1 + ((y - 4) * self.width)]
				# pixel 0, -4
				if(y - 4 >= 0):
					curProb = curProb - 9 * self.lumValues[x + ((y - 4) * self.width)]
				# pixel 1, -4
				if((x + 1 < self.width) and (y - 4 >= 0)):
					curProb = curProb - 8 * self.lumValues[x + 1 + ((y - 4) * self.width)]
				# pixel 2, -4
				if((x + 2 < self.width) and (y - 4 >= 0)):
					curProb = curProb - 4 * self.lumValues[x + 2 + ((y - 4) * self.width)]
				# pixel 3, -4
				if((x + 3 < self.width) and (y - 4 >= 0)):
					curProb = curProb - 2 * self.lumValues[x + 3 + ((y - 4) * self.width)]

				# ROW THREE OF FILTER
				# pixel -4, -3
				if((x - 4 >= 0) and (y - 3 >= 0)):
					curProb = curProb - 2 * self.lumValues[x - 4 + ((y - 3) * self.width)]
				# pixel -3, -3
				if((x - 3 >= 0) and (y - 3 >= 0)):
					curProb = curProb - 7 * self.lumValues[x - 3 + ((y - 3) * self.width)]
				# pixel -2, -3
				if((x - 2 >= 0) and (y - 3 >= 0)):
					curProb = curProb - 15 * self.lumValues[x - 2 + ((y - 3) * self.width)]
				# pixel - 1, -3
				if((x - 1 >= 0) and (y - 3 >= 0)):
					curProb = curProb - 22 * self.lumValues[x - 1 + ((y - 3) * self.width)]
				# pixel 0, -3
				if(y - 3 >= 0):
					curProb = curProb - 23 * self.lumValues[x + ((y - 3) * self.width)]
				# pixel 1, -3
				if(( x + 1 < self.width) and (y - 3 >= 0)):
					curProb = curProb - 22 * self.lumValues[x + 1 + ((y - 3) * self.width)]
				# pixel 2, -3
				if((x + 2 < self.width) and (y - 3 >= 0)):
					curProb = curProb - 15 * self.lumValues[x + 2 + ((y - 3) * self.width)]
				# pixel 3, -3
				if((x + 3 < self.width) and (y - 3 >= 0)):
					curProb = curProb - 7 * self.lumValues[x + 3 + ((y - 3) * self.width)]
				# pixel 4, -3
				if((x + 4 < self.width) and ( y - 3 >= 0)):
					curProb = curProb - 2 * self.lumValues[x + 4 + ((y - 3) * self.width)]

				# ROW FOUR OF FILTER
				# pixel -5, -2
				if((x - 5 >= 0) and (y - 2 >= 0)):
					curProb = curProb - self.lumValues[x - 5 + ((y - 2) * self.width)]
				# pixel -4, -2
				if((x - 4 >= 0) and (y - 2 >= 0)):
					curProb = curProb - 4 * self.lumValues[x - 4 + ((y - 2) * self.width)]
				# pixel -3, -2
				if((x - 3 >= 0) and (y - 2 >= 0)):
					curProb = curProb - 15 * self.lumValues[x - 3 + ((y - 2) * self.width)]
				# pixel -2, -2
				if((x - 2 >= 0) and (y - 2 >= 0)):
					curProb = curProb - 24 * self.lumValues[x - 2 + ((y - 2) * self.width)]
				# pixel -1, -2
				if((x - 1 >= 0) and (y - 2 >= 0)):
					curProb = curProb - 14 * self.lumValues[x - 1 + ((y - 2) * self.width)]
				# pixel 0, -2
				if(y - 2 >= 0):
					curProb = curProb - self.lumValues[x + ((y - 2) * self.width)]
				# pixel 1, -2
				if((x + 1 < self.width) and (y - 2 >= 0)):
					curProb = curProb - 14 * self.lumValues[x + 1 + ((y - 2) * self.width)]
				# pixel 2, -2
				if((x + 2 < self.width) and (y - 2 >= 0)):
					curProb = curProb - 24 * self.lumValues[x + 2 + ((y - 2) * self.width)]
				# pixel 3, -2
				if((x + 3 < self.width) and (y - 2 >= 0)):
					curProb = curProb - 15 * self.lumValues[x + 3 + ((y - 2) * self.width)]
				# pixel 4, -2
				if((x + 4 < self.width) and (y - 2 >= 0)):
					curProb = curProb - 4 * self.lumValues[x + 4 + ((y - 2) * self.width)]
				# pixel 5, -2
				if((x + 5 < self.width) and (y - 2 >= 0)):
					curProb = curProb - self.lumValues[x + 5 + ((y - 2) * self.width)]

				# ROW FIVE OF FILTER
				# pixel -5, -1
				if((x - 5 >= 0) and (y - 1 >= 0)):
					curProb = curProb - self.lumValues[x - 5 + ((y - 1) * self.width)]
				# pixel -4, -1
				if((x - 4 >= 0) and (y - 1 >= 0)):
					curProb = curProb - 8 * self.lumValues[x - 4 + ((y - 1) * self.width)]
				# pixel -3, -1
				if((x - 3 >= 0) and (y - 1 >= 0)):
					curProb = curProb - 22 * self.lumValues[x - 3 + ((y - 1) * self.width)]
				# pixel -2, -1
				if((x - 2 >= 0) and (y - 1 >= 0)):
					curProb = curProb - 14 * self.lumValues[x - 2 + ((y - 1) * self.width)]
				# pixel -1, -1
				if((x - 1 >= 0) and (y - 1 >= 0)):
					curProb = curProb + 52 * self.lumValues[x - 1 + ((y - 1) * self.width)]
				# pixel 0, -1
				if(y - 1 >= 0):
					curProb = curProb + 103 * self.lumValues[x + ((y - 1) * self.width)]
				# pixel 1, -1
				if((x + 1 < self.width) and (y - 1 >= 0)):
					curProb = curProb + 52 * self.lumValues[x + 1 + ((y - 1) * self.width)]
				# pixel 2, -1
				if((x + 2 < self.width) and (y - 1 >= 0)):
					curProb = curProb - 14 * self.lumValues[x + 2 + ((y - 1) * self.width)]
				# pixel 3, -1
				if((x + 3 < self.width) and (y - 1 >= 0)):
					curProb = curProb - 22 * self.lumValues[x + 3 + ((y - 1) * self.width)]
				# pixel 4, -1
				if((x + 4 < self.width) and (y - 1 >= 0)):
					curProb = curProb - 8 * self.lumValues[x + 4 + ((y - 1) * self.width)]
				# pixel 5, -1
				if((x + 5 < self.width) and (y - 1 >= 0)):
					curProb = curProb - self.lumValues[x + 5 + ((y - 1) * self.width)]

				# ROW SIX OF FILTER -- CENTER ROW
				# pixel -5, 0
				if(x - 5 >= 0):
					curProb = curProb - 2 * self.lumValues[x - 5 + (y * self.width)]
				# pixel -4, 0
				if(x - 4 >= 0):
					curProb = curProb - 9 * self.lumValues[x - 4 + (y * self.width)]
				# pixel -3, 0
				if(x - 3 >= 0):
					curProb = curProb - 23 * self.lumValues[x - 3 + (y * self.width)]
				# pixel - 2, 0
				if(x - 2 >= 0):
					curProb = curProb - self.lumValues[x - 2 + (y * self.width)]
				# pixel -1, 0
				if(x - 1 >= 0):
					curProb = curProb + 103 * self.lumValues[x - 1 + (y * self.width)]
				# CURRENT PIXEL - CENTER PIXEL OF FILTER
				# pixel 0, 0
				curProb = curProb + 178 * self.lumValues[x + (y * self.width)]
				# pixel 1, 0
				if(x + 1 < self.width):
					curProb = curProb + 103 * self.lumValues[x + 1 + (y * self.width)]
				# pixel 2, 0
				if(x + 2 < self.width):
					curProb = curProb - self.lumValues[x + 2 + (y * self.width)]
				# pixel 3, 0
				if(x + 3 < self.width):
					curProb = curProb - 23 * self.lumValues[x + 3 + (y * self.width)]
				# pixel 4, 0
				if(x + 4 < self.width):
					curProb = curProb - 9 * self.lumValues[x + 4 + (y * self.width)]
				# pixel 5, 0
				if(x + 5 < self.width):
					curProb = curProb - 2 * self.lumValues[x + 5 + (y * self.width)]

				# ROW SEVEN OF FILTER
				# pixel -5, 1
				if((x - 5 >= 0) and (y + 1 < self.height)):
					curProb = curProb - self.lumValues[x - 5 + ((y + 1) * self.width)]
				# pixel -4, 1
				if((x - 4 >= 0) and (y + 1 < self.height)):
					curProb = curProb - 8 * self.lumValues[x - 4 + ((y + 1) * self.width)]
				# pixel -3, 1
				if((x - 3 >= 0) and (y + 1 < self.height)):
					curProb = curProb - 22 * self.lumValues[x - 3 + ((y + 1) * self.width)]
				# pixel -2, 1
				if((x - 2 >= 0) and (y + 1 < self.height)):
					curProb = curProb - 14 * self.lumValues[x - 2 + ((y + 1) * self.width)]
				# pixel -1, 1
				if((x - 1 >= 0) and (y + 1 < self.height)):
					curProb = curProb + 52 * self.lumValues[x - 1 + ((y + 1) * self.width)]
				# pixel 0, 1
				if(y + 1 < self.height):
					curProb = curProb + 103 * self.lumValues[x + ((y + 1) * self.width)]
				# pixel 1, 1
				if((x + 1 < self.width) and (y + 1 < self.height)):
					curProb = curProb + 52 * self.lumValues[x + 1 + ((y + 1) * self.width)]
				# pixel 2, 1
				if((x + 2 < self.width) and (y + 1 < self.height)):
					curProb = curProb - 14 * self.lumValues[x + 2 + ((y + 1) * self.width)]
				# pixel 3, 1
				if((x + 3 < self.width) and (y + 1 < self.height)):
					curProb = curProb - 22 * self.lumValues[x + 3 + ((y + 1) * self.width)]
				# pixel 4, 1
				if((x + 4 < self.width) and (y + 1 < self.height)):
					curProb = curProb - 8 * self.lumValues[x + 4 + ((y + 1) * self.width)]
				# pixel 5, 1
				if((x + 5 < self.width) and (y + 1 < self.height)):
					curProb = curProb - self.lumValues[x + 5 + ((y + 1) * self.width)]

				# ROW EIGHT OF FILTER
				# pixel -5, 2
				if((x - 5 >= 0) and (y + 2 < self.height)):
					curProb = curProb - self.lumValues[x - 5 + ((y + 2) * self.width)]
				# pixel -4, 2
				if((x - 4 >= 0) and (y + 2 < self.height)):
					curProb = curProb - 4 * self.lumValues[x - 4 + ((y + 2) * self.width)]
				# pixel -3, 2
				if((x - 3 >= 0) and (y + 2 < self.height)):
					curProb = curProb - 15 * self.lumValues[x - 3 + ((y + 2) * self.width)]
				# pixel -2, 2
				if((x - 2 >= 0) and (y + 2 < self.height)):
					curProb = curProb - 24 * self.lumValues[x - 2 + ((y + 2) * self.width)]
				# pixel -1, 2
				if((x - 1 >= 0) and (y + 2 < self.height)):
					curProb = curProb - 14 * self.lumValues[x - 1 + ((y + 2) * self.width)]
				# pixel 0, 2
				if(y + 2 < self.height):
					curProb = curProb - self.lumValues[x + ((y + 2) * self.width)]
				# pixel 1, 2
				if((x + 1 < self.width) and (y + 2 < self.height)):
					curProb = curProb - 14 * self.lumValues[x + 1 + ((y + 2) * self.width)]
				# pixel 2, 2
				if((x + 2 < self.width) and (y + 2 < self.height)):
					curProb = curProb - 24 * self.lumValues[x + 2 + ((y + 2) * self.width)]
				# pixel 3, 2
				if((x + 3 < self.width) and (y + 2 < self.height)):
					curProb = curProb - 15 * self.lumValues[x + 3 + ((y + 2) * self.width)]
				# pixel 4, 2
				if((x + 4 < self.width) and (y + 2 < self.height)):
					curProb = curProb - 4 * self.lumValues[x + 4 + ((y + 2) * self.width)]
				# pixel 5, 2
				if((x + 5 < self.width) and (y + 2 < self.height)):
					curProb = curProb - self.lumValues[x + 5 + ((y + 2) * self.width)]

				# ROW NINE OF FILTER
				# pixel -4, 3
				if((x - 4 >= 0) and (y + 3 < self.height)):
					curProb = curProb - 2 * self.lumValues[x - 4 + ((y + 3) * self.width)]
				# pixel -3, 3
				if((x - 3 >= 0) and (y + 3 < self.height)):
					curProb = curProb - 7 * self.lumValues[x - 3 + ((y + 3) * self.width)]
				# pixel -2, 3
				if((x - 2 >= 0) and (y + 3 < self.height)):
					curProb = curProb - 15 * self.lumValues[x - 2 + ((y + 3) * self.width)]
				# pixel -1, 3
				if((x - 1 >= 0) and (y + 3 < self.height)):
					curProb = curProb - 22 * self.lumValues[x - 1 + ((y + 3) * self.width)]
				# pixel 0, 3
				if(y + 3 < self.height):
					curProb = curProb - 23 * self.lumValues[x + ((y + 3) * self.width)]
				# pixel 1, 3
				if((x + 1 < self.width) and (y + 3 < self.height)):
					curProb = curProb - 22 * self.lumValues[x + 1 + ((y + 3) * self.width)]
				# pixel 2, 3
				if((x + 2 < self.width) and (y + 3 < self.height)):
					curProb = curProb - 15 * self.lumValues[x + 2 + ((y + 3) * self.width)]
				# pixel 3, 3
				if((x + 3 < self.width) and (y + 3 < self.height)):
					curProb = curProb - 7 * self.lumValues[x + 3 + ((y + 3) * self.width)]
				# pixel 4, 3
				if((x + 4 < self.width) and ( y + 3 < self.height)):
					curProb = curProb - 2 * self.lumValues[x + 4 + ((y + 3) * self.width)]

				# ROW TEN OF FILTER
				# pixel -3, 4
				if((x - 3 >= 0) and (y + 4 < self.height)):
					curProb = curProb - 2 * self.lumValues[x - 3 + ((y + 4) * self.width)]
				# pixel -2, 4
				if((x - 2 >= 0) and (y + 4 < self.height)):
					curProb = curProb - 4 * self.lumValues[x - 2 + ((y + 4) * self.width)]
				# pixel -1, 4
				if((x - 1 >= 0) and (y + 4 < self.height)):
					curProb = curProb - 8 * self.lumValues[x - 1 + ((y + 4) * self.width)]
				# pixel 0, 4
				if(y + 4 < self.height):
					curProb = curProb - 9 * self.lumValues[x + ((y + 4 ) * self.width)]
				# pixel 1, 4
				if((x + 1 < self.width) and (y + 4 < self.height)):
					curProb = curProb - 8 * self.lumValues[x + 1 + ((y + 4) * self.width)]
				# pixel 2, 4
				if((x + 2 < self.width) and (y + 4 < self.height)):
					curProb = curProb - 4 * self.lumValues[x + 2 + ((y + 4) * self.width)]
				# pixel 3, 4
				if((x + 3 < self.width) and (y + 4 < self.height)):
					curProb = curProb - 2 * self.lumValues[x + 3 + ((y + 4) * self.width)]

				# ROW ELEVEN OF FILTER
				# pixel -2, 5
				if((x - 2 >= 0) and (y + 5 < self.height)):
					curProb = curProb - self.lumValues[x - 2 + ((y + 5) * self.width)]
				# pixel -1, 5
				if((x - 1 >= 0) and (y + 5 < self.height)):
					curProb = curProb - self.lumValues[x - 1 + ((y + 5) * self.width)]
				# pixel 0, 5
				if(y + 5 < self.height):
					curProb = curProb - 2 * self.lumValues[x + ((y + 5) * self.width)]
				# pixel 1, 5
				if((x + 1 < self.width) and (y + 5 < self.height)):
					curProb = curProb - self.lumValues[x + 1 + ((y + 5) * self.width)]
				# pixel 2, 5
				if((x + 2 < self.width) and (y + 5 < self.height)):
					curProb = curProb - self.lumValues[x + 2 + ((y + 5) * self.width)]

												
				# scale the probability from 0 to 100
				curProb = curProb * scale

				# 
				curProb = 100.0 - curProb
				#print "Probability == %f at (%d, %d)" % (curProb, x, y)

				if(curProb < 0.0):
					curProb = 0.0
				if(curProb > 100):
					curProb = 100.0

				# add the probability to the probability list
				self.prob.append(int(curProb))




	# do an analysis of pixels that are near pixels that are almost definately
	# ink pixels.
	# - the probabilities must all ready be set before calling this method
	# - thickens pixels marked with the given percent
	def Thicken(self, percent = 100):
		if(self.prob == None):
			print "Probabilities must be set before this method is invoked."
			return
		print "Analyzing pixels near ink pixels."
		# traverse the height
		for y in range(self.height):
			# traverse the width
			for x in range(self.width):
				# if this pixel has a probability that indicates it is an ink
				# pixel then adjust neighboring pixels according its probability
				if(self.prob[x + (y * self.width)] >= percent):
					if(x + 1 < self.width):
						self.prob[x + 1 + (y * self.width)] = \
							self.prob[x + 1 + (y * self.width)] + 10
					# left neighboring pixel
					if(x - 1 >= 0):
						self.prob[x - 1 + (y * self.width)] = \
							self.prob[x - 1 + (y * self.width)] + 10
					# pixel above this pixel
					if(y - 1 >= 0):
						self.prob[x + ((y - 1) * self.width)] = \
							self.prob[x + ((y - 1) * self.width)] + 10
					# pixel below this pixel
					if(y + 1 < self.height):
						self.prob[x + ((y + 1) * self.width)] = \
							self.prob[x + ((y + 1) * self.width)] + 10
					# right upper pixel
					if((x + 1 < self.width) and (y - 1 >= 0)):
						self.prob[x + 1 + ((y - 1) * self.width)] = \
							self.prob[x + 1 + ((y - 1) *self.width)] + 10
					# right lower pixel
					if((x + 1 < self.width) and (y + 1 < self.height)):
						self.prob[x + 1 + ((y + 1) * self.width)] = \
							self.prob[x + 1 + ((y + 1) * self.width)] + 10
					# left upper pixel
					if((x - 1 >= 0) and (y - 1 >= 0)):
						self.prob[x - 1 + ((y - 1) * self.width)] = \
							self.prob[x - 1 + ((y - 1) * self.width)] + 10
					# left lower pixel
					if((x - 1 >= 0) and (y + 1 < self.height)):
						self.prob[x - 1 + ((y + 1) * self.width)] = \
							self.prob[x - 1 + ((y + 1) * self.width)] + 10


	# remove dots scattered nearby in the text or other areas of the image
	# acording to a probability passed in
	# - must be called after Prob is called
	# - specifically the dots will be surrounded by all background
	def RemoveDots(self, percent = 50):
		if(self.prob == None):
			print "Probabilities must be set before calling this method."
			return
		print "Removing stray dots in image."
		count = 0
		# traverse the height
		for y in range(self.height):
			# traverse the width
			for x in range(self.width):
				# do dot checks only if this pixel is probably ink
				if(self.prob[x + (y * self.width)] >= percent):
					isDot = 1
					# check neighboring pixels, if any surrounding pixel is ink
					# then we don't remove it.  If all surrounding pixels are
					# background, then remove it by setting the probability for 
					# the pixel to zero(backgorund).
					# right neighboring pixel
					if(x + 1 < self.width):
						if(self.prob[x + 1 + (y * self.width)] >= percent):
							isDot = 0
					# left neighboring pixel
					if(x - 1 >= 0):
						if(self.prob[x - 1 + (y * self.width)] >= percent):
							isDot = 0
					# pixel above this pixel
					if(y - 1 >= 0):
						if(self.prob[x + ((y - 1) * self.width)] >= percent):
							isDot = 0
					# pixel below this pixel
					if(y + 1 < self.height):
						if(self.prob[x + ((y + 1) * self.width)] >= percent):
							isDot = 0
					# right upper pixel
					if((x + 1 < self.width) and (y - 1 >= 0)):
						if(self.prob[x + 1 + ((y - 1) * self.width)] >= percent):
							isDot = 0
					# right lower pixel
					if((x + 1 < self.width) and (y + 1 < self.height)):
						if(self.prob[x + 1 + ((y + 1) * self.width)] >= percent):
							isDot = 0
					# left upper pixel
					if((x - 1 >= 0) and (y - 1 >= 0)):
						if(self.prob[x - 1 + ((y - 1) * self.width)] >= percent):
							isDot = 0
					# left lower pixel
					if((x - 1 >= 0) and (y + 1 < self.height)):
						if(self.prob[x - 1 + ((y + 1) * self.width)] >= percent):
							isDot = 0

					# if it is a dot set it to the background color
					if(isDot):
						self.prob[x + (y * self.width)] = 0
						count = count + 1

		print "Removed %d dots from the image." % (count)



	# Set Pixels method that allows the color of the ink and
	# the background to be specified. if colors aren't specified, defaults
	# to black and white.
	# set the pixels in the image according to the probability calculated
	# - if probability for the pixel is >= percent, set pixel to black
	# - if probability for the pixel is <  percent, set pixel to white
	def SetPixels(self, percent = 100, (br, bg, bb) = ( 255, 255, 255)):
		if(self.im == None):
			print "No image currently opened to set pixels in."
			return
		if(self.prob == None):
			print "Must set probabilities before calling this method."
			return
		print "Setting pixels according to calculated probabilities."
		# check to make sure the values are acceptable
		if((br > 255) or (bg > 255) or (bb > 255)):
			print "Color values must be between 0 and 255."
			return
		# traverse the height
		for y in range(self.height):
			# traverse the width
			for x in range(self.width):
				# leave ink pixels with probability greater than percent
				# as original color
				# -----------------
				# write background color with the color specified
				if(self.prob[x + (y * self.width)] < percent):
					self.im.putpixel((x, y), (br, bg, bb))



	# find lines within a sheet of paper
	# - we use the negative of the y values since the origin is inverted
	#   at the top left corner of the image
	# - do not consider pixels with a high luminance
	# - similar to Hough line detection, but skips pixels that are not within the
	#   self.RGB_RANGE of the previous pixel in the line. This allows for detection
	#   of lines that are broken by text or other defects in the sheet (wrinkles, tears, etc)
	# - the while loops for the different types of lines are split so that we can
	#   skip as much useless calculation as possible by skipping portions of the image
	#   where no lines were found along the starting edge
	def FindLines(self):
		if(self.im == None):
			print "No image currently opened to find lines in."
			return
		if(self.lumValues == []):
			print "Must calculate luminance values before calling this method."
			return

		print "Finding lines in opened image."
		# minimum length of the line must be 1/6 of the width
		minWidth = int(float(self.width) / 6.0)
		# minimum height of the line must be 1/6 of the height
		minHeight = int(float(self.height) / 6.0)
		# angle being traversed in line detection
		theta = 0.0
		x = 0
		y = 0

		while(y < self.height):
			x = 0
			while(x < minWidth):
				#print "x is %d" % (x)
				# get the current pixel
				curPixel = self.data[x + (y * self.width)]
				curLum = self.lumValues[x + (y * self.width)]

				# only perform line detection starting from pixels with
				# a luminance less than self.LUM_CUT. this will improve efficiency greatly
				if(curLum < self.LUM_CUT):
					# scan for horizontal lines from horizontal 0 to + 2 degrees
					# a horizontal line across the image
					xdisp = 0
					ydisp = 0
					theta = 0.0
					savedX = x
					savedY = y
					while ((theta <= 2.0) and (savedX + minWidth < self.width)):
						length = 0
						d = 0
						prevPixel = curPixel
						while(d < minWidth):
							xdisp = int(length * cos(pi*theta/180.0))
							ydisp = int(-length * sin(pi*theta/180.0))
							length = length + 1
							if(length > self.width):
								break
							if(savedY + ydisp < 0):
								break
							if(savedX + xdisp >= self.width):
								break
							# acceptable line pixels all are within RGB_RANGE
							# of the previous pixel's RGB values
							linePixel = self.data[savedX + xdisp + ((savedY + ydisp) * \
								self.width)]
							if(self.lumValues[savedX + xdisp + ((savedY + ydisp) * \
								self.width)] >= self.LUM_CUT):
								continue
							if(abs(prevPixel[0] - linePixel[0]) > self.RGB_RANGE or \
							   abs(prevPixel[1] - linePixel[1]) > self.RGB_RANGE or \
							   abs(curPixel[2] - linePixel[2]) > self.RGB_RANGE):
								continue
							# if we have a line with minWidth, store its starting position
							# and its theta
							if(d >= minWidth - 1):
								self.linePos.append((savedX, savedY))
								self.lineTheta.append(theta)
								self.lineStartColor.append(self.im.getpixel((savedX, savedY)))
								self.lineCount = self.lineCount + 1
								# next iteration start at the end of this line segment
								# only do this once
								if(x == savedX):
									x = x + minWidth / 4
								d = minWidth
								break
							prevPixel = linePixel
							d = d + 1
						theta = theta + 0.10
				x = x + 1
			y = y + 1

		x = 0
		y = 0

		while(y < self.height):
			x = 0
			while(x < minWidth):
				# get the current pixel
				curPixel = self.data[x + (y * self.width)]
				curLum = self.lumValues[x + (y * self.width)]
				# only perform line detection starting from pixels with
				# a luminance less than self.LUM_CUT. this will improve efficiency greatly
				if(curLum < self.LUM_CUT):
					# scan for lines with theta values from -0.1 to -2.0
					xdisp = 0
					ydisp = 0
					theta = -0.1
					savedX = x
					savedY = y
					while ((theta >= -2.0) and (savedX + minWidth < self.width)):
						length = 0
						prevPixel = curPixel
						d = 0
						while(d < minWidth):
							xdisp = int(length * cos(pi*theta/180.0))
							ydisp = int(-length * sin(pi*theta/180.0))
							length = length + 1
							#print "ydisp is %f" % (ydisp)
							if(length > self.width):
								break
							if(savedY + ydisp >= self.height):
								break
							if(savedX + xdisp >= self.width):
								break
							# acceptable line pixels all are within RGB_RANGE
							# of the previous pixel's RGB values
							linePixel = self.data[savedX + xdisp + ((savedY + ydisp) * \
								self.width)]
							if(self.lumValues[savedX + xdisp + ((savedY + ydisp) * \
								self.width)] >= self.LUM_CUT):
								continue
							if(abs(prevPixel[0] - linePixel[0]) > self.RGB_RANGE or \
							   abs(prevPixel[1] - linePixel[1]) > self.RGB_RANGE or \
							   abs(prevPixel[2] - linePixel[2]) > self.RGB_RANGE):
								continue
							# if we have a line with minWidth, store its starting position
							# and its theta
							if(d >= minWidth - 1):
								self.linePos.append((savedX, savedY))
								self.lineTheta.append(theta)
								self.lineStartColor.append(self.im.getpixel((savedX, savedY)))
								self.lineCount = self.lineCount + 1
								# next iteration start at the end of this line segment
								# only do this once
								if(x == savedX):
									x = x + minWidth / 4
								break
							prevPixel = linePixel
							d = d + 1
						theta = theta - 0.10
				x = x + 1
			y = y + 1

		x = 0
		y = 0

		while(x < self.width):
			y = 0
			while(y < minHeight):
				# get the current pixel
				curPixel = self.data[x + (y * self.width)]
				curLum = self.lumValues[x + (y * self.width)]

				# only perform line detection starting from pixels with
				# a luminance less than self.LUM_CUT. this will improve efficiency greatly
				if(curLum < self.LUM_CUT):
					xdisp = 0
					ydisp = 0
					theta = -88.0
					savedX = x
					savedY = y
					# scan for vertical lines with theta values -88 to -90
					while ((theta >= -90) and (y + minHeight < self.height)):
						length = 0
						prevPixel = curPixel
						d = 0
						while(d < minHeight):
							xdisp = int(length * cos(pi*theta/180.0))
							ydisp = int(-length * sin(pi*theta/180.0))
							length = length + 1
							if(length > self.height):
								break
							if(savedY + ydisp >= self.height):
								break
							if(savedX + xdisp >= self.width):
								break
							# acceptable line pixels all are within RGB_RANGE
							# of the previous pixel's RGB values
							linePixel = self.data[savedX + xdisp + ((savedY + ydisp) * \
								self.width)]
							if(self.lumValues[savedX + xdisp + ((savedY + ydisp) * \
								self.width)] >= self.LUM_CUT):
								continue
							if(abs(prevPixel[0] - linePixel[0]) > self.RGB_RANGE or \
							   abs(prevPixel[1] - linePixel[1]) > self.RGB_RANGE or \
							   abs(prevPixel[2] - linePixel[2]) > self.RGB_RANGE):
								continue
							# if we have a line with minHeight, store its starting position
							# and its theta
							if(d >= minHeight - 1):
								self.linePos.append((savedX, savedY))
								self.lineTheta.append(theta)
								self.lineStartColor.append(self.im.getpixel((savedX, savedY)))
								self.lineCount = self.lineCount + 1
								# next iteration start at the end of this line segment
								# only do this once
								if(y == savedY):
									y = y + minHeight / 4
								break
							d = d + 1
							prevPixel = curPixel
						theta = theta - 0.10
				y = y + 1
			x = x + 1

		x = 0
		y = 0

		while(x < self.width):
			y = 0
			while(y < minHeight):
				# get the current pixel
				curPixel = self.data[x + (y * self.width)]
				curLum = self.lumValues[x + (y * self.width)]

				# only perform line detection starting from pixels with
				# a luminance less than self.LUM_CUT. this will improve efficiency greatly
				if(curLum < self.LUM_CUT):
					xdisp = 0
					ydisp = 0
					theta = -90.1
					savedX = x
					savedY = y
					# scan for vertical lines with theta values -90.1 to -92
					while ((theta >= -92.0) and (savedY + minHeight < self.height)):
						length = 0
						prevPixel = curPixel
						d = 0
						while(d < minHeight):
							xdisp = int(d * cos(pi*theta/180.0))
							ydisp = int(-d * sin(pi*theta/180.0))
							length = length + 1
							if(length > self.height):
								break
							if(savedY + ydisp >= self.height):
								break
							if(savedX + xdisp < 0):
								break
							# acceptable line pixels all are within RGB_RANGE
							# of the previous pixel's RGB values
							linePixel = self.data[savedX + xdisp + ((savedY + ydisp) * \
								self.width)]
							if(self.lumValues[savedX + xdisp + ((savedY + ydisp) * \
								self.width)] >= self.LUM_CUT):
								continue
							if(abs(prevPixel[0] - linePixel[0]) > self.RGB_RANGE or \
							   abs(prevPixel[1] - linePixel[1]) > self.RGB_RANGE or \
							   abs(prevPixel[2] - linePixel[2]) > self.RGB_RANGE):
								continue
							# if we have a line with minHeight, store its starting position
							# and its theta
							if(d >= minHeight - 1):
								self.linePos.append((savedX, savedY))
								self.lineTheta.append(theta)
								self.lineStartColor.append(self.im.getpixel((savedX, savedY)))
								self.lineCount = self.lineCount + 1
								# next iteration start at the end of this line segment
								# only do this once
								if(y == savedY):
									y = y + minHeight / 4
								break
							prevPixel = curPixel
							d = d + 1
						theta = theta - 0.10
				y = y + 1
			x = x + 1



	# remove the lines from the image by setting all line pixels to white.
	# - use the previously calculated line positions and theta values from FindLines
	#   to traverse and erase lines across the image
	# - store the previous line pixels values to compare RGB components to the
	#   the next pixel along this line.  If one doesn't match, skip over it, and
	#   compare the next pixel along the line with the kept value of the prev pixel
	# - compare neighboring pixels along the line too, to see if their RGB values
	#   are within the specified range of RGB values
	# - set all qualifying pixels to white
	def RemoveLines(self):
		if(self.linePos == []):
			print "No lines to remove."
		else:
			print "Removing previously found lines."
			# repeat for all lines previously found
			for count in range(self.lineCount):
				curPos = self.linePos[count]
				x = curPos[0]
				y = curPos[1]
				d = 0

				while(1):
					# initialize the starting pixel of this line
					if(d == 0):
						#startPixel = self.data[x + (y * self.width)]
						startPixel = self.lineStartColor[count]
						prevPixel = startPixel
					xdisp = int(d * cos(pi * self.lineTheta[count] / 180.0))
					ydisp = int(-d * sin(pi * self.lineTheta[count] / 180.0))
					curX = x + xdisp
					curY = y + ydisp
					# make sure we have a valid pixel position	
					if((curY < self.height) and (curY >= 0) and \
						(curX >= 0) and (curX < self.width)):
						# if within the specified starting RGB range, set pixel
						# to white (background)

						curPixel = self.data[curX + (curY * self.width)]
						# check to see if the current line pixel is part of the line
						#if(self.lumValues[curX + (curY * self.width)] <= 100):
						#	d = d + 1
						#	continue
						#elif(self.lumValues[curX + (curY * self.width)] > self.LUM_CUT):
						#	d = d + 1
						#	continue
						if((abs(prevPixel[0] - curPixel[0]) <= self.RGB_RANGE) and \
							(abs(prevPixel[1] - curPixel[1]) <= self.RGB_RANGE) and \
							(abs(prevPixel[2] - curPixel[2]) <= self.RGB_RANGE)):
							self.im.putpixel((curX, curY), (255, 255, 255))
							curLinePixel = curPixel
						else:
							d = d + 1
							continue

						#######################################################
						# set neighboring pixels to white if within RGB range #
						#######################################################

						# top left neighboring pixel (-1, -1)
						if((curY - 1 < self.height) and (curY - 1 >= 0) and\
							(curX - 1 >= 0) and (curX - 1 < self.width)):
							curPixel = self.data[curX - 1 + ((curY - 1) * self.width)]
							if((abs(prevPixel[0] - curPixel[0]) <= self.RGB_RANGE) and \
								(abs(prevPixel[1] - curPixel[1]) <= self.RGB_RANGE) and \
								(abs(prevPixel[2] - curPixel[2]) <= self.RGB_RANGE)):
								self.im.putpixel((curX - 1, curY - 1), (255, 255, 255))

						# top neighboring pixel (0, -1)
						if((curY - 1 < self.height) and (curY - 1 >= 0)):
							curPixel = self.data[curX + ((curY - 1) * self.width)]
							if((abs(prevPixel[0] - curPixel[0]) <= self.RGB_RANGE) and \
								(abs(prevPixel[1] - curPixel[1]) <= self.RGB_RANGE) and \
								(abs(prevPixel[2] - curPixel[2]) <= self.RGB_RANGE)):
								self.im.putpixel((curX, curY - 1), (255, 255, 255))

						# top right neighboring pixel (+1, -1)
						if((curY - 1 < self.height) and (curY - 1 >= 0) and\
							(curX + 1 >= 0) and (curX + 1 < self.width)):
							curPixel = self.data[curX + 1 + ((curY - 1) * self.width)]
							if((abs(prevPixel[0] - curPixel[0]) <= self.RGB_RANGE) and \
								(abs(prevPixel[1] - curPixel[1]) <= self.RGB_RANGE) and \
								(abs(prevPixel[2] - curPixel[2]) <= self.RGB_RANGE)):
								self.im.putpixel((curX + 1, curY - 1), (255, 255, 255))

						# left neighboring pixel (-1, 0)
						if((curX - 1 >= 0) and (curX - 1 < self.width)):
							curPixel = self.data[curX - 1 + (curY * self.width)]
							if((abs(prevPixel[0] - curPixel[0]) <= self.RGB_RANGE) and \
								(abs(prevPixel[1] - curPixel[1]) <= self.RGB_RANGE) and \
								(abs(prevPixel[2] - curPixel[2]) <= self.RGB_RANGE)):
								self.im.putpixel((curX - 1, curY), (255, 255, 255))

						# right neighboring pixel (+1, 0)
						# only set right pixel to white when removing vertical lines
						if((curX + 1 >= 0) and (curX + 1 < self.width) and \
							(self.lineTheta[count] < -5)):
							curPixel = self.data[curX + 1 + (curY * self.width)]
							if((abs(prevPixel[0] - curPixel[0]) <= self.RGB_RANGE) and \
								(abs(prevPixel[1] - curPixel[1]) <= self.RGB_RANGE) and \
								(abs(prevPixel[2] - curPixel[2]) <= self.RGB_RANGE)):
								self.im.putpixel((curX + 1, curY), (255, 255, 255))

						# lower left neighboring pixel (-1, +1)
						if((curY + 1 < self.height) and (curY + 1 >= 0) and\
							(curX - 1 >= 0) and (curX - 1 < self.width)):
							curPixel = self.data[curX - 1 + ((curY + 1) * self.width)]
							if((abs(prevPixel[0] - curPixel[0]) <= self.RGB_RANGE) and \
								(abs(prevPixel[1] - curPixel[1]) <= self.RGB_RANGE) and \
								(abs(prevPixel[2] - curPixel[2]) <= self.RGB_RANGE)):
								self.im.putpixel((curX - 1, curY + 1), (255, 255, 255))

						# lower neighboring pixel (0, +1)
						# only set lower pixel to white when removing horizontally
						if((curY + 1 < self.height) and (curY + 1 >= 0) and \
							(self.lineTheta[count] > -5)):
							curPixel = self.data[curX + ((curY + 1) * self.width)]
							if((abs(prevPixel[0] - curPixel[0]) <= self.RGB_RANGE) and \
								(abs(prevPixel[1] - curPixel[1]) <= self.RGB_RANGE) and \
								(abs(prevPixel[2] - curPixel[2]) <= self.RGB_RANGE)):
								self.im.putpixel((curX, curY + 1), (255, 255, 255))

						# right lower neighboring pixel (+1, +1)
						if((curY + 1 < self.height) and (curY + 1 >= 0) and\
							(curX + 1 >= 0) and (curX + 1 < self.width)):
							curPixel = self.data[curX + 1 + ((curY + 1) * self.width)]
							if((abs(prevPixel[0] - curPixel[0]) <= self.RGB_RANGE) and \
								(abs(prevPixel[1] - curPixel[1]) <= self.RGB_RANGE) and \
								(abs(prevPixel[2] - curPixel[2]) <= self.RGB_RANGE)):
								self.im.putpixel((curX + 1, curY + 1), (255, 255, 255))

						# two pixels down (0, +2)
						# only remove two pixels down when removing horizontally
						if((curY + 2 < self.height) and (curY + 2 >= 0) and \
							(self.lineTheta[count] > -5)):
							curPixel = self.data[curX + ((curY + 2) * self.width)]
							if((abs(prevPixel[0] - curPixel[0]) <= self.RGB_RANGE) and \
								(abs(prevPixel[1] - curPixel[1]) <= self.RGB_RANGE) and \
								(abs(prevPixel[2] - curPixel[2]) <= self.RGB_RANGE)):
								self.im.putpixel((curX, curY + 2), (255, 255, 255))

						# two pixels up (0, -2)
						# only remove two pixels up when removing horizontally
						if((curY - 2 < self.height) and (curY - 2 >= 0) and \
							(self.lineTheta[count] > -5)):
							curPixel = self.data[curX + ((curY - 2) * self.width)]
							if((abs(prevPixel[0] - curPixel[0]) <= self.RGB_RANGE) and \
								(abs(prevPixel[1] - curPixel[1]) <= self.RGB_RANGE) and \
								(abs(prevPixel[2] - curPixel[2]) <= self.RGB_RANGE)):
								self.im.putpixel((curX, curY - 2), (255, 255, 255))

						# two pixels left (-2, 0)
						# only remove two pixels left when removing vertically
						if((curX - 2 >= 0) and (curX - 2 < self.width) and \
							(self.lineTheta[count] < -5)):
							curPixel = self.data[curX - 2 + (curY * self.width)]
							if((abs(prevPixel[0] - curPixel[0]) <= self.RGB_RANGE) and \
								(abs(prevPixel[1] - curPixel[1]) <= self.RGB_RANGE) and \
								(abs(prevPixel[2] - curPixel[2]) <= self.RGB_RANGE)):
								self.im.putpixel((curX - 2, curY), (255, 255, 255))

						# two pixels right (+2, 0)
						# only remove two pixels right when removing vertically
						if((curX + 2 >= 0) and (curX + 2 < self.width) and \
							(self.lineTheta[count] < -5)):
							curPixel = self.data[curX + 2 + (curY * self.width)]
							if((abs(prevPixel[0] - curPixel[0]) <= self.RGB_RANGE) and \
								(abs(prevPixel[1] - curPixel[1]) <= self.RGB_RANGE) and \
								(abs(prevPixel[2] - curPixel[2]) <= self.RGB_RANGE)):
								self.im.putpixel((curX + 2, curY), (255, 255, 255))

					else:
						break

					prevPixel = curLinePixel
					d = d + 1



	# create a new white image larger than this image.
	# copy current image into the new white image.
	# rotate.
	# crop out region of new image from position matching original image
	# paste back into original image - self.im
	def Straighten(self):
		if(self.im == None):
			print "No image opened to straighten."
			return
		if(self.lineTheta == []):
			print "Must find lines before calling this method."
			return

		# create the new image - all white
		temp = Image.new("RGB", (self.width + 200, self.height + 200), (255, 255, 255))
		# paste in the opened image
		temp.paste(self.im, (100, 100))

		# do rotation, by averaging all line theta values
		sum = 0.0
		rotationTheta = 0.0
		for i in range(self.lineCount):
			curTheta = self.lineTheta[i]
			if(curTheta < 0.0):
				curTheta = curTheta + 90.0
			sum = sum + curTheta
		rotationTheta = int(sum / self.lineCount)
		#rotationTheta = -rotationTheta

		print "Rotating image by %d degree(s)." % (rotationTheta)

		# straighten the image - rotate temporary image
		temp.rotate(rotationTheta)

		# copy out image data from temporary image
		region = temp.crop((100, 100, self.width + 100, self.height + 100))

		# paste rotated region back into self.im image
		self.im.paste(region, None)



	# calculates the luminance for every pixel in the image and builds
	# the global list lumValues
	def CalculateLuminance(self):
		# calculate luminance values for all pixels in the image
		# luminance = .299*R + .587*G + .114*B
		if(self.lumValues == []):
			print "Calculating luminance values."
			for y in range(self.height):
				for x in range(self.width):
					curPixel = self.data[x + (y * self.width)]
					self.lumValues.append(float(0.299 * float(curPixel[0]) + \
						0.587 * float(curPixel[1]) + 0.114 * float(curPixel[2])))
					if(self.lumValues[x + (y * self.width)] > 255.0):
						self.lumValues[x + (y * self.width)] = 255.0
					elif(self.lumValues[x + (y * self.width)] < 0.0):
						self.lumValues[x + (y * self.width)] = 0.0
					
					#if(self.lumValues[x + y * self.width] < 150):
					#	print "%f" % (self.lumValues[x + y * self.width])



	# set the background to white or to br, bg, bb according to their red/green
	# and green/blue values
	def SetBackground(self, RG = 200, GB = 200, (br, bg, bb) = (255, 255, 255)):
		if(self.im == None):
			print "No image currently opened to set background in."
			return
		print "Setting background based on R/G and G/B values."

		# traverse the height
		for y in range(self.height):
			# traverse the width
			for x in range(self.width):
				#if(self.lumValues[x + (y * self.width)] > 200.0):
				#	self.im.putpixel((x, y), (br, bg, bb))
				curPixel = self.data[x + (y * self.width)]
				if((curPixel[0] > RG) and (curPixel[1] > RG)):
					self.im.putpixel((x, y), (br, bg, bb))
				elif((curPixel[1] > GB) and (curPixel[2] > GB)):
					self.im.putpixel((x, y), (br, bg, bb))



	# use the NoteModule to clean the background and halve the image size
	def ApplyNoteModule(self):
		if(self.im == None):
			print "No image currently opened to process."
			return

		# create the new image - all white and half the size of the original image
		temp = Image.new("RGB", (int(float(self.width) / 2.0), int(float(self.height) / 2.0)), \
			(255, 255, 255))
		# set the initial parameters in the NoteModule
		# set the width and height for the input and output images
		notemodule.cvar.width = self.width
		notemodule.cvar.height = self.height
		notemodule.cvar.outWidth = temp.size[0]
		notemodule.cvar.outHeight = temp.size[1]
		# allocate dynamic memory
		notemodule.CreateArrays()

		# store the image data to the notemodule
		notemodule.SetData(self.im.tostring())

		# perform necessary background clearing and resizing operations
		print "Applying note module calculations."
		notemodule.Calculate()

		# retrieve the new data and set as the current image
		temp = Image.fromstring("RGB", temp.size, notemodule.GetData())

		# sharpen the image one time
		# note - successive sharpens increase quality of most pixels, but
		# also cause a fair amount of loss of ink pixel data
		temp = temp.filter(ImageFilter.SHARPEN)

		# set the right and bottom edges and right edges to white, since
		# sometimes they come out gray
		# this is due to another problem with PIL's tostring / fromstring methods
		# bottom edge
		for i in range(temp.size[0]):
			temp.putpixel((i, temp.size[1] - 1), (255, 255, 255))
			#temp.putpixel((i, temp.size[1] - 2), (255, 255, 255))
		# right edge
		for i in range(temp.size[1]):
			temp.putpixel((temp.size[0] - 1, i), (255, 255, 255))
			#temp.putpixel((temp.size[0] - 2, i), (255, 255, 255))

		# store the new image as self.im
		self.im = temp


	# used to make more printable images
	# must be called after ApplyNoteModule
	def MakePrintable(self):
		if(self.im == None):
			print "No image opened to modify."
			return

		print "Modifying image for printing."
		# darken ink pixels, and anti-aliased ink pixels
		notemodule.Flatten()

		# remove the few noise pixels from the image, up to two noise pixels
		# within the specified area
		notemodule.RemoveNoise(2)

		# retrieve the image data and build a new image
		self.im = Image.fromstring("RGB", self.im.size, notemodule.GetData())

		# set the right and bottom edges and right edges to white, since sometimes
		# they come out gray
		# this is due to another problem with PIL's tostring / fromstring methods
		# bottom edge
		for i in range(self.im.size[0]):
			self.im.putpixel((i, self.im.size[1] - 1), (255, 255, 255))
			#self.im.putpixel((i, self.im.size[1] - 2), (255, 255, 255))
		# right edge
		for i in range(self.im.size[1]):
			self.im.putpixel((self.im.size[0] - 1, i), (255, 255, 255))
			#self.im.putpixel((self.im.size[0] - 2, i), (255, 255, 255))

		# free up dynamic memory in the note module
		notemodule.Cleanup()



	# DEBUGGING METHODS

	# dump values from low to high if specified
	# otherwise, dump the first twenty values
	def DumpProb(self, low = 0, high = 19):
		if(self.prob == None):
			print "Prob must be called before calling this method."
			return
		while(low < high):
			print "%i" % (self.prob[low])
			low = low + 1


	# see how long it takes to do a get pixel on each pixel in the image
	# get pixel seems rather slow
	def TestGetPixel(self):
		if(self.im == None):
			print "No image opened to test getpixel method."
			return

		print "Starting test of getpixel."

		for y in range(self.height):
			# traverse the width
			for x in range(self.width):
				x = self.im.getpixel((x,y))

		print "Completed test of getpixel."


	# see how long it takes to do an assignment from self.data for each 
	# pixel in the image
	def TestData(self):
		if((self.data == None) or (self.im == None)):
			print "No image opened to test on."
			return
		for y in range(self.height):
			for x in range(self.width):
				junk = self.data[x + (y * self.width)]


# test script to display an image
#x = Note()
#x.open("notes2.jpg")
#x.Prob()
#x.RemoveDots(80)
#x.SetPixels(80)
#x.save("out80Notes2.jpg")
#x.display()