/*
    Craig R. Farrand
    Computer Science 699
    notemodule.h

    IMPORTANT - Any changes made to function declarations, function arguments, or
                global variables require that the SWIG interface file be remade
                and its _wrap.c file be re-compiled.  This is easily done by completely
                rebuilding the entire project, since this will force SWIG to rewrite the
                _wrap.c file, and visual studio will recompile it into the dll.  All of
                the errors that I've encountered while working on this project in the 
                _wrap.c file can be fixed by doing this.
*/


#ifndef _NOTEMODULE_H_
#define _NOTEMODULE_H_

/* constants */
#define RED     0
#define GREEN   1
#define BLUE    2
#define BACKGROUND_CUT  200

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
        
/* VARIABLES */
int pos;
/* width and height of the input image */
int width;
int height;
/* width and height of the output image */
int outWidth;
int outHeight;
/* the string used to retrieve data from python and return it back when
   we are finished processing it */
unsigned char *data;
/* color data for the input image */
unsigned char *red;
unsigned char *green;
unsigned char *blue;
/* color data for the output image */
unsigned char *outRed;
unsigned char *outGreen;
unsigned char *outBlue;
/* color range variables */
unsigned char redInkMax;
unsigned char redInkMin;
unsigned char redInkRange;
unsigned char greenInkMax;
unsigned char greenInkMin;
unsigned char greenInkRange;
unsigned char blueInkMax;
unsigned char blueInkMin;
unsigned char blueInkRange;
/* arrays of the RGB values of the pixels being examined */
unsigned char leftPixel[3];
unsigned char centerPixel[3];
unsigned char rightPixel[3];
unsigned char topPixel[3];
unsigned char bottomPixel[3];
unsigned char topLeftPixel[3];
unsigned char topRightPixel[3];
unsigned char bottomLeftPixel[3];
unsigned char bottomRightPixel[3];


/* METHODS */
/* python conversion methods */
char* GetData(void);
void SetData(char* str);
/* allocate memory for all the color data arrays */
void CreateArrays(void);
/* set the pixel data from the input image */
void SetPixelData(unsigned char r, unsigned char g, unsigned char b, int i);
/* perform all necessary resizing, background clearing, and color changing */
void Calculate(void);
/* cleanup any dynamic memory */
void Cleanup(void);
/* set the colors according to the output image RGB values */
void SetColors(void);
/* calculate a range for the ink colors */
void CalculateColorRange(void);
/* standardize the ink colors */
int StandardizeColors(unsigned char value, int color);
/* flatten all ink colors to zero */
void Flatten(void);
/* remove noise from the image - stray dots, etc. */
void RemoveNoise(int numPixels);

/* resizing filters */
void CenterFilter(void);
void AverageFilter(void);
void BSplineFilter(void);


/* methods to set the pixel data for the filters */
void SetLeftPixel(unsigned char r, unsigned char g, unsigned char b);
void SetCenterPixel(unsigned char r, unsigned char g, unsigned char b);
void SetRightPixel(unsigned char r, unsigned char g, unsigned char b);
void SetTopPixel(unsigned char r, unsigned char g, unsigned char b);
void SetBottomPixel(unsigned char r, unsigned char g, unsigned char b);
void SetTopLeftPixel(unsigned char r, unsigned char g, unsigned char b);
void SetTopRightPixel(unsigned char r, unsigned char g, unsigned char b);
void SetBottomLeftPixel(unsigned char r, unsigned char g, unsigned char b);
void SetBottomRightPixel(unsigned char r, unsigned char g, unsigned char b);
/* methods to retrieve the calculated RGB values from the given input pixel data */
unsigned char GetRed(int i);
unsigned char GetGreen(int i);
unsigned char GetBlue(int i);

/* debug methods */
void dump(void);



#endif _NOTEMODULE_H_