/*
    Craig R. Farrand
    Computer Science 699
    notemodule.cpp
*/

#include "notemodule.h"


/* set the RGB values of the left pixel */
void SetLeftPixel(unsigned char r, unsigned char g, unsigned char b)
{
    leftPixel[0] = r;
    leftPixel[1] = g;
    leftPixel[2] = b;
}


/* set the RGB values of the center pixel */
void SetCenterPixel(unsigned char r, unsigned char g, unsigned char b)
{
    centerPixel[0] = r;
    centerPixel[1] = g;
    centerPixel[2] = b;
}


/* set the RGB values of the right pixel */
void SetRightPixel(unsigned char r, unsigned char g, unsigned char b)
{
    rightPixel[0] = r;
    rightPixel[1] = g;
    rightPixel[2] = b;
}


/* set the RGB values of the top pixel */
void SetTopPixel(unsigned char r, unsigned char g, unsigned char b)
{
    topPixel[0] = r;
    topPixel[1] = g;
    topPixel[2] = b;
}


/* set the RGB values of the bottom pixel */
void SetBottomPixel(unsigned char r, unsigned char g, unsigned char b)
{
    bottomPixel[0] = r;
    bottomPixel[1] = g;
    bottomPixel[2] = b;
}


/* set the RGB values of the top left pixel */
void SetTopLeftPixel(unsigned char r, unsigned char g, unsigned char b)
{
    topLeftPixel[0] = r;
    topLeftPixel[1] = g;
    topLeftPixel[2] = b;
}


/* set the RGB values of the top right pixel */
void SetTopRightPixel(unsigned char r, unsigned char g, unsigned char b)
{
    topRightPixel[0] = r;
    topRightPixel[1] = g;
    topRightPixel[2] = b;
}


/* set the RGB values of the top left pixel */
void SetBottomLeftPixel(unsigned char r, unsigned char g, unsigned char b)
{
    bottomLeftPixel[0] = r;
    bottomLeftPixel[1] = g;
    bottomLeftPixel[2] = b;
}


/* set the RGB values of the bottom right pixel */
void SetBottomRightPixel(unsigned char r, unsigned char g, unsigned char b)
{
    bottomRightPixel[0] = r;
    bottomRightPixel[1] = g;
    bottomRightPixel[2] = b;
}


/* allocate memory for the color data of the input image and also for the
   output color data we're creating */
void CreateArrays(void)
{
    red = malloc(width * height);
    green = malloc(width * height);
    blue = malloc(width * height);

    outRed = malloc(outWidth * outHeight);
    outGreen = malloc(outWidth * outHeight);
    outBlue = malloc(outWidth * outHeight);

    /* create the array for storing the PIL tostring data */
    data = malloc((width * height * 3) + 1);
    /* set null terminator */
    data[width * height * 3] = '\0';
}


/* return the outRed, outGreen, and outBlue data in a python string */
char* GetData(void)
{
	int i = 0, j = 0;

    /* copy the outRed, outGreen, and outBlue data to the data array
       make sure that we don't have any zeros in the data array, otherwise
       PIL will crash */
	for(i =0; i < outWidth * outHeight; i++)
	{
        if(outRed[i] > 0)
    		data[j] = outRed[i];
        else
            data[j] = 1;

        if(outGreen[i] > 0)
            data[j + 1] = outGreen[i];
        else
            data[j + 1] = 1;

        if(outBlue[i] > 0)
            data[j + 2] = outBlue[i];
        else
            data[j + 2] = 1;

        j += 3;
	}

    return data;
}


/* set the red, green, and blue arrays from the PIL data string */
void SetData(char* str)
{
    int i = 0, j = 0;

    /* set the red, green, and blue arrays from the data 
       also copy the str to our data array */
    for(i = 0; i < width * height; i++)
    {
        red[i] = str[j];
        green[i] = str[j + 1];
        blue[i] = str[j + 2];
        data[i] = str[i];
        j += 3;
    }
}



/* fill in the red, green, and blue arrays with the input color data 
   this function is obsolete */
void SetPixelData(unsigned char r, unsigned char g, unsigned char b, int i)
{
    red[i] = r;
    green[i] = g;
    blue[i] = b;
}


/* perform all necessary calculations to resize the image, modify colors, and
   clean out the background */
void Calculate(void)
{
    int x = 0, y = 0, lineCount = 0, i = 0;

    pos = 0;

    /* set the background colors to white before resizing the image 
       RED   and GREEN > BACKGROUND_CUT  or
       GREEN and BLUE  > BACKGROUND_CUT          */
    for(y = 0; y < height; y++)
    {
        for(x = 0; x < width; x++)
        {
            i = x + y * width;
            if((red[i] > BACKGROUND_CUT) && (green[i] > BACKGROUND_CUT))
            {
                red[i] = 255;
                green[i] = 255;
                blue[i] = 255;
            }
            else if((green[i] > BACKGROUND_CUT) && (blue[i] > BACKGROUND_CUT))
            {
                red[i] = 255;
                green[i] = 255;
                blue[i] = 255;
            }
        }
    }

    /* traverse the width and height of the image two pixels at a time */
    /* and set the nearby pixel values */
    for(y = 1; y < height - 1; y = y + 2)
    {
        for(x = 1; x < width - 1; x = x + 2)
        {
			/* center pixel */
			centerPixel[RED] = red[x + (y * width)];
            centerPixel[GREEN] = green[x + (y * width)];
            centerPixel[BLUE] = blue[x + (y * width)];

			/* left pixel */
			leftPixel[RED] = red[x - 1 + (y * width)];
            leftPixel[GREEN] = green[x - 1 + (y * width)];
            leftPixel[BLUE] = blue[x - 1 + (y * width)];

			/* right pixel */
			rightPixel[RED] = red[x + 1 + (y * width)];
			rightPixel[GREEN] = green[x + 1 + (y * width)];
			rightPixel[BLUE] = blue[x + 1 + (y * width)];

			/* top pixel */
			topPixel[RED] = red[x + ((y - 1) * width)];
			topPixel[GREEN] = green[x + ((y - 1) * width)];
			topPixel[BLUE] = blue[x + ((y - 1) * width)];

			/* bottom pixel */
			bottomPixel[RED] = red[x + ((y + 1) * width)];
			bottomPixel[GREEN] = green[x + ((y + 1) * width)];
			bottomPixel[BLUE] = blue[x + ((y + 1) * width)];

			/* top left pixel */
		    topLeftPixel[RED] = red[x - 1 + ((y - 1) * width)];
		    topLeftPixel[GREEN] = green[x - 1 + ((y - 1) * width)];
		    topLeftPixel[BLUE] = blue[x - 1 + ((y - 1) * width)];

			/* top right pixel */
			topRightPixel[RED] = red[x + 1 + ((y - 1) * width)];
			topRightPixel[GREEN] = green[x + 1 + ((y - 1) * width)];
			topRightPixel[BLUE] = blue[x + 1 + ((y - 1) * width)];

			/* bottom left pixel */
			bottomLeftPixel[RED] = red[x - 1 + ((y + 1) * width)];
			bottomLeftPixel[GREEN] = green[x - 1 + ((y + 1) * width)];
			bottomLeftPixel[BLUE] = blue[x - 1 + ((y + 1) * width)];

			/* bottom right pixel */
			bottomRightPixel[RED] = red[x + 1 + ((y + 1) * width)];
			bottomRightPixel[GREEN] = green[x + 1 + ((y + 1) * width)];
			bottomRightPixel[BLUE] = blue[x + 1 + ((y + 1) * width)];

            /* call the filter function we want to use to resize the image */
            /* CenterFilter(); */
            /* AverageFilter(); */
            BSplineFilter();

            pos++;
        } /* end traversing width for loop */
        /* we're at the end of the line in the input image, adjust pos so that
           we don't get screwy output with input images of even width */
        lineCount++;
        pos = lineCount * outWidth;
    } /* end traversing height for loop */

    /*RemoveNoise(); */
}


/* remove noise from the image, such as stray dots, etc. 
   - look at a 5 by 7 (5 wide, 7 high) pixel area
   - if there is more than numPixels that might be ink in this area,
     then we don't set the current pixel to background (consider as ink)
   - otherwise, set the current pixel to background, considered as noise
   - a value of 1 works well, with VERY little loss of ink data
   - a value of 2 cleans out noise almost entirely, but there is a bit more
     loss of actual ink data 
   - the major loss in ink data with this algorithm, is the dots on the i's.
     this is due to the fact that after resizing, the dots on i's are usually
     one or two pixels and are seperated from other nearby ink pixels */
void RemoveNoise(int numPixels)
{
    int y = 0, x = 0, noisePixels = 0, i = 0;

    /* move the area of consideration down the image in half blocks */
    for(y = 0; y < outHeight; y = y + 7)
    {
        for(x = 0; x < outWidth; x++)
        {
            noisePixels = 0;

            /* three rows up */
            if((y - 3) > 0)
            {
                /* two columns left */
                if((x - 2) > 0)
                {
                    if((outRed[x - 2 + ((y - 3) * outWidth)] < BACKGROUND_CUT) &&
                       (outGreen[x - 2 + ((y - 3) * outWidth)] < BACKGROUND_CUT) ||
                       ((outGreen[x - 2 + ((y - 3) * outWidth)] < BACKGROUND_CUT) &&
                       (outBlue[x - 2 + ((y - 3) * outWidth)] < BACKGROUND_CUT)))
                        noisePixels++;
                }
                /* one column left */
                if((x - 1) > 0)
                {
                    if((outRed[x - 1 + ((y - 3) * outWidth)] < BACKGROUND_CUT) &&
                       (outGreen[x - 1 + ((y - 3) * outWidth)] < BACKGROUND_CUT) ||
                       ((outGreen[x - 1 + ((y - 3) * outWidth)] < BACKGROUND_CUT) &&
                       (outBlue[x - 1 + ((y - 3) * outWidth)] < BACKGROUND_CUT)))
                        noisePixels++;
                }

                /* current column */
                if((outRed[x + ((y - 3) * outWidth)] < BACKGROUND_CUT) &&
                   (outGreen[x + ((y - 3) * outWidth)] < BACKGROUND_CUT) ||
                   ((outGreen[x + ((y - 3) * outWidth)] < BACKGROUND_CUT) &&
                   (outBlue[x + ((y - 3) * outWidth)] < BACKGROUND_CUT)))
                    noisePixels++;

                /* one column right */
                if((x + 1) < outWidth)
                {
                    if((outRed[x + 1 + ((y - 3) * outWidth)] < BACKGROUND_CUT) &&
                       (outGreen[x + 1 + ((y - 3) * outWidth)] < BACKGROUND_CUT) ||
                       ((outGreen[x + 1 + ((y - 3) * outWidth)] < BACKGROUND_CUT) &&
                       (outBlue[x + 1 + ((y - 3) * outWidth)] < BACKGROUND_CUT)))
                        noisePixels++;
                }
                /* two columns right */
                if((x + 2) < outWidth)
                {
                    if((outRed[x + 2 + ((y - 3) * outWidth)] < BACKGROUND_CUT) &&
                       (outGreen[x + 2 + ((y - 3) * outWidth)] < BACKGROUND_CUT) ||
                       ((outGreen[x + 2 + ((y - 3) * outWidth)] < BACKGROUND_CUT) &&
                       (outBlue[x + 2 + ((y - 3) * outWidth)] < BACKGROUND_CUT)))
                        noisePixels++;
                }
            } /* three rows up */

            /* two rows up */
            if((y - 2) > 0)
            {
                /* two columns left */
                if((x - 2) > 0)
                {
                    if((outRed[x - 2 + ((y - 2) * outWidth)] < BACKGROUND_CUT) &&
                       (outGreen[x - 2 + ((y - 2) * outWidth)] < BACKGROUND_CUT) ||
                       ((outGreen[x - 2 + ((y - 2) * outWidth)] < BACKGROUND_CUT) &&
                       (outBlue[x - 2 + ((y - 2) * outWidth)] < BACKGROUND_CUT)))
                        noisePixels++;
                }
                /* one column left */
                if((x - 1) > 0)
                {
                    if((outRed[x - 1 + ((y - 2) * outWidth)] < BACKGROUND_CUT) &&
                       (outGreen[x - 1 + ((y - 2) * outWidth)] < BACKGROUND_CUT) ||
                       ((outGreen[x - 1 + ((y - 2) * outWidth)] < BACKGROUND_CUT) &&
                       (outBlue[x - 1 + ((y - 2) * outWidth)] < BACKGROUND_CUT)))
                        noisePixels++;
                }

                /* current column */
                if((outRed[x + ((y - 2) * outWidth)] < BACKGROUND_CUT) &&
                   (outGreen[x + ((y - 2) * outWidth)] < BACKGROUND_CUT) ||
                   ((outGreen[x + ((y - 2) * outWidth)] < BACKGROUND_CUT) &&
                   (outBlue[x + ((y - 2) * outWidth)] < BACKGROUND_CUT)))
                    noisePixels++;

                /* one column right */
                if((x + 1) < outWidth)
                {
                    if((outRed[x + 1 + ((y - 2) * outWidth)] < BACKGROUND_CUT) &&
                       (outGreen[x + 1 + ((y - 2) * outWidth)] < BACKGROUND_CUT) ||
                       ((outGreen[x + 1 + ((y - 2) * outWidth)] < BACKGROUND_CUT) &&
                       (outBlue[x + 1 + ((y - 2) * outWidth)] < BACKGROUND_CUT)))
                        noisePixels++;
                }
                /* two columns right */
                if((x + 2) < outWidth)
                {
                    if((outRed[x + 2 + ((y - 2) * outWidth)] < BACKGROUND_CUT) &&
                       (outGreen[x + 2 + ((y - 2) * outWidth)] < BACKGROUND_CUT) ||
                       ((outGreen[x + 2 + ((y - 2) * outWidth)] < BACKGROUND_CUT) &&
                       (outBlue[x + 2 + ((y - 2) * outWidth)] < BACKGROUND_CUT)))
                        noisePixels++;
                }
            } /* end two rows up */

            /* one row up */
            if((y - 1) > 0)
            {
                /* two columns left */
                if((x - 2) > 0)
                {
                    if((outRed[x - 2 + ((y - 1) * outWidth)] < BACKGROUND_CUT) &&
                       (outGreen[x - 2 + ((y - 1) * outWidth)] < BACKGROUND_CUT) ||
                       ((outGreen[x - 2 + ((y - 1) * outWidth)] < BACKGROUND_CUT) &&
                       (outBlue[x - 2 + ((y - 1) * outWidth)] < BACKGROUND_CUT)))
                        noisePixels++;
                }
                /* one column left */
                if((x - 1) > 0)
                {
                    if((outRed[x - 1 + ((y - 1) * outWidth)] < BACKGROUND_CUT) &&
                       (outGreen[x - 1 + ((y - 1) * outWidth)] < BACKGROUND_CUT) ||
                       ((outGreen[x - 1 + ((y - 1) * outWidth)] < BACKGROUND_CUT) &&
                       (outBlue[x - 1 + ((y - 1) * outWidth)] < BACKGROUND_CUT)))
                        noisePixels++;
                }

                /* current column */
                if((outRed[x + ((y - 1) * outWidth)] < BACKGROUND_CUT) &&
                   (outGreen[x + ((y - 1) * outWidth)] < BACKGROUND_CUT) ||
                   ((outGreen[x + ((y - 1) * outWidth)] < BACKGROUND_CUT) &&
                   (outBlue[x + ((y - 1) * outWidth)] < BACKGROUND_CUT)))
                    noisePixels++;

                /* one column right */
                if((x + 1) < outWidth)
                {
                    if((outRed[x + 1 + ((y - 1) * outWidth)] < BACKGROUND_CUT) &&
                       (outGreen[x + 1 + ((y - 1) * outWidth)] < BACKGROUND_CUT) ||
                       ((outGreen[x + 1 + ((y - 1) * outWidth)] < BACKGROUND_CUT) &&
                       (outBlue[x + 1 + ((y - 1) * outWidth)] < BACKGROUND_CUT)))
                        noisePixels++;
                }
                /* two columns right */
                if((x + 2) < outWidth)
                {
                    if((outRed[x + 2 + ((y - 1) * outWidth)] < BACKGROUND_CUT) &&
                       (outGreen[x + 2 + ((y - 1) * outWidth)] < BACKGROUND_CUT) ||
                       ((outGreen[x + 2 + ((y - 1) * outWidth)] < BACKGROUND_CUT) &&
                       (outBlue[x + 2 + ((y - 1) * outWidth)] < BACKGROUND_CUT)))
                        noisePixels++;
                }
            } /* one row up */

            /* current row */
            /* two columns left */
            if((x - 2) > 0)
            {
                if((outRed[x - 2 + (y * outWidth)] < BACKGROUND_CUT) &&
                   (outGreen[x - 2 + (y * outWidth)] < BACKGROUND_CUT) ||
                   ((outGreen[x - 2 + (y * outWidth)] < BACKGROUND_CUT) &&
                   (outBlue[x - 2 + (y * outWidth)] < BACKGROUND_CUT)))
                    noisePixels++;
            }
            /* one column left */
            if((x - 1) > 0)
            {
                if((outRed[x - 1 + (y * outWidth)] < BACKGROUND_CUT) &&
                   (outGreen[x - 1 + (y * outWidth)] < BACKGROUND_CUT) ||
                   ((outGreen[x - 1 + (y * outWidth)] < BACKGROUND_CUT) &&
                   (outBlue[x - 1 + (y * outWidth)] < BACKGROUND_CUT)))
                    noisePixels++;
            }

            /* CENTER PIXEL - current column, current row */
            if((outRed[x + (y * outWidth)] < BACKGROUND_CUT) &&
               (outGreen[x + (y * outWidth)] < BACKGROUND_CUT) ||
               ((outGreen[x + (y * outWidth)] < BACKGROUND_CUT) &&
               (outBlue[x + (y * outWidth)] < BACKGROUND_CUT)))
                noisePixels++;

            /* one column right */
            if((x + 1) < outWidth)
            {
                if((outRed[x + 1 + (y * outWidth)] < BACKGROUND_CUT) &&
                   (outGreen[x + 1 + (y * outWidth)] < BACKGROUND_CUT) ||
                   ((outGreen[x + 1 + (y * outWidth)] < BACKGROUND_CUT) &&
                   (outBlue[x + 1 + (y * outWidth)] < BACKGROUND_CUT)))
                    noisePixels++;
            }
            /* two columns right */
            if((x + 2) < outWidth)
            {
                if((outRed[x + 2 + (y * outWidth)] < BACKGROUND_CUT) &&
                   (outGreen[x + 2 + (y * outWidth)] < BACKGROUND_CUT) ||
                   ((outGreen[x + 2 + (y * outWidth)] < BACKGROUND_CUT) &&
                   (outBlue[x + 2 + (y * outWidth)] < BACKGROUND_CUT)))
                    noisePixels++;
            } /* end current row */

            /* one row down */
            if((y + 1) < outHeight)
            {
                /* two columns left */
                if((x - 2) > 0)
                {
                    if((outRed[x - 2 + ((y + 1) * outWidth)] < BACKGROUND_CUT) &&
                       (outGreen[x - 2 + ((y + 1) * outWidth)] < BACKGROUND_CUT) ||
                       ((outGreen[x - 2 + ((y + 1) * outWidth)] < BACKGROUND_CUT) &&
                       (outBlue[x - 2 + ((y + 1) * outWidth)] < BACKGROUND_CUT)))
                        noisePixels++;
                }
                /* one column left */
                if((x - 1) > 0)
                {
                    if((outRed[x - 1 + ((y + 1) * outWidth)] < BACKGROUND_CUT) &&
                       (outGreen[x - 1 + ((y + 1) * outWidth)] < BACKGROUND_CUT) ||
                       ((outGreen[x - 1 + ((y + 1) * outWidth)] < BACKGROUND_CUT) &&
                       (outBlue[x - 1 + ((y + 1) * outWidth)] < BACKGROUND_CUT)))
                        noisePixels++;
                }

                /* current column */
                if((outRed[x + ((y + 1) * outWidth)] < BACKGROUND_CUT) &&
                   (outGreen[x + ((y + 1) * outWidth)] < BACKGROUND_CUT) ||
                   ((outGreen[x + ((y + 1) * outWidth)] < BACKGROUND_CUT) &&
                   (outBlue[x + ((y + 1) * outWidth)] < BACKGROUND_CUT)))
                    noisePixels++;

                /* one column right */
                if((x + 1) < outWidth)
                {
                    if((outRed[x + 1 + ((y + 1) * outWidth)] < BACKGROUND_CUT) &&
                       (outGreen[x + 1 + ((y + 1) * outWidth)] < BACKGROUND_CUT) ||
                       ((outGreen[x + 1 + ((y + 1) * outWidth)] < BACKGROUND_CUT) &&
                       (outBlue[x + 1 + ((y + 1) * outWidth)] < BACKGROUND_CUT)))
                        noisePixels++;
                }
                /* two columns right */
                if((x + 2) < outWidth)
                {
                    if((outRed[x + 2 + ((y + 1) * outWidth)] < BACKGROUND_CUT) &&
                       (outGreen[x + 2 + ((y + 1) * outWidth)] < BACKGROUND_CUT) ||
                       ((outGreen[x + 2 + ((y + 1) * outWidth)] < BACKGROUND_CUT) &&
                       (outBlue[x + 2 + ((y + 1) * outWidth)] < BACKGROUND_CUT)))
                        noisePixels++;
                }
            } /* end one row down */

            /* two rows down */
            if((y + 2) < outHeight)
            {
                /* two columns left */
                if((x - 2) > 0)
                {
                    if((outRed[x - 2 + ((y + 2) * outWidth)] < BACKGROUND_CUT) &&
                       (outGreen[x - 2 + ((y + 2) * outWidth)] < BACKGROUND_CUT) ||
                       ((outGreen[x - 2 + ((y + 2) * outWidth)] < BACKGROUND_CUT) &&
                       (outBlue[x - 2 + ((y + 2) * outWidth)] < BACKGROUND_CUT)))
                        noisePixels++;
                }
                /* one column left */
                if((x - 1) > 0)
                {
                    if((outRed[x - 1 + ((y + 2) * outWidth)] < BACKGROUND_CUT) &&
                       (outGreen[x - 1 + ((y + 2) * outWidth)] < BACKGROUND_CUT) ||
                       ((outGreen[x - 1 + ((y + 2) * outWidth)] < BACKGROUND_CUT) &&
                       (outBlue[x - 1 + ((y + 2) * outWidth)] < BACKGROUND_CUT)))
                        noisePixels++;
                }

                /* current column */
                if((outRed[x + ((y + 2) * outWidth)] < BACKGROUND_CUT) &&
                   (outGreen[x + ((y + 2) * outWidth)] < BACKGROUND_CUT) ||
                   ((outGreen[x + ((y + 2) * outWidth)] < BACKGROUND_CUT) &&
                   (outBlue[x + ((y + 2) * outWidth)] < BACKGROUND_CUT)))
                    noisePixels++;

                /* one column right */
                if((x + 1) < outWidth)
                {
                    if((outRed[x + 1 + ((y + 2) * outWidth)] < BACKGROUND_CUT) &&
                       (outGreen[x + 1 + ((y + 2) * outWidth)] < BACKGROUND_CUT) ||
                       ((outGreen[x + 1 + ((y + 2) * outWidth)] < BACKGROUND_CUT) &&
                       (outBlue[x + 1 + ((y + 2) * outWidth)] < BACKGROUND_CUT)))
                        noisePixels++;
                }
                /* two columns right */
                if((x + 2) < outWidth)
                {
                    if((outRed[x + 2 + ((y + 2) * outWidth)] < BACKGROUND_CUT) &&
                       (outGreen[x + 2 + ((y + 2) * outWidth)] < BACKGROUND_CUT) ||
                       ((outGreen[x + 2 + ((y + 2) * outWidth)] < BACKGROUND_CUT) &&
                       (outBlue[x + 2 + ((y + 2) * outWidth)] < BACKGROUND_CUT)))
                        noisePixels++;
                }
            } /* end two rows down */

            /* three rows down */
            if((y + 3) < outHeight)
            {
                /* two columns left */
                if((x - 2) > 0)
                {
                    if((outRed[x - 2 + ((y + 3) * outWidth)] < BACKGROUND_CUT) &&
                       (outGreen[x - 2 + ((y + 3) * outWidth)] < BACKGROUND_CUT) ||
                       ((outGreen[x - 2 + ((y + 3) * outWidth)] < BACKGROUND_CUT) &&
                       (outBlue[x - 2 + ((y + 3) * outWidth)] < BACKGROUND_CUT)))
                        noisePixels++;
                }
                /* one column left */
                if((x - 1) > 0)
                {
                    if((outRed[x - 1 + ((y + 3) * outWidth)] < BACKGROUND_CUT) &&
                       (outGreen[x - 1 + ((y + 3) * outWidth)] < BACKGROUND_CUT) ||
                       ((outGreen[x - 1 + ((y + 3) * outWidth)] < BACKGROUND_CUT) &&
                       (outBlue[x - 1 + ((y + 3) * outWidth)] < BACKGROUND_CUT)))
                        noisePixels++;
                }

                /* current column */
                if((outRed[x + ((y + 3) * outWidth)] < BACKGROUND_CUT) &&
                   (outGreen[x + ((y + 3) * outWidth)] < BACKGROUND_CUT) ||
                   ((outGreen[x + ((y + 3) * outWidth)] < BACKGROUND_CUT) &&
                   (outBlue[x + ((y + 3) * outWidth)] < BACKGROUND_CUT)))
                    noisePixels++;

                /* one column right */
                if((x + 1) < outWidth)
                {
                    if((outRed[x + 1 + ((y + 3) * outWidth)] < BACKGROUND_CUT) &&
                       (outGreen[x + 1 + ((y + 3) * outWidth)] < BACKGROUND_CUT) ||
                       ((outGreen[x + 1 + ((y + 3) * outWidth)] < BACKGROUND_CUT) &&
                       (outBlue[x + 1 + ((y + 3) * outWidth)] < BACKGROUND_CUT)))
                        noisePixels++;
                }
                /* two columns right */
                if((x + 2) < outWidth)
                {
                    if((outRed[x + 2 + ((y + 3) * outWidth)] < BACKGROUND_CUT) &&
                       (outGreen[x + 2 + ((y + 3) * outWidth)] < BACKGROUND_CUT) ||
                       ((outGreen[x + 2 + ((y + 3) * outWidth)] < BACKGROUND_CUT) &&
                       (outBlue[x + 2 + ((y + 3) * outWidth)] < BACKGROUND_CUT)))
                        noisePixels++;
                }
            } /* end three rows down */

            /* if there are > numPixels within this region that qualify as ink, consider
               as ink not noise, if there are <= numPixels treat it as noise - remove it */
            if(noisePixels <= numPixels)
            {
                outRed[x + (y * outWidth)] = 255;
                outGreen[x + (y * outWidth)] = 255;
                outBlue[x + (y * outWidth)] = 255;
            }

        }
    } /* end y for loop */
}


/* use the center pixel of a 3 by 3 kernel as the data we want in the output image.
   this does not work very well.
   - used for resizing image */
void CenterFilter(void)
{
    outRed[pos] = centerPixel[RED];
    outGreen[pos] = centerPixel[GREEN];
    outBlue[pos] = centerPixel[BLUE];
}


/* use the average of all the pixels in the 3 by 3 kernel to get the value for
   the current output pixel
   - used for resizing
   - works well, comparable to BSpline filter */
void AverageFilter(void)
{
    float redAverage = 0.0, greenAverage = 0.0, blueAverage = 0.0;
    float redSum = 0.0, greenSum = 0.0, blueSum = 0.0;

    /* sum the red values */
    redSum += centerPixel[RED];
    redSum += leftPixel[RED];
    redSum += rightPixel[RED];
    redSum += topPixel[RED];
    redSum += bottomPixel[RED];
    redSum += topLeftPixel[RED];
    redSum += topRightPixel[RED];
    redSum += bottomLeftPixel[RED];
    redSum += bottomRightPixel[RED];

    /* sum the green values */
    greenSum += centerPixel[GREEN];
    greenSum += leftPixel[GREEN];
    greenSum += rightPixel[GREEN];
    greenSum += topPixel[GREEN];
    greenSum += bottomPixel[GREEN];
    greenSum += topLeftPixel[GREEN];
    greenSum += topRightPixel[GREEN];
    greenSum += bottomLeftPixel[GREEN];
    greenSum += bottomRightPixel[GREEN];

    /* sum the blue values */
    blueSum += centerPixel[BLUE];
    blueSum += leftPixel[BLUE];
    blueSum += rightPixel[BLUE];
    blueSum += topPixel[BLUE];
    blueSum += bottomPixel[BLUE];
    blueSum += topLeftPixel[BLUE];
    blueSum += topRightPixel[BLUE];
    blueSum += bottomLeftPixel[BLUE];
    blueSum += bottomRightPixel[BLUE];

    /* compute the averages */
    redAverage = redSum / 9.0f;
    greenAverage = greenSum / 9.0f;
    blueAverage = blueSum / 9.0f;

    /* make sure doesn't overflow an unsigned char min and max values */
    if(redAverage > 255.0f)
        redAverage = 255.0f;
    if(redAverage < 0.0f)
        redAverage = 0.0f;
    if(greenAverage > 255.0f)
        greenAverage = 255.0f;
    if(greenAverage < 0.0f)
        greenAverage = 0.0f;
    if(blueAverage > 255.0f)
        blueAverage = 255.0f;
    if(blueAverage < 0.0f)
        blueAverage = 0.0f;

    /* assign the ouput colors from the computed average */
    outRed[pos] = (unsigned char)redAverage;
    outGreen[pos] = (unsigned char)greenAverage;
    outBlue[pos] = (unsigned char)blueAverage;
}



/* use the b-spline values of all pixels in the 3 by 3 kernel to get the value for
   the current output pixel 
   KERNEL used:
        1   2   1
        2   4   2
        1   2   1

    - used for resizing 
    - works well */
void BSplineFilter(void)
{
    float redAverage = 0.0, greenAverage = 0.0, blueAverage = 0.0;
    float redSum = 0.0, greenSum = 0.0, blueSum = 0.0;

    /* sum the red values according to bspline values */
    redSum += 4 * centerPixel[RED];
    redSum += 2 * leftPixel[RED];
    redSum += 2 * rightPixel[RED];
    redSum += 2 * topPixel[RED];
    redSum += 2 * bottomPixel[RED];
    redSum += topLeftPixel[RED];
    redSum += topRightPixel[RED];
    redSum += bottomLeftPixel[RED];
    redSum += bottomRightPixel[RED];

    /* sum the green values according to bspline values */
    greenSum += 4 * centerPixel[GREEN];
    greenSum += 2 * leftPixel[GREEN];
    greenSum += 2 * rightPixel[GREEN];
    greenSum += 2 * topPixel[GREEN];
    greenSum += 2 * bottomPixel[GREEN];
    greenSum += topLeftPixel[GREEN];
    greenSum += topRightPixel[GREEN];
    greenSum += bottomLeftPixel[GREEN];
    greenSum += bottomRightPixel[GREEN];

    /* sum the blue values according to bspline values */
    blueSum += 4 * centerPixel[BLUE];
    blueSum += 2 * leftPixel[BLUE];
    blueSum += 2 * rightPixel[BLUE];
    blueSum += 2 * topPixel[BLUE];
    blueSum += 2 * bottomPixel[BLUE];
    blueSum += topLeftPixel[BLUE];
    blueSum += topRightPixel[BLUE];
    blueSum += bottomLeftPixel[BLUE];
    blueSum += bottomRightPixel[BLUE];

    /* divide by the total bspline filter sum which is 16 */
    redAverage = redSum / 16.0f;
    greenAverage = greenSum / 16.0f;
    blueAverage = blueSum / 16.0f;

    /* make sure doesn't overflow an unsigned char min and max values */
    if(redAverage > 255.0f)
        redAverage = 255.0f;
    if(redAverage < 0.0f)
        redAverage = 0.0f;
    if(greenAverage > 255.0f)
        greenAverage = 255.0f;
    if(greenAverage < 0.0f)
        greenAverage = 0.0f;
    if(blueAverage > 255.0f)
        blueAverage = 255.0f;
    if(blueAverage < 0.0f)
        blueAverage = 0.0f;

    /* assign the ouput colors from the computed average */
    outRed[pos] = (unsigned char)redAverage;
    outGreen[pos] = (unsigned char)greenAverage;
    outBlue[pos] = (unsigned char)blueAverage;
}



/* flatten all ink colors by a specified value */
void Flatten(void)
{
    int i = 0, value = 0;

    for(i = 0; i < outWidth * outHeight; i++)
    {
        /* make anti-aliased ink pixels slightly darker */
        if(((outRed[i] < 255) && (outRed[i] > BACKGROUND_CUT) &&
            (outGreen[i] < 255) && (outGreen[i] > BACKGROUND_CUT)) ||
           ((outBlue[i] < 255) && (outBlue[i] > BACKGROUND_CUT) &&
            (outGreen[i] < 255) && ( outGreen[i] > BACKGROUND_CUT)) &&
            ((outRed[i] < BACKGROUND_CUT) || (outGreen[i] < BACKGROUND_CUT) ||
             (outBlue[i] < BACKGROUND_CUT)))
        {
            value = outRed[i];
            value -= 30;
            if(value < 0)
                value = 0;
            outRed[i] = value;

            value = outGreen[i];
            value -= 30;
            if(value < 0)
                value = 0;
            outGreen[i] = value;

            value = outBlue[i];
            value -= 30;
            if(value < 0)
                value = 0;
            outBlue[i] = value;
        }
        /* set ink pixels */
        else if(((outRed[i] < BACKGROUND_CUT) && (outGreen[i] < BACKGROUND_CUT)) ||
           ((outGreen[i] < BACKGROUND_CUT) && (outBlue[i] < BACKGROUND_CUT)))
        {
            outRed[i] = 0;
            outGreen[i] = 0;
            outBlue[i] = 0;
        }
    }
}



/* calculate a range, min, and max for the ink colors based on luminance */
void CalculateColorRange(void)
{
    int i = 0, value = 0;

    redInkMax = 0;
    redInkMin = 255;
    greenInkMax = 0;
    greenInkMin = 255;
    blueInkMax = 0;
    blueInkMin = 255;

    /* calculate the color range, min, and max */
    for(i = 0; i < outWidth * outHeight; i++)
    {
        value = ((int)(.299 * (float)outRed[i] + .587 * (float)outGreen[i]
                + .114 * (float)outBlue[i]));
        if(value > 255)
            value = 255;
        else if(value < 0)
            value = 0;

        /* red ink */
        if((outRed[i] >= outGreen[i] + 50) && (outRed[i] >= outBlue[i] + 50))
        {
            if(value > redInkMax)
                redInkMax = value;
            if(value < redInkMin)
                redInkMin = value;
        }
        /* green ink */
        else if((outGreen[i] >= outRed[i] + 50) && (outGreen[i] >= outBlue[i] + 50))
        {
            if(value > greenInkMax)
                greenInkMax = value;
            if(value < greenInkMin)
                greenInkMin = value;
        }
        /* blue ink */
        else if((outBlue[i] >= outRed[i] + 50) && (outBlue[i] >= outGreen[i] + 50))
        {
            if(value > blueInkMax)
                blueInkMax = value;
            if(value < blueInkMin)
                blueInkMin = value;
        }
    } /* end for loop */

    /* store the ranges */
    redInkRange = redInkMax - redInkMin;
    greenInkRange = greenInkMax - greenInkMin;
    blueInkRange = blueInkMax - blueInkMin;
}



/* set the colors according to the output image RGB values */
void SetColors(void)
{
    int x = 0, y = 0, i = 0;
    int value = 0;
    float scale = 0.0f;

    for(y = 0; y < outHeight; y++)
    {
        for(x = 0; x < outWidth; x++)
        {
            i = x + y * outWidth;
            if((outRed[i] > BACKGROUND_CUT) && (outGreen[i] > BACKGROUND_CUT))
            {
                outRed[i] = 255;
                outGreen[i] = 255;
                outBlue[i] = 255;
            }
            else if((outGreen[i] > BACKGROUND_CUT) && (outBlue[i] > BACKGROUND_CUT))
            {
                outRed[i] = 255;
                outGreen[i] = 255;
                outBlue[i] = 255;
            }
            /* ink colors */
            else
            {
                /* if RED is the largest RGB component, consider it as red ink */
                if((outRed[i] >= outGreen[i] + 50) && (outRed[i] >= outBlue[i] + 50))
                {
                    /* do a luminance calculation to set the red value */
                    value = ((int)(.299 * (float)outRed[i] + .587 * (float)outGreen[i]
                            + .114 * (float)outBlue[i]));
                    scale = outRed[i];
                    outRed[i] = (unsigned char)StandardizeColors((unsigned char)value, RED);
                    scale /= (float)outRed[i];

                    value = (int)((float)outGreen[i] / scale);
                    if(value < 0)
                        value = 0;
                    outGreen[i] = (unsigned char)value;

                    value = (int)((float)outBlue[i] / scale);
                    if(value < 0)
                        value = 0;
                    outBlue[i] = (unsigned char)value;
                }
                /* if GREEN is the largest RGB component, consider it as green ink */
                else if((outGreen[i] >= outRed[i] + 50) && (outGreen[i] >= outBlue[i] + 50))
                {
                    /* do a luminance calculation to set the green value */
                    value = ((int)(.299 * (float)outRed[i] + .587 * (float)outGreen[i]
                            + .114 * (float)outBlue[i]));
                    scale = outGreen[i];
                    outGreen[i] = (unsigned char)StandardizeColors((unsigned char)value, GREEN);
                    scale /= (float)outGreen[i];

                    value = (int)((float)outRed[i] / scale);
                    if(value < 0)
                        value = 0;
                    outRed[i] = (unsigned char)value;

                    value = (int)((float)outBlue[i] / scale);
                    if(value < 0)
                        value = 0;
                    outBlue[i] = (unsigned char)value;
                }
                /* if BLUE is the largest RGB component, consider it as blue ink */
                else if((outBlue[i] >= outRed[i] + 50) && (outBlue[i] >= outGreen[i] + 50))
                {
                    /* do a luminance calculation to set the blue value */
                    value = ((int)(.299 * (float)outRed[i] + .587 * (float)outGreen[i]
                            + .114 * (float)outBlue[i]));
                    scale = outBlue[i];
                    outBlue[i] = (unsigned char)StandardizeColors((unsigned char)value, BLUE);
                    scale /= (float)outBlue[i];

                    value = (int)((float)outRed[i] / scale);
                    if(value < 0)
                        value = 0;
                    outRed[i] = (unsigned char)value;

                    value = (int)((float)outGreen[i] / scale);
                    if(value < 0)
                        value = 0;
                    outGreen[i] = (unsigned char)value;
                }
                /* otherwise, we have grays */
                else
                {
                    /* do a luminance calculation for grays, scale to ten */
                    value = ((int)(.299 * (float)outRed[i] + .587 * (float)outGreen[i]
                            + .114 * (float)outBlue[i])) / 25;
                    value = value * 15; /* scaling factor */

                    if(value < 0)
                        value = 0;
                    else if(value > 255)
                        value = 255;

                    outRed[i] = (unsigned char)value;
                    outGreen[i] = (unsigned char)value;
                    outBlue[i] = (unsigned char)value;
                }
            }
        } /* end x for loop */
    } /* end y for loop */
} /* end SetColors method */


/* use the values calculated by CalculateColorRange to set values to 10 different
   values for the different inks
   - value is the luminance of the current pixel
   - color is RED, GREEN, or BLUE */
int StandardizeColors(unsigned char value, int color)
{
    int returnValue = 0;

    /* red ink colors */
    if(color == RED)
    {
        if((((float)value - (float)redInkMin) / (float)redInkRange) < .100)
        {
            returnValue = 10;
        }
        else if((((float)value - (float)redInkMin) / (float)redInkRange) < .200)
        {
            returnValue = 20;
        }
        else if((((float)value - (float)redInkMin) / (float)redInkRange) < .300)
        {
            returnValue = 30;
        }
        else if((((float)value - (float)redInkMin) / (float)redInkRange) < .400)
        {
            returnValue = 40;
        }
        else if((((float)value - (float)redInkMin) / (float)redInkRange) < .500)
        {
            returnValue = 50;
        }
        else if((((float)value - (float)redInkMin) / (float)redInkRange) < .600)
        {
            returnValue = 60;
        }
        else if((((float)value - (float)redInkMin) / (float)redInkRange) < .700)
        {
            returnValue = 70;
        }
        else if((((float)value - (float)redInkMin) / (float)redInkRange) < .800)
        {
            returnValue = 80;
        }
        else if((((float)value - (float)redInkMin) / (float)redInkRange) < .900)
        {
            returnValue = 90;
        }
        else
        {
            returnValue = 100;
        }
    }
    /* green ink colors */
    else if(color == GREEN)
    {
        if((((float)value - (float)greenInkMin) / (float)greenInkRange) < .100)
        {
            returnValue = 10;
        }
        else if((((float)value - (float)greenInkMin) / (float)greenInkRange) < .200)
        {
            returnValue = 20;
        }
        else if((((float)value - (float)greenInkMin) / (float)greenInkRange) < .300)
        {
            returnValue = 30;
        }
        else if((((float)value - (float)greenInkMin) / (float)greenInkRange) < .400)
        {
            returnValue = 40;
        }
        else if((((float)value - (float)greenInkMin) / (float)greenInkRange) < .500)
        {
            returnValue = 50;
        }
        else if((((float)value - (float)greenInkMin) / (float)greenInkRange) < .600)
        {
            returnValue = 60;
        }
        else if((((float)value - (float)greenInkMin) / (float)greenInkRange) < .700)
        {
            returnValue = 70;
        }
        else if((((float)value - (float)greenInkMin) / (float)greenInkRange) < .800)
        {
            returnValue = 80;
        }
        else if((((float)value - (float)greenInkMin) / (float)greenInkRange) < .900)
        {
            returnValue = 90;
        }
        else
        {
            returnValue = 100;
        }
    }
    /* blue ink colors */
    else if(color == BLUE)
    {
        if((((float)value - (float)blueInkMin) / (float)blueInkRange) < .100)
        {
            returnValue = 10;
        }
        else if((((float)value - (float)blueInkMin) / (float)blueInkRange) < .200)
        {
            returnValue = 20;
        }
        else if((((float)value - (float)blueInkMin) / (float)blueInkRange) < .300)
        {
            returnValue = 30;
        }
        else if((((float)value - (float)blueInkMin) / (float)blueInkRange) < .400)
        {
            returnValue = 40;
        }
        else if((((float)value - (float)blueInkMin) / (float)blueInkRange) < .500)
        {
            returnValue = 50;
        }
        else if((((float)value - (float)blueInkMin) / (float)blueInkRange) < .600)
        {
            returnValue = 60;
        }
        else if((((float)value - (float)blueInkMin) / (float)blueInkRange) < .700)
        {
            returnValue = 70;
        }
        else if((((float)value - (float)blueInkMin) / (float)blueInkRange) < .800)
        {
            returnValue = 80;
        }
        else if((((float)value - (float)blueInkMin) / (float)blueInkRange) < .900)
        {
            returnValue = 90;
        }
        else
        {
            returnValue = 100;
        }
    }
 
    return returnValue;
}


/* delete all allocated memory */
void Cleanup(void)
{
    free(red);
    free(green);
    free(blue);
    free(outRed);
    free(outGreen);
    free(outBlue);
    free(data);
}


unsigned char GetRed(int i)
{
    return outRed[i];
}


unsigned char GetGreen(int i)
{
    return outGreen[i];
}


unsigned char GetBlue(int i)
{
    return outBlue[i];
}



/* debug dump */
void dump(void)
{
    printf("Width  = %d.\n", width);
    printf("Height = %d.\n", height);
    printf("outWidth = %d.\n", outWidth);
    printf("outHeight = %d.\n", outHeight);
}

