#  Craig R. Farrand
#  April 15, 1999
#  Computer Science 699


#  Provides an automated process to clean up images in the
#  current directory using the Note class.  The current directory
#  will be scanned for files that are .tif images, the images will then
#  be opened, cleaned, cut out to an 8 1/2 by 11 inch size, and then
#  written out in GIF format.  The newly created GIF files will be
#  used by the webpage that is automatically generated.

import os
import sys
import string
# load in the note class
from notes import *


#### MAIN SCRIPT ####

# get a list of all the files in the current directory
files = os.listdir(".")

# sort the files
files.sort()

temp = []

# remove all non .TIF strings from the list
for i in files[:]:
	filename, ext = os.path.splitext(i)
	if(ext == [] or ((ext != ".tif") and (ext != ".TIF"))):
		files.remove(i)
	# else store the string in a temp list
	else:
		temp.append(i)

# rename files with endings like notes1.tif to notes01.tif so when we reload
# the current directory's files, they will be sorted correctly.
# This will support files from 0 to 99 endings (notes00.tif to notes99.tif)
# which should be more than sufficient.
listPos = 0
for i in temp[:]:
	# process strings up to the dot
	tempString = ""
	curChar = ""
	found = 0
	count = 0
	while(curChar != "."):
		curChar = i[count]
		# files ending in numbers >= 10   (two digit endings)
		# mark as found so we don't add fill zeros before numbers greater than 9
		if((found == 0) and (curChar == '0' or curChar == '1' or curChar == '2' \
			or curChar == '3' or curChar == '4' or curChar == '5' or curChar == '6' \
			or curChar == '7' or curChar == '8' or curChar == '9') and (i[count + 1] != ".")):
			found = 1

		# add a leading zero to filenames that end with only one digit
		# such as notes1.tif will be changed to notes01.tif
		elif((found == 0) and (curChar == '0' or curChar == '1' or curChar == '2' \
			or curChar == '3' or curChar == '4' or curChar == '5' or curChar == '6' \
			or curChar == '7' or curChar == '8' or curChar == '9') and (i[count + 1] == ".")):
			found = 1
			tempString = tempString + "0"

		tempString = tempString + curChar
		count = count + 1

	tempString = tempString + "tif"
	# rename the file, if we've changed the name
	if(i != tempString):
		print "Renaming file %s to %s" % (i, tempString)
		os.rename(i, tempString)
	listPos = listPos + 1

# now the files are renamed so they will sort correctly
# reload the list of all the files in the current directory
files = os.listdir(".")

# sort the files
files.sort()

# keep track of the number of images we are processing
numImages = 0

# remove all non .TIF strings from the list
for i in files[:]:
	filename, ext = os.path.splitext(i)
	if(ext == [] or ((ext != ".tif") and (ext != ".TIF"))):
		files.remove(i)
	else:
		numImages = numImages + 1

# instance of the note class
note = Note()

# create the files for the webpage
index = open("index.html", "w")
index.write("<HTML>\n")
index.write("<HEAD>\n")
index.write("<TITLE>Notes</TITLE>\n")
index.write("</HEAD>\n\n")
index.write("<FRAMESET cols = \"150, *\">\n")
index.write("<FRAME NAME = \"contents\" target = \"main\" src = \"frame.html\">\n")
index.write("<FRAME NAME = \"main\" src = \"page01.html\">\n")
index.write("<NOFRAMES>\n")
index.write("<BODY>\n")

# left frame window
frame = open("frame.html", "w")
frame.write("<HTML>\n<base target=\"main\">\n<BODY>\n")

# the main frame window
#main = open("main.html", "w")
#main.write("<HTML>\n<BODY>\n")
#main.write("</BODY>\n</HTML>\n")
#main.close()


count = 1

# do for all files in the current directory
for i in files[:]:
	# print "i is %s" % (i)
	filename, ext = os.path.splitext(i)

	# process TIF images as input
	if((ext == ".tif") or (ext == ".TIF")):
		# open the next TIf input image
		note.Open(i)
		# extract the region that contains the sheet
		note.Extract()

		# resize the image to roughly 8 1/2 x 11 inches in GIF
		# file format, which is 72 pixels per inch in PIL.
		# note.Resize()
		# set the background to white
		# note.SetBackground()

		# use the new NoteModule method
		note.ApplyNoteModule()

		# save the final output image
		outfile = "page" + "%02d" % (count) + ".gif"
		note.Save(outfile)

		# save a more printable version of the image, most likely will look bad
		# visually, but will print nice in black and white
		note.MakePrintable()

		# save the more printable version of the image
		printfile = "print" + "%02d" % (count) + ".gif"
		note.Save(printfile)

		# create the new html page for the current image
		pageName = "page" + "%02d" % (count) + ".html"
		htmlPage = open("%s" % (pageName), "w")
		htmlPage.write("<HTML>\n<TITLE>Page %d</TITLE>\n<BODY>\n" % (count))

		# if there is a previous page, use the prev image to reference it
		htmlPage.write("<CENTER>\n")
		if(count > 1):
			prevPageName = "page" + "%02d" % (count - 1) + ".html"
			htmlPage.write("<A HREF = \"%s\"><IMG SRC = \"prev.gif\" alt = \"Previous\" " \
				 % (prevPageName) + "border = \"0\"></A>&nbsp;&nbsp;\n")
		
		# between the two buttons, write the page number
		htmlPage.write("Page %d &nbsp;&nbsp;\n" % (count))

		# if there is a next page, use the next image to reference it
		if(count < numImages):
			nextPageName = "page" + "%02d" % (count + 1) + ".html"
			htmlPage.write("<A HREF = \"%s\"><IMG SRC = \"next.gif\" alt = \"Next\" " \
				 % (nextPageName) +	"border = \"0\"></A>\n")
		htmlPage.write("</CENTER>\n")
		htmlPage.write("<BR>\n")

		htmlPage.write("<CENTER>\n")
		htmlPage.write("<IMG SRC = \"%s\" alt=\"Page %d (%s)\">\n" % (outfile, count, outfile))
		htmlPage.write("</CENTER>\n")
		htmlPage.write("<BR>\n")

		# rewrite the navigation arrows at the bottom, since the image more than
		# the full screen size
		# if there is a previous page, use the prev image to reference it
		htmlPage.write("<CENTER>\n")
		if(count > 1):
			prevPageName = "page" + "%02d" % (count - 1) + ".html"
			htmlPage.write("<A HREF = \"%s\"><IMG SRC = \"prev.gif\" alt = \"Previous\" " \
				% (prevPageName) + "border = \"0\"></A>&nbsp;&nbsp;\n")
		
		# between the two buttons, write the page number
		htmlPage.write("Page %d &nbsp;&nbsp;\n" % (count))

		# if there is a next page, use the next image to reference it
		if(count < numImages):
			nextPageName = "page" + "%02d" % (count + 1) + ".html"
			htmlPage.write("<A HREF = \"%s\"><IMG SRC = \"next.gif\" alt = \"Next\" " \
				% (nextPageName) + "border = \"0\"></A>\n")
		htmlPage.write("</CENTER>\n")

		htmlPage.write("</BODY>\n</HTML>\n")
		htmlPage.close()

		# write the page reference into the frame.html file
		frame.write("<P><CENTER>\n")
		frame.write("<A HREF = \"%s\">Page %d</A>\n" % (pageName, count))
		frame.write("</CENTER></P>\n")

		# write entries into the index.html files for browsers with no frames
		index.write("<P><CENTER>\n")
		index.write("<A HREF = \"%s\">Page %d</A>\n" % (pageName, count))
		index.write("</CENTER></P>\n")

		count  = count + 1


# finish up the frame.html file
frame.write("</BODY>\n</HTML>")
frame.close()

# finish up the index.html file
index.write("</BODY>\n")
index.write("</NOFRAMES>\n")
index.write("</FRAMESET>\n")
index.write("</HTML>\n")
index.close()




